//
// Copyright (C) 2020 Ross Martin
//
// Versions
//
// 2018.01.25  Coding begun
// 2020.05.07  Added version with reset

`define w assign
`define r always@(posedge clk)

   
(* DONT_TOUCH = "YES" *)
module delay_with_reset
  #( 
     parameter   DELAY                = 0,
     parameter   BIT_WIDTH            = 1,

     parameter  TOTAL_BITS            = BIT_WIDTH*DELAY,
     parameter  SHIFTED_BITS          = TOTAL_BITS - BIT_WIDTH
   )
   (
    input                  reset,
    input                  clk,
    input [BIT_WIDTH-1:0]  in_i,
    output [BIT_WIDTH-1:0] out_o
   );

   generate
      if(DELAY==0)
        begin
           `w out_o = in_i;
        end
      else if(DELAY==1)
        begin
           reg [BIT_WIDTH-1:0] buffer_r = 0;
           `r buffer_r <= reset ? 0 : in_i;
           `w out_o = buffer_r;
        end
      else
        begin
           reg [TOTAL_BITS-1:0] buffer_r = 0;
           `r buffer_r <= reset ? 0 : { buffer_r[SHIFTED_BITS-1:0], in_i };
           `w out_o = buffer_r[SHIFTED_BITS +: BIT_WIDTH];
        end

   endgenerate
            
endmodule // delay

