//
// Copyright (C) 2018 Ross Martin
//
// Versions
//
// 2018.03.21  Coding begun

`define w assign
`define r always@(posedge clk)


//(* DONT_TOUCH = "YES" *)
module sine_two_port_rom
  #(
    parameter  ROM_FILENAME    = "rom_test_hex.dat",
    parameter  ROM_FILE_OFFSET = 0,
    parameter  ROM_FILE_LENGTH = 0,
    parameter  ROM_ITEM_WIDTH  = 36,
    parameter  ROM_ITEM_NUMBER = 1,
    parameter  ROM_WIDTH       = ROM_ITEM_WIDTH * ROM_ITEM_NUMBER,
    parameter  ROM_LENGTH      = 1000,
    parameter  ADDR_WIDTH      = $clog2(ROM_LENGTH)
   )
   (
    input                           clk,
    input [ADDR_WIDTH-1:0]          addr_0_i,
    input [ADDR_WIDTH-1:0]          addr_1_i,
    output reg [ROM_ITEM_WIDTH-1:0] data_0_ro [0:ROM_ITEM_NUMBER-1+1],  // +1 gets around a bug in iVerilog passing array with 1 element
    output reg [ROM_ITEM_WIDTH-1:0] data_1_ro [0:ROM_ITEM_NUMBER-1+1]
   );

   genvar                            item;

   initial
     begin
	integer ii;

        for(ii=0; ii<ROM_ITEM_NUMBER; ii=ii+1)
          begin
	     data_0_ro[ii] = 0;
	     data_1_ro[ii] = 0;
          end
     end


   reg [ADDR_WIDTH-1:0]          addr_0_r;
   reg [ADDR_WIDTH-1:0]          addr_1_r;

   `r addr_0_r <= addr_0_i;
   `r addr_1_r <= addr_1_i;
   
   //
   // ALT_METHOD_1 relies on the synthesizer to be smart enough to not duplicate the
   // entire array from_from_file when only a piece of it is used.
   //
`define ALT_METHOD_1   
`ifdef ALT_METHOD_1
   generate
      if ( ROM_LENGTH < 65 )
	begin

	   (* ROM_STYLE = "distributed" *)
           reg [ROM_WIDTH-1:0]   rom_from_file[0:ROM_FILE_LENGTH-1];
           initial $readmemh(ROM_FILENAME, rom_from_file);

	   reg [ROM_WIDTH-1:0]   data_0_r = 0;
	   reg [ROM_WIDTH-1:0]   data_1_r = 0;

	   `r data_0_r <= rom_from_file[addr_0_r+ROM_FILE_OFFSET];
	   `r data_1_r <= rom_from_file[addr_1_r+ROM_FILE_OFFSET];

           for(item=0; item<ROM_ITEM_NUMBER; item=item+1)
             begin
	        `r data_0_ro[item] <= data_0_r[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
	        `r data_1_ro[item] <= data_1_r[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
             end
           
	end // if ( ROM_LENGTH < 65 )
      else
	begin

	   (* ROM_STYLE = "block" *) 
	   reg [ROM_WIDTH-1:0] 	       rom_from_file[0:ROM_FILE_LENGTH-1];
           initial $readmemh(ROM_FILENAME, rom_from_file);

	   reg [ROM_WIDTH-1:0] 	       data_0_r = 0;
	   reg [ROM_WIDTH-1:0] 	       data_1_r = 0;
           
	   `r data_0_r <= rom_from_file[addr_0_r+ROM_FILE_OFFSET];
	   `r data_1_r <= rom_from_file[addr_1_r+ROM_FILE_OFFSET];

           for(item=0; item<ROM_ITEM_NUMBER; item=item+1)
             begin
	        `r data_0_ro[item] <= data_0_r[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
	        `r data_1_ro[item] <= data_1_r[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
             end

	end // else: !if( ROM_LENGTH < 65 )
   endgenerate
`endif
   
`ifdef ONE_WAY_TO_LOAD_RAMS
   generate

      if ( ROM_LENGTH < 65 )
	begin

	   (* ROM_STYLE = "distributed" *)
	   reg [ROM_WIDTH-1:0] 	       rom_t[0:ROM_LENGTH-1];
	   reg [ROM_WIDTH-1:0] 	       data_0_r = 0;
	   reg [ROM_WIDTH-1:0] 	       data_1_r = 0;

	   `r data_0_r <= rom_t[addr_0_r];
	   `r data_1_r <= rom_t[addr_1_r];

           for(item=0; item<ROM_ITEM_NUMBER; item=item+1)
             begin
	        `r data_0_ro[item] <= data_0_r[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
	        `r data_1_ro[item] <= data_1_r[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
             end
           
	   initial begin : init_aaa
	      integer i;
              $readmemh(ROM_FILENAME, rom_from_file);
	      for(i=0; i<ROM_LENGTH; i = i+1)
                begin
                   rom_t[i] = rom_from_file[i+ROM_FILE_OFFSET];
	           //$display("RFO=%d, TPR[%d]=%8x", ROM_FILE_OFFSET, i, rom_t[i]);
	        end
           end

	end // if ( ROM_LENGTH < 65 )
      else
	begin

	   (* ROM_STYLE = "block" *) 
	   reg [ROM_WIDTH-1:0] 	       rom_t[0:ROM_LENGTH-1];
	   reg [ROM_WIDTH-1:0] 	       data_0_r = 0;
	   reg [ROM_WIDTH-1:0] 	       data_1_r = 0;

	   `r data_0_r <= rom_t[addr_0_r];
	   `r data_1_r <= rom_t[addr_1_r];

           for(item=0; item<ROM_ITEM_NUMBER; item=item+1)
             begin
	        `r data_0_ro[item] <= data_0_r[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
	        `r data_1_ro[item] <= data_1_r[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
             end

	   initial begin : init_bbb
	      integer i;
              $readmemh(ROM_FILENAME, rom_from_file);
	      for(i=0; i<ROM_LENGTH; i = i+1)
                begin
                   rom_t[i] = rom_from_file[i+ROM_FILE_OFFSET];
	      //   $display("TW[%d]=%8x", i, rom_t[i]);
	        end
           end

	end // else: !if( ROM_LENGTH < 65 )
   endgenerate
   
`endif //  `ifdef ONE_WAY_TO_LOAD_RAMS





   
endmodule // rom

