//
// Copyright (C) 2021 Ross Martin
//
// Versions
//
// 2021.11.10  Coding begun

`undef w
`define w assign
`undef r
`define r always@(posedge clk)
`timescale  1 ps / 1 ps   
   
module shift_left_with_saturate
  #(
    
    parameter   REAL_WIDTH             = 25,
    parameter   SHIFT_LEFT             = 1
   )
   (
     input                              clk,
     input signed [REAL_WIDTH-1:0]      in_i,
     output reg signed [REAL_WIDTH-1:0] out_ro
   );

   initial out_ro = 0;
   
   generate

      if(SHIFT_LEFT==0)
        begin : shift_left_zero
           `r out_ro <= in_i;
        end
      else
        begin : shift_left_nonzero

           // Positive overflow when all bits shifted off aren't zero, or the remaining new sign bit isn't also zero.
           // Negative overflow when all bits shifted off aren't one, or the remaining new sign bit isn't also one.
           // Negative overflow also when the remaining non-sign bits "bottom_bits" are all zero, since leaving this 
           // in would result in non-symmetric saturation.
           // i.e.
           // If there was overflow, saturate to the same value positive as negative (don't introduce a saturation bias)
           // Never let the negative value exceed this max.
           
           wire                              sign_bit_w;
           wire [SHIFT_LEFT:0]               top_bits_w;
           wire [REAL_WIDTH-SHIFT_LEFT-2:0]  bottom_bits_w;
           wire                              overflow_positive_w;
           wire                              overflow_negative_w;
           wire [REAL_WIDTH-1:0]             max_positive_w;
           wire [REAL_WIDTH-1:0]             max_negative_w;
           
           `w sign_bit_w    =  in_i[REAL_WIDTH-1];
           `w top_bits_w    =  in_i[REAL_WIDTH-1:REAL_WIDTH-SHIFT_LEFT-1];
           `w bottom_bits_w =  in_i[REAL_WIDTH-SHIFT_LEFT-2:0];

           `w overflow_positive_w =   (sign_bit_w==0) && (top_bits_w != 0);
           `w overflow_negative_w = ( (sign_bit_w==1) && (top_bits_w != {(SHIFT_LEFT+1){1'b1}}) ) ||
                                    ( (sign_bit_w==1) && (bottom_bits_w == 0) );

           `w max_positive_w = { 1'b0, {(REAL_WIDTH-2){1'b1}}, 1'b1 };
           `w max_negative_w = { 1'b1, {(REAL_WIDTH-2){1'b0}}, 1'b1 };
           

           `r out_ro <= overflow_positive_w  ?  max_positive_w     :
                        overflow_negative_w  ?  max_negative_w     :
                        /**/                    in_i << SHIFT_LEFT ;
                                                 
        end

   endgenerate            

endmodule // shift_left_with_saturate


