//
// Copyright (C) 2018 Ross Martin
//
// Versions
//
// 2018.03.21  Coding begun

`timescale 1ps / 1ps

`define w assign
`define r always@(posedge clk)

/* verilator lint_off WIDTHEXPAND  */
/* verilator lint_off WIDTHTRUNC  */


(* DONT_TOUCH = "YES" *)
module spectrum_pfb_two_port_rom
  #(
    parameter  ROM_FILENAME     = "rom_test_hex.dat",
    parameter  ROM_FILE_OFFSET  = 0,
    parameter  ROM_FILE_LENGTH  = 0,
    parameter  ROM_ITEM_WIDTH   = 36,
    parameter  ROM_ITEM_NUMBER  = 1,
    parameter  ROM_WIDTH        = ROM_ITEM_WIDTH * ROM_ITEM_NUMBER,
    parameter  ROM_LENGTH       = 1000,
    parameter  ADDR_WIDTH       = $clog2(ROM_LENGTH)
   )
   (
    input                           clk,
    input [ADDR_WIDTH-1:0]          addr_0_i,
    input [ADDR_WIDTH-1:0]          addr_1_i,
    output [ROM_ITEM_WIDTH-1:0]     data_0_ro [0:ROM_ITEM_NUMBER-1+1],  // +1 gets around a bug in iVerilog passing array with 1 element
    output [ROM_ITEM_WIDTH-1:0]     data_1_ro [0:ROM_ITEM_NUMBER-1+1]
   );

   genvar                            item;
   genvar                            rom;
   
   //localparam MAX_ROM_LENGTH = 128;  // A small value forces it into this case for testing.
   localparam MAX_ROM_LENGTH = 32768;  // MUST be a power of 2
   localparam ROM_BITS = $clog2(MAX_ROM_LENGTH);

   //
   // This method gives up, and just reads from separate files.  File name is original file name with _INDEX
   // added, where INDEX is the number of the ROM, and ROM_FILE_OFFSET is the number of the ROM times ROM_LENGTH
   //
   generate

      //localparam INDEX = ROM_FILE_OFFSET / ROM_LENGTH;
      //localparam INDEX_UNITS = INDEX % 10;
      //localparam INDEX_TENS  = INDEX / 10;
      //localparam [7:0] INDEX_UNITS_ASCII = INDEX_UNITS + "0";
      //localparam [7:0] INDEX_TENS_ASCII  = INDEX_TENS + "0";
      
      //localparam THIS_FILENAME = {INDEX_TENS_ASCII, INDEX_UNITS_ASCII, "_", ROM_FILENAME};

      //initial $display("THIS_FILENAME=%s", THIS_FILENAME);

      if ( ROM_LENGTH < 65 )
	begin : label_0
           
	   (* ROM_STYLE = "distributed" *)
           reg [ROM_WIDTH-1:0]   rom_t[0:ROM_LENGTH-1];
	   reg [ROM_WIDTH-1:0]   data_0_r = 0;
	   reg [ROM_WIDTH-1:0]   data_1_r = 0;
	   reg [ROM_WIDTH-1:0]   data_0_rr = 0;
	   reg [ROM_WIDTH-1:0]   data_1_rr = 0;
	   reg [ROM_WIDTH-1:0]   data_0_rrr = 0;
	   reg [ROM_WIDTH-1:0]   data_1_rrr = 0;

           //reg [ADDR_WIDTH-1:0]  addr_0_r;
           //reg [ADDR_WIDTH-1:0]  addr_1_r;

           //(* retiming_forward = 1 *) reg [ADDR_WIDTH-1:0]          addr_0_rr;
           //(* retiming_forward = 1 *) reg [ADDR_WIDTH-1:0]          addr_1_rr;

	   (* MAX_FANOUT = 20 *) reg [ADDR_WIDTH-1:0]  addr_0_r;
           (* MAX_FANOUT = 20 *) reg [ADDR_WIDTH-1:0]  addr_1_r;

	   (* MAX_FANOUT = 20 *) reg [ADDR_WIDTH-1:0]  addr_0_rr;
           (* MAX_FANOUT = 20 *) reg [ADDR_WIDTH-1:0]  addr_1_rr;

           `r addr_0_r <= addr_0_i;
           `r addr_1_r <= addr_1_i;
           
           `r addr_0_rr <= addr_0_r;
           `r addr_1_rr <= addr_1_r;
           
           initial $readmemh(ROM_FILENAME, rom_t);

	   `r data_0_r <= rom_t[addr_0_rr];
	   `r data_1_r <= rom_t[addr_1_rr];

           `r data_0_rr <= data_0_r;
           `r data_1_rr <= data_1_r;

           `r data_0_rrr <= data_0_rr;
           `r data_1_rrr <= data_1_rr;
           
           for(item=0; item<ROM_ITEM_NUMBER; item=item+1)
             begin
	        `w data_0_ro[item] = data_0_rrr[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
	        `w data_1_ro[item] = data_1_rrr[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
             end
           
	end // if ( ROM_LENGTH < 65 )
      else if( ROM_LENGTH <= MAX_ROM_LENGTH )
	begin : label_1

	   (* ROM_STYLE = "block" *)
           reg [ROM_WIDTH-1:0]   rom_t[0:ROM_LENGTH-1];
	   //(* retiming_backward = 1 *) reg [ROM_WIDTH-1:0]   data_0_r = 0;
	   //(* retiming_backward = 1 *) reg [ROM_WIDTH-1:0]   data_1_r = 0;
	   reg [ROM_WIDTH-1:0]   data_0_r = 0;
	   reg [ROM_WIDTH-1:0] 	 data_1_r = 0;
	   reg [ROM_WIDTH-1:0]   data_0_rr = 0;
	   reg [ROM_WIDTH-1:0]   data_1_rr = 0;
	   reg [ROM_WIDTH-1:0]   data_0_rrr = 0;
	   reg [ROM_WIDTH-1:0]   data_1_rrr = 0;

           (* MAX_FANOUT = 20 *) reg [ADDR_WIDTH-1:0]  addr_0_r;
           (* MAX_FANOUT = 20 *) reg [ADDR_WIDTH-1:0]  addr_1_r;

           //(* retiming_forward = 1 *) reg [ADDR_WIDTH-1:0]          addr_0_rr;
           //(* retiming_forward = 1 *) reg [ADDR_WIDTH-1:0]          addr_1_rr;
          
	   (* MAX_FANOUT = 20 *) reg [ADDR_WIDTH-1:0]  addr_0_rr;
	   (* MAX_FANOUT = 20 *) reg [ADDR_WIDTH-1:0]  addr_1_rr;
 
           `r addr_0_r <= addr_0_i;
           `r addr_1_r <= addr_1_i;
           
           `r addr_0_rr <= addr_0_r;
           `r addr_1_rr <= addr_1_r;

           initial $readmemh(ROM_FILENAME, rom_t);

	   `r data_0_r <= rom_t[addr_0_rr];
	   `r data_1_r <= rom_t[addr_1_rr];

           `r data_0_rr <= data_0_r;
           `r data_1_rr <= data_1_r;

           `r data_0_rrr <= data_0_rr;
           `r data_1_rrr <= data_1_rr;
           
           for(item=0; item<ROM_ITEM_NUMBER; item=item+1)
             begin
	        `w data_0_ro[item] = data_0_rrr[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
	        `w data_1_ro[item] = data_1_rrr[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
             end

	end // else: !if( ROM_LENGTH < 65 )
      else
	begin : label_2

           //
           // Inference doesn't split large ROMs across BRAMs in a way that is pipelined to
           // preserve timing.  So we have to do it here ourselves.  Break it into multiple
           // ROMs, each of LENGTH MAX_ROM_LENGTH.
           //
          
           localparam ROM_NUMBER      = (ROM_LENGTH + MAX_ROM_LENGTH - 1) / MAX_ROM_LENGTH;
           localparam ROM_NUMBER_BITS = $clog2(ROM_NUMBER);
           
	   reg [ROM_WIDTH-1:0]   data_0_rr[0:ROM_NUMBER-1];
	   reg [ROM_WIDTH-1:0]   data_1_rr[0:ROM_NUMBER-1];

           for(rom=0; rom<ROM_NUMBER; rom = rom + 1)
             begin

                localparam INDEX = rom;
                localparam INDEX_UNITS = INDEX % 10;
                localparam INDEX_TENS  = INDEX / 10;
                localparam [7:0] INDEX_UNITS_ASCII = INDEX_UNITS + "0";
                localparam [7:0] INDEX_TENS_ASCII  = INDEX_TENS + "0";
                
                localparam THIS_FILENAME = {"ROM36k_", INDEX_TENS_ASCII, INDEX_UNITS_ASCII, "_", ROM_FILENAME};
                localparam THIS_LENGTH = (rom<ROM_NUMBER-1) ? MAX_ROM_LENGTH : ROM_LENGTH - (ROM_NUMBER-1)*MAX_ROM_LENGTH;
                
                initial data_0_rr[rom] = 0;
                initial data_1_rr[rom] = 0;

	        reg [ROM_WIDTH-1:0]          data_0_r   = 0;
	        reg [ROM_WIDTH-1:0]          data_1_r   = 0;
                
	        (* ROM_STYLE = "block" *) (* CASCADE_HEIGHT = 0 *)
                reg [ROM_WIDTH-1:0]   rom_t[0:THIS_LENGTH-1];

                initial $readmemh(THIS_FILENAME, rom_t);
                
                reg [ROM_BITS-1:0]  addr_0_r    = 0;
                reg [ROM_BITS-1:0]  addr_0_rr   = 0;
                reg [ROM_BITS-1:0]  addr_1_r    = 0;                
                reg [ROM_BITS-1:0]  addr_1_rr   = 0;

                `r addr_0_r <= addr_0_i;
                `r addr_0_rr <= addr_0_r;

                `r addr_1_r <= addr_1_i;
                `r addr_1_rr <= addr_1_r;

	        `r data_0_r <= rom_t[addr_0_rr];
	        `r data_1_r <= rom_t[addr_1_rr];
 
	        `r data_0_rr[rom] <= data_0_r;
	        `r data_1_rr[rom] <= data_1_r;
             end

           //
           // Don't touch below is to prevent Vivado from optimizing into a serial shift register.
           // fanout limits are to prevent a 179-fanout net that doesn't meet timing.
           //
	   reg [ROM_WIDTH-1:0]          data_0_rrr   = 0;
	   reg [ROM_WIDTH-1:0]          data_1_rrr   = 0;

           (* max_fanout = 80 *) reg [ROM_NUMBER_BITS-1:0]    addr_0_up_r    = 0;
           (* max_fanout = 80 *) reg [ROM_NUMBER_BITS-1:0]    addr_0_up_rr   = 0;
           (* max_fanout = 80 *) (* DONT_TOUCH = "YES" *) reg [ROM_NUMBER_BITS-1:0]    addr_0_up_rrr  = 0;
           (* max_fanout = 80 *) reg [ROM_NUMBER_BITS-1:0]    addr_0_up_rrrr  = 0;

           (* max_fanout = 80 *) reg [ROM_NUMBER_BITS-1:0]    addr_1_up_r    = 0;
           (* max_fanout = 80 *) reg [ROM_NUMBER_BITS-1:0]    addr_1_up_rr   = 0;
           (* max_fanout = 80 *) (* DONT_TOUCH = "YES" *) reg [ROM_NUMBER_BITS-1:0]    addr_1_up_rrr  = 0;
           (* max_fanout = 80 *) reg [ROM_NUMBER_BITS-1:0]    addr_1_up_rrrr  = 0;
                
           `r addr_0_up_r   <= (addr_0_i >> ROM_BITS);
           `r addr_0_up_rr  <= addr_0_up_r;
           `r addr_0_up_rrr <= addr_0_up_rr;
           `r addr_0_up_rrrr <= addr_0_up_rrr;
           
           `r addr_1_up_r   <= (addr_1_i >> ROM_BITS);                
           `r addr_1_up_rr  <= addr_1_up_r;
           `r addr_1_up_rrr <= addr_1_up_rr;
           `r addr_1_up_rrrr <= addr_1_up_rrr;

           `r data_0_rrr <= data_0_rr[addr_0_up_rrrr];
           `r data_1_rrr <= data_1_rr[addr_1_up_rrrr];
   
           for(item=0; item<ROM_ITEM_NUMBER; item=item+1)
             begin
	        `w data_0_ro[item] = data_0_rrr[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
	        `w data_1_ro[item] = data_1_rrr[item*ROM_ITEM_WIDTH +: ROM_ITEM_WIDTH];
             end

	end // else: !if( ROM_LENGTH < 65 )
   endgenerate
   
endmodule // rom


/* verilator lint_on WIDTHEXPAND  */
/* verilator lint_on WIDTHTRUNC  */
