
`timescale 1ns / 1ps

`define w assign
`define r always@(posedge clk)

//
// Add two numbers
//
   
module split
  #(
    // Input parameters
    parameter AXIS_SAMPLES_PER_CLOCK       = 1,
    parameter IN_AXIS_BITS_PER_SAMPLE      = 16,
    parameter OUT_AXIS_BITS_PER_SAMPLE     = 16,
 
    // AXIS side data parameters
    parameter TID_WIDTH                    = 0,
    parameter TDEST_WIDTH                  = 0,

    // Processing parameters
    parameter SHIFT_RIGHT                  = 0,
    
    // Dependent parameters
    parameter IN_AXIS_BUS_WIDTH            = IN_AXIS_BITS_PER_SAMPLE * AXIS_SAMPLES_PER_CLOCK,
    parameter OUT_AXIS_BUS_WIDTH           = OUT_AXIS_BITS_PER_SAMPLE * AXIS_SAMPLES_PER_CLOCK,
    parameter TID_DUMMY_WIDTH              = (TID_WIDTH==0) ? 1 : TID_WIDTH,
    parameter TDEST_DUMMY_WIDTH            = (TDEST_WIDTH==0) ? 1 : TDEST_WIDTH
    )
   (
    // Data input and output

    (* X_INTERFACE_INFO = "xilinx.com:signal:clock:1.0 clk CLK" *)
    (* X_INTERFACE_PARAMETER = "ASSOCIATED_BUSIF IN_1_AXIS:OUT_AXIS:OUT_DUP_AXIS, ASSOCIATED_RESET resetn" *)
    input                                 clk,

    (* X_INTERFACE_INFO = "xilinx.com:signal:reset:1.0 resetn RST" *)
    input                                 resetn,

    input                                 IN_1_AXIS_tvalid,
    output wire                           IN_1_AXIS_tready,
    input [IN_AXIS_BUS_WIDTH-1:0]         IN_1_AXIS_tdata,
    input                                 IN_1_AXIS_tlast,
    input [TID_DUMMY_WIDTH-1:0]           IN_1_AXIS_tid,
    input [TDEST_DUMMY_WIDTH-1:0]         IN_1_AXIS_tdest,

    output reg                            OUT_AXIS_tvalid,
    input                                 OUT_AXIS_tready,
    output reg [OUT_AXIS_BUS_WIDTH-1:0]   OUT_AXIS_tdata,
    output reg                            OUT_AXIS_tlast,
    output reg [TID_DUMMY_WIDTH-1:0]      OUT_AXIS_tid,
    output reg [TDEST_DUMMY_WIDTH-1:0]    OUT_AXIS_tdest,

    output reg                            OUT_DUP_AXIS_tvalid,
    input                                 OUT_DUP_AXIS_tready,
    output reg [OUT_AXIS_BUS_WIDTH-1:0]   OUT_DUP_AXIS_tdata,
    output reg                            OUT_DUP_AXIS_tlast,
    output reg [TID_DUMMY_WIDTH-1:0]      OUT_DUP_AXIS_tid,
    output reg [TDEST_DUMMY_WIDTH-1:0]    OUT_DUP_AXIS_tdest

    );

   genvar                                  i;

   `w IN_1_AXIS_tready = 1'b1;

   `r OUT_AXIS_tlast  <= IN_1_AXIS_tlast;
   `r OUT_AXIS_tvalid <= IN_1_AXIS_tvalid;

   `r OUT_DUP_AXIS_tlast  <= IN_1_AXIS_tlast;
   `r OUT_DUP_AXIS_tvalid <= IN_1_AXIS_tvalid;
   
   generate
      
      for(i=0; i<AXIS_SAMPLES_PER_CLOCK; i=i+1)
        begin
           wire signed [IN_AXIS_BITS_PER_SAMPLE-1:0] in_1_w;
           wire signed [IN_AXIS_BITS_PER_SAMPLE:0]   out_w;
           

           `w in_1_w = IN_1_AXIS_tdata[ i * IN_AXIS_BITS_PER_SAMPLE +: IN_AXIS_BITS_PER_SAMPLE ];

           `w out_w = in_1_w;

           `r OUT_AXIS_tdata     [ i * OUT_AXIS_BITS_PER_SAMPLE +: OUT_AXIS_BITS_PER_SAMPLE ] <= (out_w >>> SHIFT_RIGHT);
           `r OUT_DUP_AXIS_tdata [ i * OUT_AXIS_BITS_PER_SAMPLE +: OUT_AXIS_BITS_PER_SAMPLE ] <= (out_w >>> SHIFT_RIGHT);
                      
        end

      if(TID_WIDTH>0)
        begin
           `r OUT_AXIS_tid     <= IN_1_AXIS_tid;
           `r OUT_DUP_AXIS_tid <= IN_1_AXIS_tid;
        end

      if(TDEST_WIDTH>0)
        begin
           `r OUT_AXIS_tdest     <= IN_1_AXIS_tdest;
           `r OUT_DUP_AXIS_tdest <= IN_1_AXIS_tdest;
        end

   endgenerate

     
endmodule
