//
// Copyright (C) 2021 Ross D. Martin
//

`timescale 1ps / 1ps

`define w assign
`define r always@(posedge clk)


module uniform_rand
  #(
    parameter   WIDTH      = 11,
    parameter   SELF_RESET = 0
    )
   (
    input                         clk,
    input                         enable,
    input                         randomizer_in_i,
    output reg                    randomizer_out_o,
    output reg signed [WIDTH-1:0] out_o
    );

   localparam RESET_COUNT = 31;  // If there is no one in this many counts, fix it if SELF_RESET is true
   localparam RESET_BITS  = $clog2(RESET_COUNT+1);

   wire signed [WIDTH-1:0]        out_w;
   wire [WIDTH-1:0]               c;
   reg                            self_reset_r      = 0;
   reg                            randomizer_in_r   = 0;
   reg                            c0_r              = 0;
   genvar                         i;

   initial randomizer_out_o = 0;
   initial out_o            = 0;
   
   `r out_o            <= out_w;
   `r randomizer_out_o <= out_o[0];
   `r randomizer_in_r  <= randomizer_in_i;
   `r c0_r             <= self_reset_r ^ randomizer_in_r;
   `w c                 = { out_o^(out_o<<1), c0_r };
   
   generate

      if(SELF_RESET)
        begin
           reg [RESET_BITS-1:0]  reset_counter  =  0;

           `r reset_counter  = out_o[0] ? RESET_COUNT : reset_counter - 1;
           `r self_reset_r  <= (reset_counter==0);
        end
      else
        begin
           `r self_reset_r  <= 0;
        end
      
      for(i=0; i<WIDTH; i=i+1)
        begin

           localparam PN_TAP = (i&1) ? 12 : 13;

           pn #(.PN_TAP(PN_TAP)) bit_pn(.clk(clk), .enable(enable), .in_i(c[i]), .out_o(out_w[i]));
                     
        end // for (i=0; i<WIDTH; i=i+1)
      
   endgenerate
   
endmodule
