#!/bin/bash

if [ -f out/bl31.elf ]; then
    echo ""
    echo "  BL31 output already exists.  Skipping build."
    echo "  to force a rebuild, run veryclean.sh first."
    echo ""
    exit 0
fi

rm -rf arm-trusted-firmware out


COMPILER=`which aarch64-linux-gnu-gcc`

if [ ! -f "$COMPILER" ]; then
    echo "Need to install compiler aarch64-linux-gnu-gcc"
    sudo apt install gcc-aarch64-linux-gnu
fi


if [ -f arm-trusted-firmware.tgz ]; then
    echo "Extracting pre-existing arm-trusted-firmware.tgz."
    tar xzf arm-trusted-firmware.tgz
else
    echo "Fetching arm-trusted-firmware."
    git clone https://github.com/Xilinx/arm-trusted-firmware.git
    tar czf arm-trusted-firmware.tgz arm-trusted-firmware
fi

if [ -f /proc/cpuinfo -a -f /proc/loadavg ]; then
    CPUs_minus_1=`cat /proc/cpuinfo | grep processor | tail -1 | sed 's/.*://'`
else
    CPUs_minus_1=0
fi

CPUs=$((CPUs_minus_1 + 1))

MAXJOBS=$(( 3 * CPUs / 4 - 1 ))

if [ $MAXJOBS -lt 1 ]; then
   MAXJOBS=1
fi

echo "Will run parallel build with $MAXJOBS threads."


(cd arm-trusted-firmware; make CROSS_COMPILE=aarch64-linux-gnu- PLAT=zynqmp RESET_TO_BL31=1 -j$MAXJOBS)

mkdir -p out

cp arm-trusted-firmware/build/zynqmp/release/bl31/bl31.elf  out/

if [ -f out/bl31.elf ]; then
    rm -rf arm-trusted-firmware
    echo ""
    echo "SUCCESS!  bl31.bin output is in the out directory."
    echo ""
    exit 0
fi

echo ""
echo "ERROR!  Build of bl31.bin failed.  Leaving arm-trusted-firmware to debug it."
echo ""

exit 20
