#!/bin/bash

depends()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Xilinx's tool $tool must be installed to run this script."
	echo ""
	exit 20
    fi
}

#depends xsct
#depends bootgen


for XSA in ../inputs/*.xsa; do

    DESIGN=`basename "$XSA" | sed 's/[.].*//'`

    #echo Design is $DESIGN
    
    ./one_boot_bin.sh "$DESIGN"

done


echo ""
echo ""
echo "OUTPUT BOOT.BIN files in the BOOT_BIN directory are these:"
echo ""

for file in out/*; do
    echo "  $file"
done
    
echo ""
echo ""
