#!/bin/bash

depend_exe()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Tool \"$tool\" must be built to run this script.  Run build.sh there."
	echo ""
	exit 20
    fi
}

depend_file()
{
    file="$1"
    if [ ! -f "$file" ]; then
	echo ""
	echo "File \"$file\" must be present to run this script."
	echo ""
	exit 20
    fi

}


DESIGN="$1"

#echo "Design is \"$DESIGN\"."


FSBL_ELF=../FSBL/out/${DESIGN}_FSBL.elf
PMUFW_ELF=../PMUFW/out/${DESIGN}_PMUFW.elf
BL31_ELF=../BL31/out/bl31.elf
U_BOOT_ELF=../U-BOOT/out/${DESIGN}_U_BOOT.elf

depend_exe  ../bootgen/bootgen/bootgen
depend_file "$FSBL_ELF"
depend_file "$PMUFW_ELF"
depend_file "$BL31_ELF"
depend_file "$U_BOOT_ELF"


BUILD_DIR=tmp
OUT_DIR=out

rm -rf $BUILD_DIR

mkdir -p $BUILD_DIR
mkdir -p $OUT_DIR

cat >$BUILD_DIR/zynq.bif <<EOF
the_ROM_image:
{
  [bootloader, destination_cpu=a53-0]                        ../${FSBL_ELF}
  [pmufw_image]                                              ../${PMUFW_ELF} 
  [destination_cpu=a53-0, exception_level=el-3, trustzone]   ../${BL31_ELF}
  [destination_cpu=a53-0, exception_level=el-2]              ../${U_BOOT_ELF}
}
EOF

( cd $BUILD_DIR ; ../../bootgen/bootgen/bootgen -arch zynqmp -image zynq.bif -o ../$OUT_DIR/${DESIGN}_BOOT.BIN -w )


rm -rf $BUILD_DIR
