#!/bin/bash

PATH="$PWD/../U-BOOT/exe:$PATH"


if [ ! -f ../../kernel/out/Image.gz ]; then
    echo ""
    echo "You must build in the kernel directory before this one, since"
    echo "the kernel's Image.gz is required here."
    echo ""
    exit 20
fi


rm -rf out
mkdir out

for DTB in ../device_tree_gen/out/*.dtb; do

    if [ ! -f $DTB ]; then
	echo "ERROR: DTB file \"$DTB\" doesn't exist.  Run build.sh in ../device_tree first."
	exit 20
    fi

    BASE=`basename $DTB | sed 's/[.]dtb//'`
    UB=${BASE}_image.ub

    mkdir -p tmp

    cp $DTB tmp/$BASE.dtb
    cat inputs/uimage_no_ramdisk.its | sed "s/BASE/$BASE/" >tmp/$BASE.its

    ../U-BOOT/exe/mkimage -f tmp/$BASE.its out/$UB

    if [ -f out/$UB ]; then
	echo ""
	echo "Processed Device Tree $DTB"
	echo "and Linux Kernel into $UB."
	echo ""
    else
	echo ""
	echo "ERROR Processing Device Tree $DTB"
	echo "and Linux Kernel into $UB."
	echo ""
    fi
    
done

