#!/bin/bash

depends()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Xilinx's tool $tool must be installed to run this script."
	echo ""
	exit 20
    fi
}

#depends bootgen

convert_xsa()
{
    XSA="$1"

    if [ ! -f "$XSA" ]; then
	
	echo ""
	echo "Usage: $0 file.xsa"
	echo ""
	echo "  Creates \"file.fsbl\"."
	echo ""
	exit 20
	
    fi

    DESIGN=`basename $XSA | sed 's/[.].*//'`
    OUT=${DESIGN}_PMUFW.elf

    if [ -f $OUT_DIR/$OUT ]; then

	if [ $XSA -nt $OUT_DIR/$OUT ]; then
	    echo "Rebuilding PMU Firmwate \"$OUT_DIR/$OUT\"; the XSA file \"$XSA\" is newer."
	    rm -f $OUT_DIR/$OUT
	else
	    echo "Skipping build of PMU Firmware \"$OUT_DIR/$OUT\"; the XSA file \"$XSA\" is older."
	    return
	fi
    else
	echo "No PMU Firmware \"$OUT_DIR/$OUT\" exists; building it."
    fi

    
    BUILD_DIR=tmp
    rm -rf $BUILD_DIR
    mkdir -p $BUILD_DIR

    depends xsct

    cp $XSA $BUILD_DIR/$DESIGN.xsa
    
    cat >$BUILD_DIR/create_pmufw.tcl <<EOF
set design [hsi open_hw_design $DESIGN.xsa]
hsi generate_app -hw \$design -os standalone -proc psu_pmu_0 -app zynqmp_pmufw -compile -sw pmufw -dir build
EOF

    echo "Running Xilinx xsct to create $OUT from $XSA."
    
    ( cd $BUILD_DIR; xsct create_pmufw.tcl )

    PMUFW="$BUILD_DIR/build/executable.elf"

    if [ ! -f "$PMUFW" ]; then
	
	echo ""
	echo "Creation of Platform Management Unit Firmware (PMUFW) failed."
	echo "Keeping temporary directory for debugging."
	echo ""
	exit 20
	
    fi

    cp $PMUFW $OUT_DIR/$OUT
    rm -rf "$BUILD_DIR"
    echo ""
    echo "Creation of Platform Management Unit Firmware (PMUFW) succeeded.  Output is $OUT_DIR/$OUT"
    echo ""
}



OUT_DIR=out
#rm -rf $OUT_DIR
mkdir -p $OUT_DIR


for file in ../inputs/*.xsa; do

    convert_xsa $file

done

