#!/bin/bash

if [ -x exe/mkimage -a -x exe/dumpimage  -a -x exe/dtc ]; then
    echo ""
    echo "  Not running exebuild; exe files appear to already be built."
    echo ""
    exit 0
fi


rm -rf u-boot-xlnx exe

#sudo apt install uuid-dev
#sudo apt install device-tree-overlay

if [ ! -d /usr/include/gnutls ]; then
    echo ""
    echo "Need to install libgnutls library development files."
    echo ""
    sudo apt install libgnutls28-dev
fi

COMPILER=`which aarch64-linux-gnu-gcc`

if [ ! -f "$COMPILER" ]; then
    echo "Need to install compiler aarch64-linux-gnu-gcc"
    sudo apt install gcc-aarch64-linux-gnu
fi


if [ -f u-boot-xlnx.tgz ]; then
    echo "Extracting pre-existing u-boot-xlnx.tgz."
    tar xzf u-boot-xlnx.tgz
else
    echo "Fetching u-boot-xlnx."
    git clone https://github.com/Xilinx/u-boot-xlnx.git
    tar czf u-boot-xlnx.tgz u-boot-xlnx
fi



if [ -f /proc/cpuinfo -a -f /proc/loadavg ]; then
    CPUs_minus_1=`cat /proc/cpuinfo | grep processor | tail -1 | sed 's/.*://'`
else
    CPUs_minus_1=0
fi

CPUs=$((CPUs_minus_1 + 1))

MAXJOBS=$(( 3 * CPUs / 4 - 1 ))

if [ $MAXJOBS -lt 1 ]; then
   MAXJOBS=1
fi

echo "Will run parallel build with $MAXJOBS threads."


export CROSS_COMPILE=aarch64-linux-gnu-
export ARCH=aarch64


(cd u-boot-xlnx; make -j$MAXJOBS xilinx_zynqmp_virt_defconfig)
(cd u-boot-xlnx; make -j$MAXJOBS)


mkdir -p exe
cp u-boot-xlnx/tools/mkimage    exe/
cp u-boot-xlnx/tools/dumpimage  exe/
cp u-boot-xlnx/scripts/dtc/dtc  exe/

if [ -x exe/mkimage -a -x exe/dumpimage  -a -x exe/dtc ]; then
    rm -rf u-boot-xlnx
    echo ""
    echo "SUCCESS!  Executable outputs are in the exe directory."
    echo ""
    exit 0
fi

echo ""
echo "ERROR!  Build of exe files failed.  Leaving u-boot-xlnx to debug it."
echo ""

exit 20
