
/*
 * Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., http://www.fsf.org/about/contact/
 *
 */


#ifndef STRING_HH
#define STRING_HH

#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

class String;
String join_strings(const char* s1, const char* s2);

class String
{
  char* n;

public:
  char* value() { return n; }
  operator char*() { return n; }
  String& operator << (const char* c) { String s = join_strings(n, c); char* x = n; n = s.n; s.n = x; return *this; }
  String& operator << (int c) { char buff[100]; sprintf(buff, "%d", c); return operator<<(buff); }

  void operator=(String s) { delete [] n; char* b = n = new char[strlen(s.n)+1]; char*a = s.n; while(*a) *b++=*a++; *b=0; }

  void operator=(const char* a) { delete [] n; if(!a) { n=new char[1]; *n=0; return; } char* b = n = new char[strlen(a)+1]; while(*a) *b++=*a++; *b=0; }

  String(const String& s) { char* b = n = new char[strlen(s.n)+1]; char*a = s.n; while(*a) *b++=*a++; *b=0; }

  //String(const char* a) { if(!a) { n=new char[1]; *n=0; return; } char* b = n = new char[strlen(a)+1]; while(*a) *b++=*a++; *b=0; }

  String() { n = new char[1]; *n = 0; }

  String(const char* a, int size=0) { int sa = (!a) ? 0 : strlen(a); if(size<sa) size=sa; n = new char[size+1]; for(int i=0; i<sa; i++) n[i]=a[i]; n[sa]=0; }

  int equals(const char* y) const { if(y==0)return 0; char* x=n; while(*x && *y) if(*x++!=*y++) return 0; return *x == *y; }

  int equalsI(const char* y) const { if(y==0)return 0; char* x=n; while(*x && *y) if(tolower(*x++)!=tolower(*y++)) return 0; return *x == *y; }

  int has_prefix(const char* y) const { if(y==0)return 0; char* x=n; while(*y) if(*x++!=*y++) return 0; return 1; }

  int has_prefix_i(const char* y) const { if(y==0)return 0; char* x=n; while(*y) if(tolower(*x++)!=tolower(*y++)) return 0; return 1; }

  void removeLeadingAndTrailingWhitespace();

  int length() { return strlen(n); }

  ~String() { delete [] n; }
};


inline String to_upper(const String& s)
{
  String x = s;

  char* c = x.value();

  while(*c)
    {
      if(*c>='a' && *c<='z')
        *c += 'A'-'a';
      c++;
    }

  return x;
}

inline int stringMatchI(const char* a, const char* b)
{
  while(*a && *b && tolower(*a) == tolower(*b))
    {
      a++;
      b++;
    }

  return *a==*b;
}

inline int stringMatchToLengthOfFirst(const char* a, const char* b)
{
  while( (*a) && (*b) && (*a == *b) )
    {
      a++;
      b++;
    }

  return !*a;
}

inline int extensionmatchI(const char* filename, const char* extension)
{
  const char* e = filename;
  const char* d = filename;

  if(!filename || !extension)
    return 0;

  for(;;)
    {
      if(!*e)
	break;
      else if(*e=='.')
	d = e;

      e++;
    }

  return stringMatchI(d, extension);
}

inline int secondIsSubstring(const char* name, const char* substring)
{
  const char* e = name;

  while(*e)
    {
      const char* d = e;
      const char* f = substring;

      while(*d && *d==*f)
	{
	  d++;
	  f++;
	}

      if(!*f)
	return 1;

      e++;
    }
  
  return 0;
}

inline String downcase(const char* c)
{
  String s(c);
  char* a = s;

  if(a)
    {
      while(*a)
	{
	  *a = tolower(*a);
	  a++;
	}
    }

  return s;
}

inline String join_strings(const char* s1, const char* s2)
{
  int size1 = (!s1) ? 0 : strlen(s1);
  int size2 = (!s2) ? 0 : strlen(s2);

  String result(s1, size1+size2);

  char* a=result;

  a+=size1;

  for(int i=0; i<size2; i++)
    *a++=*s2++;
  *a=0;

  return result;
}

inline int firstNameFirst(const char* first, const char* second)
{
  for(;;)
    {
      if(*first<*second)
	return 1;
      else if(*first>*second)
	return 0;
      
      if(!*first)
	break;

      first++;
      second++;
    }

  // equal strings in this case, leave first one first,
  // but return a different value so equality can be tested for.
  return -1;
}

inline int firstNameFirstI(const char* first, const char* second)
{
  for(;;)
    {
      if(tolower(*first)<tolower(*second))
	return 1;
      else if(tolower(*first)>tolower(*second))
	return 0;
      
      if(!*first)
	break;

      first++;
      second++;
    }

  // equal strings in this case, leave first one first,
  // but return a different value so equality can be tested for.
  return -1;
}

inline void 
String::removeLeadingAndTrailingWhitespace()
{
  int i,j;

  for(i=0;;i++)
    {
      if(n[i]!=' ' && n[i]!='\t')
	break;
    }

  if(i>0)
    {
      j=0;
      while( (n[j++]=n[i++]) )
	;
    }

  for(i=0; n[i]; i++)
    ;

  i--;
  while(n[i]==' ' || n[i]=='\t')
    {
      n[i]=0;
      i--;
    }
}

#endif
