
/*
 * Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., http://www.fsf.org/about/contact/
 *
 */


#include "xml.hh"

void usage()
{
  printf("Usage:\n"
	 "\n"
	 "   xml_test infile.xml outfile.dts\n"
	 "\n"
	 "This program reads in the XML file and writes it out as a device tree.\n"
	 "\n");

  exit(20);
}


int main(int argc, const char* const argv[])
{
  if(argc<3)
    usage();

  const char* infile  = argv[1];
  const char* outfile = argv[2];

  auto x = new xml(infile);

  writestream w(outfile);
  
  x->print_with_path(w);

  return 0;
}
