
/*
 * Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., http://www.fsf.org/about/contact/
 *
 */


#ifndef XML_HH
#define XML_HH

#include "List.hh"
#include "String.hh"
#include "readstream.hh"
#include "writestream.hh"

class xml_attribute
{
public:
  
  String name;
  String value;

  void print(writestream& w);

  xml_attribute(const char* name, const char* value) { this->name = name; this->value = value; }
  ~xml_attribute() {}
};


class xml_entry
{
public:
  
  String               name;
  List<xml_attribute>  attributes;
  List<xml_entry>      children;

  void print_with_path(writestream& w, String indent);
  void print_with_indent(writestream& w, String indent);

  xml_attribute* find_attribute(String name);  // These return 0 if not found.
  xml_entry*     find_child(String name);
  xml_entry*     find_child_after(String name, xml_entry* xmle);
  
  xml_entry(readstream& r, bool debug);
  ~xml_entry() {}
};


class xml
{
public:

  String           header;
  List<xml_entry>  entries;

  void print_with_path(writestream& w);
  void print_with_indent(writestream& w);
  xml_entry* find_entry(String name);

  xml(const char* filename, bool debug=false);
  ~xml() {}
};


#endif
