#!/bin/bash

depend_exe()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Tool \"$tool\" must be built to run this script.  Run exebuild.sh there."
	echo ""
	exit 20
    fi
}

depends()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Xilinx's tool $tool must be installed to run this script."
	echo ""
	exit 20
    fi
}


input_in_range()
{
    input_name="$1"
    input="$2"

    shift 2

    while [ "$1" != "" ]; do
	#echo checking $1
	if [ "$input" = "$1" ]; then
	    return;
	fi
	if [ "$VALID_ARGS" = "" ]; then
	    VALID_ARGS="$i"
	elif [ "$2" = "" ]; then
	    VALID_ARGS="$VALID_ARGS, or $i"
	else
	    VALID_ARGS="$VALID_ARGS, $i"
	fi
	shift
    done
    
    echo ""
    echo "ERROR:  \"$input_name\" must be set to $VALID_ARGS."
    echo "        in the file \"inputs/$DESIGN.conf\"."
    echo ""
    exit 21
}

IN_XSA="$1"

if [ ! -f "$IN_XSA" ]; then
    echo "Usage: $0 XSA_FILE.xsa"
    exit 20
fi


OUTDIR=out
TMPDIR=tmp

rm -rf "$TMPDIR"

DESIGN=`basename "$IN_XSA" | sed 's/[.].*//'`
DTS="$OUTDIR/${DESIGN}.dts"
DTB="$OUTDIR/${DESIGN}.dtb"
XSA="$TMPDIR/${DESIGN}.xsa"


if [ ! -f inputs/$DESIGN.conf ]; then
    echo ""
    echo "ERROR:  Building a device tree requires a little information"
    echo "        to correct for Xilinx's device tree generation and/or"
    echo "        FSBL code mistakes.  You need to input that information"
    echo "        for the board \"$DESIGN\" into the file"
    echo "        \"inputs/$DESIGN.conf\" in the device_tree_gen"
    echo "        directory.  There aren't a lot of combinations;"
    echo "        it can be done by trial and error until you get"
    echo "        working boot files."
    echo ""
    echo "        To begin, start with one of the other files in that"
    echo "        directory, and modify it until you get working"
    echo "        boot files.  Then you can re-run the build without"
    echo "        getting this error."
    echo ""
    echo "        Please report back the working settings"
    echo "        for your board."
    echo ""
    exit 20
fi

. inputs/$DESIGN.conf

input_in_range PSGTR_DISPLAYPORT_CLOCK "$PSGTR_DISPLAYPORT_CLOCK" 0 1 2 3 DISABLED
input_in_range PSGTR_USB_CLOCK         "$PSGTR_USB_CLOCK"         0 1 2 3 DISABLED
input_in_range PSGTR_PCIE_CLOCK        "$PSGTR_PCIE_CLOCK"        DISABLED  # fix

input_in_range PSGTR_DISPLAYPORT_FREQ "$PSGTR_DISPLAYPORT_FREQ"   27000000
input_in_range PSGTR_USB_FREQ         "$PSGTR_USB_FREQ"           26000000 100000000
input_in_range PSGTR_PCIE_FREQ        "$PSGTR_PCIE_CLOCK"         DISABLED  # fix


if [ ! -f "$DTS" ]; then
    echo "No Device Tree \"$DTS\" exists; building it."
elif [ ! -f "$DTB" ]; then
    echo "No Device Tree \"$DTB\" exists; building it."
else
    if [ "$IN_XSA" -nt "$DTS" ]; then
	echo "Rebuilding \"$DTS\"; the XSA file \"$XSA\" is newer."
    elif [ "$IN_XSA" -nt "$DTB" ]; then
	echo "Rebuilding \"$DTB\"; the XSA file \"$XSA\" is newer."
    else
	echo "Skipping build of \"$DTS\" and \"$DTB\"; the XSA file \"$XSA\" is older."
	exit 0
    fi
fi

depend_exe ../u-boot-xlnx/exe/dtc
depends xsct

rm -f "$DTS" "$DTB"


mkdir -p "$TMPDIR"
mkdir -p "$OUTDIR"


cp "$IN_XSA" "$XSA"

rm -rf dtg dts

if [ ! -f device-tree-xlnx.tgz ]; then
    echo ""
    echo ""
    echo "  Have no local copy of device-tree-xlnx.  Fetching and creating local copy."
    echo ""
    echo ""
    git clone https://github.com/Xilinx/device-tree-xlnx
    #(cd dtg; git checkout xilinx-v2020.2)
    tar czf device-tree-xlnx.tgz device-tree-xlnx
else
    tar xzf device-tree-xlnx.tgz
fi

xsct <<EOF
hsi open_hw_design $XSA
hsi set_repo_path device-tree-xlnx
hsi create_sw_design device-tree -os device_tree -proc psu_cortexa53_0
hsi set_property CONFIG.remove_pl true [hsi::get_os]
#hsi set_property CONFIG.mainline_kernel v6.12 [hsi::get_os]
hsi set_property CONFIG.bootargs "earlycon console=ttyPS0,115200 clk_ignore_unused rootwait root=/dev/mmcblk0p2 rw earlyprintk net.ifnames=0"  [hsi::get_os]
#hsi set_property CONFIG.overlay_custom_dts file.dts [hsi::get_os]
hsi generate_target -dir "$TMPDIR"
hsi close_hw_design [hsi::current_hw_design]
EOF

#cpp -nostdinc -I include -I arch  -undef -x assembler-with-cpp  "$TMPDIR"/system-top.dts -o - | sed 's@.*bootargs.*@  bootargs = "earlycon console=ttyPS0,115200 clk_ignore_unused rootwait root=/dev/mmcblk0p2 rw earlyprintk net.ifnames=0";@' >$DTS

#
# The pcw and zynqmp.dtsi needs some fixes.  Haven't yet figured out how to generate a newer pcw that
# the other tools all like.
#
mkdir "$TMPDIR"/old


cat >>"$TMPDIR/pcw.dtsi-disabled" <<EOF

/ {
     my_dp_clk: my_dp_clk {
       bootph-all;
       compatible = "fixed-clock";
       #clock-cells = <0>;
       clock-frequency = <$PSGTR_DISPLAYPORT_FREQ>;
     };
};

/ {
     my_usb_clk: my_usb_clk {
       bootph-all;
       compatible = "fixed-clock";
       #clock-cells = <0>;
       clock-frequency = <$PSGTR_USB_FREQ>;
     };
};

/ {
     my_psgtr: my_phy@fd400000 {
       compatible = "xlnx,zynqmp-psgtr-v1.1";
       status = "disabled";
       reg = <0x0 0xfd400000 0x0 0x40000>,
             <0x0 0xfd3d0000 0x0 0x1000>;
       reg-names = "serdes", "siou";
       #phy-cells = <4>;
     };
};

/ {
     my_zynqmp_dpdma: my_dma-controller@fd4c0000 {
       compatible = "xlnx,zynqmp-dpdma";
       status = "disabled";
       reg = <0x0 0xfd4c0000 0x0 0x1000>;
       interrupts = <0 122 4>;
       interrupt-parent = <&gic>;
       clock-names = "axi_clk";
       power-domains = <&zynqmp_firmware 41>;
       dma-channels = <6>;

       #dma-cells = <1>;
    };
};

/ {
     my_zynqmp_dpaud_setting: my_dp-aud@fd4ac000 {
       compatible = "xlnx,zynqmp-dpaud-setting", "syscon";
       reg = <0x0 0xfd4ac000 0x0 0x1000>;
     };
};

/ {
     my_zynqmp_dpsub: my_display@fd4a0000 {
       bootph-all;
       compatible = "xlnx,zynqmp-dpsub-1.7";
       status = "disabled";
       reg = <0x0 0xfd4a0000 0x0 0x1000>,
             <0x0 0xfd4aa000 0x0 0x1000>,
             <0x0 0xfd4ab000 0x0 0x1000>;
       reg-names = "dp", "blend", "av_buf";
       xlnx,dpaud-reg = <&my_zynqmp_dpaud_setting>;
       interrupts = <0 119 4>;
       interrupt-parent = <&gic>;

       clock-names = "dp_apb_clk", "dp_aud_clk",
                     "dp_vtc_pixel_clk_in";
       power-domains = <&zynqmp_firmware 41>;
       resets = <&zynqmp_reset 3>;
       dma-names = "vid0", "vid1", "vid2", "gfx0";
       dmas = <&my_zynqmp_dpdma 0>,
              <&my_zynqmp_dpdma 1>,
              <&my_zynqmp_dpdma 2>,
              <&my_zynqmp_dpdma 3>;

       i2c-bus {
       };

       my_zynqmp_dp_snd_codec0: my_zynqmp-dp-snd-codec0 {
         compatible = "xlnx,dp-snd-codec";
         clock-names = "aud_clk";
       };

       my_zynqmp_dp_snd_pcm0: my_zynqmp-dp-snd-pcm0 {
         compatible = "xlnx,dp-snd-pcm0";
         dmas = <&my_zynqmp_dpdma 4>;
         dma-names = "tx";
       };

       my_zynqmp_dp_snd_pcm1: my_zynqmp-dp-snd-pcm1 {
         compatible = "xlnx,dp-snd-pcm1";
         dmas = <&my_zynqmp_dpdma 5>;
         dma-names = "tx";
       };

       my_zynqmp_dp_snd_card0: my_zynqmp-dp-snd-card {
         compatible = "xlnx,dp-snd-card";
         xlnx,dp-snd-pcm = <&my_zynqmp_dp_snd_pcm0>,
                           <&my_zynqmp_dp_snd_pcm1>;
         xlnx,dp-snd-codec = <&my_zynqmp_dp_snd_codec0>;
       };

       ports {
         #address-cells = <1>;
         #size-cells = <0>;

         port@0 {
           reg = <0>;
         };
         port@1 {
           reg = <1>;
         };
         port@2 {
           reg = <2>;
         };
         port@3 {
           reg = <3>;
         };
         port@4 {
           reg = <4>;
         };
         port@5 {
           reg = <5>;
         };
       };
     };
};


// / {
// my_dpcon: my_dpcon {
//  bootph-all;
//  compatible = "dp-connector";
//  label = "P11";
//  type = "full-size";
//
//  port {
//   dpcon_in: endpoint {
//    remote-endpoint = <&dpsub_dp_out>;
//   };
//  };
// };
//};

&my_psgtr {
        bootph-all;
	status = "okay";
        clocks = <&my_dp_clk> , <&my_usb_clk> ;
        clock-names = "ref$PSGTR_DISPLAYPORT_CLOCK", "ref$PSGTR_USB_CLOCK" ;
};

&my_zynqmp_dpsub {
	status = "okay";
	phy-names = "dp-phy0","dp-phy1";
	phys = <&my_psgtr 1 6 0 $PSGTR_DISPLAYPORT_CLOCK>, <&my_psgtr 0 6 1 $PSGTR_DISPLAYPORT_CLOCK>;
	xlnx,max-lanes = <2>;
	//clocks = <&dp_aclk>, <&zynqmp_clk 17>, <&zynqmp_clk 16>;
};


&my_zynqmp_dpdma {
       status = "okay";
       clocks = <&zynqmp_clk 20>;
};

//&my_out_dp {
//   dpsub_dp_out: endpoint {
//    remote-endpoint = <&dpcon_in>;
//   };
//};
//};

EOF

# Disable devices.  The PCW enables them earlier, but a disable at the
# end will take precedence.

#disabled_devices="xlnx_dpdma serdes zynqmp_dpsub"
#disabled_devices="zynqmp_dpsub"
disabled_devices=""

for device in $disabled_devices; do
    echo >>"$TMPDIR/pcw.dtsi"  ""
    echo >>"$TMPDIR/pcw.dtsi"  "&$device {"
    echo >>"$TMPDIR/pcw.dtsi"  "  status= \"disabled\";"
    echo >>"$TMPDIR/pcw.dtsi"  "};"
    echo >>"$TMPDIR/pcw.dtsi"  ""
done


#for longfile in "$TMPDIR"/*.dtsi; do
#    file=`basename $longfile`
#    mv "$TMPDIR/$file" "$TMPDIR"/old/
#   sed 's/xlnx_dpdma/zynqmp_dpdma/; s/serdes/psgtr/; /^[ \t]*phys[ \t][ \t]*=/d' <"$TMPDIR/old/$file" >"$TMPDIR/$file"
#done




cpp -nostdinc -I "$TMPDIR"/include -I arch  -undef -x assembler-with-cpp  "$TMPDIR"/system-top.dts -o - >$DTS

../u-boot-xlnx/exe/dtc -@ -o "$DTB" "$DTS"

if [ -f "$DTS" -a -f "$DTB" ]; then
    echo ""
    echo "SUCCESS!  Device tree created in \"${DTS}\"."
    echo "          Compiled version in \"${DTB}\"."
    echo ""
    #rm -rf "$TMPDIR" device-tree-xlnx
else
    echo ""
    echo "ERROR!  Couldn't create device tree $DTS of compiled version $DTB."
    echo "Leaving intermediate files for debugging."
    echo ""
fi
