#!/bin/bash

depend_exe()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Tool \"$tool\" must be built to run this script.  Run exebuild.sh there."
	echo ""
	exit 20
    fi
}

depends()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Xilinx's tool $tool must be installed to run this script."
	echo ""
	exit 20
    fi
}

IN_XSA="$1"

if [ ! -f "$IN_XSA" ]; then
    echo "Usage: $0 XSA_FILE.xsa"
    exit 20
fi

OUTDIR=out
TMPDIR=tmp

DESIGN=`basename "$IN_XSA" | sed 's/[.].*//'`
DTS="$OUTDIR/${DESIGN}.dts"
DTB="$OUTDIR/${DESIGN}.dtb"
XSA="$TMPDIR/${DESIGN}.xsa"

if [ ! -f "$DTS" ]; then
    echo "No Device Tree \"$DTS\" exists; building it."
elif [ ! -f "$DTB" ]; then
    echo "No Device Tree \"$DTB\" exists; building it."
else
    if [ "$IN_XSA" -nt "$DTS" ]; then
	echo "Rebuilding \"$DTS\"; the XSA file \"$XSA\" is newer."
    elif [ "$IN_XSA" -nt "$DTB" ]; then
	echo "Rebuilding \"$DTB\"; the XSA file \"$XSA\" is newer."
    else
	echo "Skipping build of \"$DTS\" and \"$DTB\"; the XSA file \"$XSA\" is older."
	exit 0
    fi
fi

depend_exe ../u-boot-xlnx/exe/dtc
depends xsct

rm -f "$DTS" "$DTB"

rm -rf "$TMPDIR"
mkdir -p "$TMPDIR"
mkdir -p "$OUTDIR"


cp "$IN_XSA" "$XSA"

rm -rf dtg dts

if [ ! -f device-tree-xlnx.tgz ]; then
    echo ""
    echo ""
    echo "  Have no local copy of device-tree-xlnx.  Fetching and creating local copy."
    echo ""
    echo ""
    git clone https://github.com/Xilinx/device-tree-xlnx
    #(cd dtg; git checkout xilinx-v2020.2)
    tar czf device-tree-xlnx.tgz device-tree-xlnx
else
    tar xzf device-tree-xlnx.tgz
fi

xsct <<EOF
hsi open_hw_design $XSA
hsi set_repo_path device-tree-xlnx
hsi create_sw_design device-tree -os device_tree -proc psu_cortexa53_0
hsi generate_target -dir "$TMPDIR"
EOF

#
# xsct is targeted at older kernels that have different device tree requirements, especially for the
# DisplayPort settings.  Remove these and replace with ones shipped with the kernel.
#
mkdir "$TMPDIR"/old
mv "$TMPDIR"/include "$TMPDIR"/*.dtsi "$TMPDIR"/old
cp ../kernel/linux-xlnx/arch/arm64/boot/dts/xilinx/zynqmp*.dtsi "$TMPDIR"/
mkdir "$TMPDIR"/include
cp -r ../kernel/linux-xlnx/include/dt-bindings "$TMPDIR"/include

#
# Make fixes to match old stuff from xsct with new kernel stuff.
#
# Note that in &psgtr 1 6 0 0, the translation is LANE, TYPE, INSTANCE, REFCLK
#
# LANE is the physical serdes number.  TYPE refers to how it is used, 6 indicates DisplayPort
# INSTANCE is .  REFCLK is the number of the reference clock.  Note that the reference clock
# is dependent on the board layout, external chips on the board, and their configuration.
#
# Note that reference clock number here is 1, 2, 3, 4.  But on the chip they are 0, 1, 2, 3!!!!
#
sed 's/xlnx_dpdma/zynqmp_dpdma/; s/serdes/psgtr/; s/[<][&]lane1 6 0 0 27000000[>]/<\&psgtr 1 6 0 1>/; s/[<][&]lane0 6 1 0 27000000[>]/<\&psgtr 0 6 1 1>/;  s/[<][&]lane1 6 0 1 27000000[>]/<\&psgtr 1 6 0 1>/; s/[<][&]lane0 6 1 1 27000000[>]/<\&psgtr 0 6 1 1>/' <"$TMPDIR"/old/pcw.dtsi >"$TMPDIR"/pcw.dtsi

cat >>"$TMPDIR"/zynqmp.dtsi <<EOF

/ {
 dp_clk: dp_clk {
  compatible = "fixed-clock";
  #clock-cells = <0>;
  clock-frequency = <27000000>;
 };

 dpcon: dpcon {
  compatible = "dp-connector";
  label = "P11";
  type = "full-size";

  port {
   dpcon_in: endpoint {
    remote-endpoint = <&dpsub_dp_out>;
   };
  };
 };
};

&psgtr {
	status = "okay";
        clocks = <&dp_clk>, <&dp_clk>;
        clock-names = "ref0", "ref1";
};

&zynqmp_dpsub {
 status = "okay";

 zynqmp_dp_snd_codec0: zynqmp_dp_snd_codec0 { };

 zynqmp_dp_snd_pcm0: zynqmp_dp_snd_pcm0 { };

 zynqmp_dp_snd_pcm1: zynqmp_dp_snd_pcm1 { };

 zynqmp_dp_snd_card0: zynqmp_dp_snd_card { };
};


&out_dp {
   dpsub_dp_out: endpoint {
    remote-endpoint = <&dpcon_in>;
   };
};


EOF

cpp -nostdinc -I "$TMPDIR"/include -I arch  -undef -x assembler-with-cpp  "$TMPDIR"/system-top.dts -o - | sed 's@.*bootargs.*@  bootargs = "earlycon console=ttyPS0,115200 clk_ignore_unused rootwait root=/dev/mmcblk0p2 rw earlyprintk net.ifnames=0";@' >$DTS

../u-boot-xlnx/exe/dtc -@ -o "$DTB" "$DTS"

if [ -f "$DTS" -a -f "$DTB" ]; then
    echo ""
    echo "SUCCESS!  Device tree created in \"${DTS}\"."
    echo "          Compiled version in \"${DTB}\"."
    echo ""
    rm -rf "$TMPDIR" device-tree-xlnx
else
    echo ""
    echo "ERROR!  Couldn't create device tree $DTS of compiled version $DTB."
    echo "Leaving intermediate files for debugging."
    echo ""
fi
