#!/bin/bash

depend_exe()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Tool \"$tool\" must be built to run this script.  Run exebuild.sh there."
	echo ""
	exit 20
    fi
}

depend_dir()
{
    dir="$1"
    if [ ! -d "$dir" ]; then
	echo ""
	echo "The Linux kernel source code must be installed in ../kernel/linux-xlnx"
	echo "to run this script.  Try running build in the kernel directory."
	echo ""
	exit 20
    fi
}

IN_XSA="$1"

if [ ! -f "$IN_XSA" ]; then
    echo "Usage: $0 XSA_FILE.xsa"
    exit 20
fi

OUTDIR=out
TMPDIR=tmp

DESIGN=`basename "$IN_XSA" | sed 's/[.].*//'`
DTS="$OUTDIR/${DESIGN}.dts"
DTB="$OUTDIR/${DESIGN}.dtb"
XSA="${DESIGN}.xsa"

if [ ! -f "$DTS" ]; then
    echo "No Device Tree \"$DTS\" exists; building it."
elif [ ! -f "$DTB" ]; then
    echo "No Device Tree \"$DTB\" exists; building it."
else
    if [ "$IN_XSA" -nt "$DTS" ]; then
	echo "Rebuilding \"$DTS\"; the XSA file \"$IN_XSA\" is newer."
    elif [ "$IN_XSA" -nt "$DTB" ]; then
	echo "Rebuilding \"$DTB\"; the XSA file \"$IN_XSA\" is newer."
    else
	echo "Skipping build of \"$DTS\" and \"$DTB\"; the XSA file \"$IN_XSA\" is older."
	exit 0
    fi
fi

depend_exe ../u-boot-xlnx/exe/dtc
depend_dir ../kernel/linux-xlnx

rm -f "$DTS" "$DTB"

rm -rf "$TMPDIR"
mkdir -p "$TMPDIR"
mkdir -p "$OUTDIR"


cp "$IN_XSA" "$TMPDIR/$XSA"

(cd "$TMPDIR"; unzip "$XSA")

HWH=`echo "$TMPDIR"/*.hwh`

if [ ! -f "$HWH" ]; then
    echo ""
    echo "  The XSA file wasn't properly unzipped, to find the Hardware Handoff HWH file."
    echo ""
    exit 20
fi

(cd hwh_to_dts; make)

hwh_to_dts/write_device_tree/exe/write_device_tree "$HWH" "$TMPDIR/my_system.dts"

#
# Use the device tree info shipped with the Linux kernel.
#
cp ../kernel/linux-xlnx/arch/arm64/boot/dts/xilinx/zynqmp*.dtsi "$TMPDIR"/
cp -r ../kernel/linux-xlnx/include "$TMPDIR"/

cpp -nostdinc -I "$TMPDIR"/include -I arch  -undef -x assembler-with-cpp  "$TMPDIR"/my_system.dts -o - | sed 's@.*bootargs.*@  bootargs = "earlycon console=ttyPS0,115200 clk_ignore_unused rootwait root=/dev/mmcblk0p2 rw earlyprintk net.ifnames=0";@' >$DTS

../u-boot-xlnx/exe/dtc -@ -o "$DTB" "$DTS"

if [ -f "$DTS" -a -f "$DTB" ]; then
    echo ""
    echo "SUCCESS!  Device tree created in \"${DTS}\"."
    echo "          Compiled version in \"${DTB}\"."
    echo ""
    rm -rf "$TMPDIR" device-tree-xlnx
else
    echo ""
    echo "ERROR!  Couldn't create device tree $DTS of compiled version $DTB."
    echo "Leaving intermediate files for debugging."
    echo ""
fi
