#!/bin/bash -e

DESIGN=RFSoC4x2_BxBDemo1

one_dir=`echo *_0.000`

if [ ! -d "$one_dir" ]; then

    echo ""
    echo "Expecting a directory of the form \"$one_dir\", but it isn't found."
    echo ""
    echo "At least one design must be compiled before running this script."
    echo "Preferably, many designs."
    echo ""
    echo "This is done by running the script compile_design.sh (for one run)"
    echo "of multicompile.sh (for many runs to take the best)."
    echo ""
    echo "This script will take results from the best run and cache them"
    echo "in the directory best_results"
    echo ""
    exit 20
fi

echo "Finding best run..."

bestrun=`./report_timing_best_to_worst.sh | grep -iv bad | grep From | head -1`

#echo "bestrun is $bestrun"

dirnum=`echo $bestrun | sed 's/[ ].*//'`
Target_MHz=`echo $bestrun | sed 's/[0-9.]*[ ]*//; s/[ ].*//'`
Achieved_MHz=`echo $bestrun | sed 's/[0-9.]*[ ]*[0-9.]*MHz[ ]*//; s/[ ].*//'`

#echo "dirname is $dirnum"

dir=`dirname *_$dirnum/.`

#echo "dir is $dir"

if [ ! -d "$dir" ]; then
    echo "Error:  Expected best dir to be \"$dir\", but it doesn't appear to be a directory."
    exit 20
fi

echo "Best run is \"$dir\", achieving $Achieved_MHz with target $Target_MHz."

rm -rf best_results

mkdir best_results

TR=`find "$dir" -name '*timing_summary*.rpt'`
UR=`find "$dir" -name '*utilization_routed*.rpt'`

TRF=`basename "$TR"`
URF=`basename "$UR"`

cp $dir/"${DESIGN}.xsa"         best_results/
cp $dir/"${DESIGN}.hwh"         best_results/
#cp $dir/"${DESIGN}_netlist.v"   best_results/
cp $dir/"${DESIGN}.bit"         best_results/
cp $dir/"${DESIGN}.bin"         best_results/
cp "$TR"                        best_results/
cp "$UR"                        best_results/

echo "" >>best_results/README.txt
echo "Best run is \"$dir\", achieving $Achieved_MHz with target $Target_MHz." >>best_results/README.txt
echo "" >>best_results/README.txt
echo "" >>best_results/README.txt
echo "Files copied to this \"best_results\" directory from the best run:" >>best_results/README.txt
echo "" >>best_results/README.txt
echo "    Software Architecture, for building maching software:  ${DESIGN}.xsa"       >>best_results/README.txt
echo "    Hardware Handoff, hardware settings from the XSA:      ${DESIGN}.hwh"       >>best_results/README.txt
#echo "    netlist, the synthesized and optimized PL verilog:     ${DESIGN}_netlist.v" >>best_results/README.txt
echo "    FPGA PL bitfile, to program the FPGA:                  ${DESIGN}.bit"       >>best_results/README.txt
echo "    FPGA PL binfile, to program the FPGA from Linux:       ${DESIGN}.bin"       >>best_results/README.txt
echo "    PL Timing report for timing info:                      $TRF"                >>best_results/README.txt
echo "    PL Utilization report for chip resources used:         $URF"                >>best_results/README.txt
echo "" >>best_results/README.txt
echo "" >>best_results/README.txt
echo "Achived Fmax results from all runs (not just the best) are below.  If any designs" >>best_results/README.txt
echo "fail timing, the worst path is also included:" >>best_results/README.txt
echo "" >>best_results/README.txt
./report_timing_best_to_worst.sh >>best_results/README.txt

echo ""
echo "Directory best_results created.  See best_results/README.txt for details."
echo ""
