
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use, distribute, and modify
// this work, so long as such uses are non-commercial in nature,
// so long as any derived works are offered on the same terms,
// and so long as attribution is given to the original author.
// For further details, see the Creative Commons License
// "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//


`undef w
`define w assign
`undef r
`define r always@(posedge clk)
`timescale  1 ps / 1 ps   

/* verilator lint_off WIDTHEXPAND  */
/* verilator lint_off WIDTHTRUNC  */
   
module shift_right_with_round
  #(
    
    parameter   REAL_WIDTH             = 25,
    parameter   SHIFT_RIGHT            = 1
   )
   (
     input                              clk,
     input signed [REAL_WIDTH-1:0]      in_i,
     output reg signed [REAL_WIDTH-1:0] out_ro
   );

   initial out_ro = 0;
   
   generate

      if(SHIFT_RIGHT==0)
        begin : shift_right_zero
           `r out_ro <= in_i;
        end
      else
        begin : shift_right_nonzero

           //
           // Here just sign-extend by one bit to prevent all possible overflow.  Then the shift right
           // will put back in the original REAL_WIDTH bit length.
           //
          
           wire                                 sign_bit_w;
           wire signed [REAL_WIDTH:0]           round_value_w;
           wire signed [REAL_WIDTH:0]           in_w;
           wire signed [REAL_WIDTH:0]           add_result_w;

           `w sign_bit_w          =  in_i[REAL_WIDTH-1];
           `w round_value_w       =  (SHIFT_RIGHT==1)  ?  { {REAL_WIDTH{1'b0}}, sign_bit_w }                                                : 
                                     (SHIFT_RIGHT==2)  ?  { 1'b0, sign_bit_w, ~sign_bit_w  }                                                :
                                     /**/                 { {(REAL_WIDTH-SHIFT_RIGHT){1'b0}}, sign_bit_w, {(SHIFT_RIGHT-1){~sign_bit_w}} }  ;
           `w in_w                =  { sign_bit_w, in_i };
           `w add_result_w        = in_w + round_value_w;
           `r out_ro             <= add_result_w >>> SHIFT_RIGHT;
           
           //
           // OLD rounding method.  Too complicated, no benefit.
           //
           //wire                                 sign_bit_w;
           //wire signed [REAL_WIDTH-1:0]         round_value_w;
           //wire signed [REAL_WIDTH-1:0]         add_result_w;
           //wire signed [REAL_WIDTH-1:0]         max_result_w;
           //wire                                 add_result_sign_w;
           //wire                         overflow_w;
           //wire signed [REAL_WIDTH-1:0] out_w;
           //  
           //`w sign_bit_w          =  in_i[REAL_WIDTH-1];
           //`w round_value_w       =  (SHIFT_RIGHT==1) ? sign_bit_w : { sign_bit_w, {(SHIFT_RIGHT-1){~sign_bit_w}} };
           //`w add_result_w        =  in_i + round_value_w;
           //`w add_result_sign_w   =  add_result_w[REAL_WIDTH-1];
           //`w max_result_w        =  { sign_bit_w, {(REAL_WIDTH-1){~sign_bit_w}} };
           //
           // Adding a positive rounding constant.  So when add_result is negative
           // after input being positive, we have overflow.
           //`w overflow_w          =  (add_result_sign_w&&!sign_bit_w);
           //
           //`w out_w               =  overflow_w  ?  (max_result_w >>> SHIFT_RIGHT)  :
           //                          /**/           (add_result_w >>> SHIFT_RIGHT)  ;
           //
           //`r out_ro             <=  out_w;
           //`r $display("in 0x%08x out 0x%08x, add_result=0x%08x, round_value=0x%08x, shift=%0d, sign_diff=%0d, max=0x%08x, overflow_w=%0d", in_i, out_w, add_result_w, round_value_w, SHIFT_RIGHT2, sign_bit_w != add_result_sign_w, max_result_w, overflow_w);
           //
           

        end

   endgenerate            

endmodule // shift_right_with_round


/* verilator lint_on WIDTHEXPAND  */
/* verilator lint_on WIDTHTRUNC  */
