#!/bin/bash

DESIGN=RFSoC4x2_BxBDemo1

if [ "$1" != "" ]; then
    echo ""
    echo "  Usage:  multi_compile.sh NAME"
    echo ""
    echo "    NAME is the base name of the output files."
    echo "    This will compile with 50 different random seeds"
    echo "    to try to get one that meets timing."
    echo ""
    exit 20
fi

vivado=`which vivado`

if [ ! -f "$vivado" ]; then
    echo "Vivado not found.  Set up build environment."
    exit 20
fi


vivado_version=`vivado -version 2>/dev/null | head -1 | sed 's/[ ][^ ]*$//'`

if [ "$vivado_version" != "vivado v2024.2" ]; then
    echo "This script was tested with vivado v2024.2."
    echo "Instead found vivado version \"$vivado_version\"."
    echo "echo This may cause issues, or may not."
    sleep 3
fi


CPUs=`nproc`

MAXJOBS=$(( CPUs / 4 ))

if [ $MAXJOBS -lt 1 ]; then
   MAXJOBS=1
fi

if [ $MAXJOBS -gt 20 ]; then
   MAXJOBS=20
fi

job_wait()
{
    sleep 1
    while true; do
	
	jobs >/dev/null  # This seems to be necessary to collect some jobs that are finished so new can start.
	JOBS=`jobs | wc -l`
	
	if [ "$JOBS" -lt $MAXJOBS ]; then
	    break;
	fi
	
        echo "Have $JOBS jobs, max is $MAXJOBS.  Sleeping until a job exits."
        sleep 10

    done
}

job_done_wait()
{
    while true; do
	
	jobs >/dev/null  # This seems to be necessary to collect some jobs that are finished so new can start.
	JOBS=`jobs | wc -l`
	
	if [ "$JOBS" = 0 ]; then
	    break;
	fi
	
        echo "Have $JOBS jobs still running.  Waiting until all are finished."
        sleep 30

    done
}

echo ""
echo "Beginning multi compile."
echo ""

dir_num=0
max_dirs=60

while [ $dir_num -lt $max_dirs ]; do

    dir_sum=$((base_num + dir_num)) 
    dir_with_zeros=`printf "%03d" $dir_sum`
    uncertainty_with_zeros=`printf "%03d" $dir_num`
    uncertainty=0.$uncertainty_with_zeros

    job_wait
	
    ./compile_design.sh $uncertainty &

    echo "Compile $dir_num started."
    
    dir_num=$((dir_num + 1))
    
done


job_done_wait


echo "All jobs are finished."

exit 0
