// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use, distribute, and modify
// this work, so long as such uses are non-commercial in nature,
// so long as any derived works are offered on the same terms,
// and so long as attribution is given to the original author.
// For further details, see the Creative Commons License
// "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//


#ifndef BXBAPP_CONFIG_H
#define BXBAPP_CONFIG_H

#include "String.hh"

extern String                 config_board_name;
extern int                    current_config_number;
extern struct bxbapp_config   current_config;
extern class  bxbapp_configs* allowable_configurations;

//
// These duplicate the contents of current_config, but are easier to use.
//
extern double sampling_rate_kHz;       // ADC only.  3932160;
extern double sampling_rate_MHz;       // ADC only.  sampling_rate_kHz / 1000.0;
extern double dac_sampling_rate_kHz;   // 3932160;
extern double dac_sampling_rate_MHz;   // sampling_rate_kHz / 1000.0;
extern int    num_freq_bins;           // 49152;
extern double freq_bin_separation_kHz; // sampling_rate_kHz / num_freq_bins;
extern double freq_bin_separation_MHz; // freq_bin_separation_kHz / 1000.0;
extern int    adc_samples_per_clock;   // 8;
extern int    dac_samples_per_clock;   // 8;
extern int    time_capture_length;     // 65536 = 8192 * adc_samples_per_clock
extern double spectral_gain_adjust_dB; // 0dB


class bxbapp_config
{
public:
  
  String   name;
  String   description;
  String   fpga_config_command;
  String   clock_config_command;

  long     adc_sampling_rate_hz;
  long     dac_sampling_rate_hz;
  int      adc_multiplier;
  int      dac_multiplier;
  bool     dac_loopback;
  int      adc_points_per_clock;
  int      dac_points_per_clock;
  int      time_capture_length;
  int      fft_output_size;
  double   spectral_gain_adjust_dB;
  bool     selectable_sampling_rate;
  bool     restart_app;
  long     spec_max_adc_sample_hz;
  
  void     print();

  void     set_adc_sampling_rate_hz(double freq_Hz);
  void     set_dac_sampling_rate_hz(double freq_Hz);

  bxbapp_config();
  ~bxbapp_config() {}
};


class bxbapp_configs
{
 public:
  static constexpr int MAX_CONFIGS = 10;
  
  struct bxbapp_config configs[MAX_CONFIGS];
  int                  num_configs;
    
  bxbapp_configs(const char* filename);
  ~bxbapp_configs() {}
};


void mark_current_config(int number);
void activate_current_config();


inline int next_higher_power_of_2(int x)
{
  int y = 1;
  while(y<x)
    y*=2;

  return y;
}


#endif
