// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use, distribute, and modify
// this work, so long as such uses are non-commercial in nature,
// so long as any derived works are offered on the same terms,
// and so long as attribution is given to the original author.
// For further details, see the Creative Commons License
// "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//


#ifndef DATA_COLORS_HH
#define DATA_COLORS_HH

#include "color.hh"

int sw_adc_to_hw_adc(int sw_adc);
int hw_adc_to_sw_adc(int hw_adc);
int sw_dac_to_hw_dac(int sw_dac);
int hw_dac_to_sw_dac(int hw_dac);

int sw_source_to_hw_source(int sw_source);

bool sw_source_is_adc(int sw_source);
bool sw_source_is_dac(int sw_source);
int  sw_source_to_sw_adc(int sw_source);
int  sw_source_to_sw_dac(int sw_source);
int  sw_source_to_hw_adc(int sw_source);
int  sw_source_to_hw_dac(int sw_source);


const char* adc_names_sw  (int adc_number_sw);
const char* adc_names_hw  (int adc_number_hw);
const char* dac_names_sw  (int dac_number_sw);
const char* dac_names_hw  (int dac_number_hw);

color       adc_colors_sw (int adc_number_sw);
color       adc_colors_hw (int adc_number_hw);
color       dac_colors_sw (int dac_number_sw);
color       dac_colors_hw (int dac_number_hw);

const char* source_names_sw  (int source_number_sw);
color       source_colors_sw (int source_number_sw);


#endif
