// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use, distribute, and modify
// this work, so long as such uses are non-commercial in nature,
// so long as any derived works are offered on the same terms,
// and so long as attribution is given to the original author.
// For further details, see the Creative Commons License
// "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//


#ifndef MENU_GRAPH_SELECT_HH
#define MENU_GRAPH_SELECT_HH

#include "menu.hh"
#include "all_svg.hh"
#include "multiselect.hh"
#include "select_one.hh"
#include "button.hh"
#include "data_update.hh"

class menu_graph_select : public menu
{
  void add(menu* m); // This type of menu is terminal; can't add children.  Thus make this private.

public:

  graph_config gc;
  
  int graph_type_x_offset;
  int graph_type_y_offset;
  int graph_type_width;
  int graph_type_height;

  int graph_reference_x_offset;
  int graph_reference_y_offset;
  int graph_reference_width;
  int graph_reference_height;

  int graph_source_x_offset;
  int graph_source_y_offset;
  int graph_source_width;
  int graph_source_height;

  int graph_x_units_x_offset;
  int graph_x_units_y_offset;
  int graph_x_units_width;
  int graph_x_units_height;

  int graph_y_units_x_offset;
  int graph_y_units_y_offset;
  int graph_y_units_width;
  int graph_y_units_height;

  int rect_left;
  int rect_right;
  int rect_top;
  int rect_bottom;
  
  int delete_margin;
  
  select_one*  sel_graph_type;
  multiselect* graph_source;
  select_one*  graph_reference;  // Used for transfer functions only.  reference -> source transfer
  select_one*  graph_x_units;
  select_one*  graph_y_units;
  select_one*  averaging_mode;
  button*      delete_graph;

  connection<multiselect, selection_changed_event, menu_graph_select, int, int>* c_graph_delete;
  connection<multiselect, selection_changed_event, menu_graph_select, int, int>* c_graph_type;
  connection<multiselect, selection_changed_event, menu_graph_select, int, int>* c_not_graph_type;

  const static color REGIONCOLOR        = GREY3;

  void update_x_units_possible_sampling_rate_change();
  
  virtual bool handle_event(my_event& me);
  virtual void draw_dirty();
  virtual void draw_dynamic();
  virtual void layout();

  virtual void this_selected();
  
  void rebuild_graph_select_from_gc(display* disp, const graph_config& gc);

  menu_graph_select(display* disp, const char* tagname, const graph_config& gc, color bg=BLACK);
  virtual ~menu_graph_select();
};



#endif
