
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use, distribute, and modify
// this work, so long as such uses are non-commercial in nature,
// so long as any derived works are offered on the same terms,
// and so long as attribution is given to the original author.
// For further details, see the Creative Commons License
// "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//


#include "intro.hh"
#include "multiwindow.hh"
#include "displays.hh"
#include "all_svg.hh"
#include "hwalloc.hh"
#include "RFSoC4x2_BxBDemo1.hh"


bool intro::copyright_printed            = false;
bool intro::display_initializing_clocks  = false;
bool intro::failed_initializing_clocks   = false;
bool intro::clocks_initialized           = false;
bool intro::demo_is_ready                = false;


void intro::layout()
{
  extern bool ZCU111;
  extern bool RFSoC4x2;
  
  if(width==10)
    {
      printf("intro::layout() called prior to resize!\n");
      fflush(stdout);
      abort();
    }
  //clear(BG_COLOR);

  float designed_height = 1080.0;
  float designed_width  = 1920.0;
  float ratio_x = width / designed_width;
  float ratio_y = height / designed_height;
  ratio = (ratio_x<ratio_y) ? ratio_x : ratio_y;
  
  int size    = 400 * ratio;
  int xmargin = 80 * ratio;
  int ymargin = 40 * ratio;
  draw_svg_from_data(BxB_svg, BxB_svg_length, width - size - xmargin, ymargin, size, size);


  set_text_size(90 * ratio);

  draw_text("BxB App",
	       WHITE,
	       width/2-100*ratio,
	       220*ratio,
	       DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
  

#ifdef NOTDEF
  draw_multicolored_text("\x0C" "Terms:  Free to read the license in Documents/License; other",
			    textcolors,
			    width/2-650*ratio,
			    370*ratio,
			    DRAW_TEXT_X_LEFT|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  draw_multicolored_text("\x0C" "use is only as allowed by the license.  Also ask about:",
			 textcolors,
			 width/2-650*ratio,
			 425*ratio,
			 DRAW_TEXT_X_LEFT|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);


  draw_text("* Analog System Analyzer/Emulator, Reflectometer",
	       GREEN7,
	       width/2-550*ratio,
	       500*ratio,
	       DRAW_TEXT_X_LEFT|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  draw_text("* Transmitters, Receivers, RF Front Ends, and Equalizers",
	       GREEN7,
	       width/2-550*ratio,
	       560*ratio,
	       DRAW_TEXT_X_LEFT|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  draw_text("* Spectral Routers, Switches, and Beamformers",
	       GREEN7,
	       width/2-550*ratio,
	       620*ratio,
	       DRAW_TEXT_X_LEFT|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  draw_text("Email for questions or payment (after free 30-day evaluation):  demos@bitbybitsp.com",
	       BLUE,
	       width/2-100*ratio,
	       700*ratio,
	       DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
#endif

  set_text_size(50 * ratio);
      
  draw_text("FPGA Board Evaluation, Spectrum Analyzer,",
	    GREEN7,
	    width/2-100*ratio,
	    380*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
  
  draw_text("Oscilloscope, and Signal Generator Application",
	    GREEN7,
	    width/2-100*ratio,
	    450*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
  
  
  set_text_size(40 * ratio);
  
  draw_text("Showing the Speed, Size, and Quality of BxBFFTs",
	    WHITE,
	    width/2-100*ratio,
	    540*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
  
  color textcolors[MAX_COLORS] = { GREEN7, REDRED8, WHITE };
  
  //
  // Saved as examples of multi colors
  //
  // "Signal Generator Demo\x0B (Forthcoming; now 10MHz sine)",
  // "\x0C" "Full version is for sale.\x0B (Forthcoming)\x0C  Also ask about:",
  
  set_text_size(30*ratio);
  
  draw_multicolored_text("\x0C" "Report bugs to",
			 textcolors,
			 width/2-100*ratio,
			 610*ratio,
			 DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
  
  set_text_size(40*ratio);
  
  draw_text("ross@bitbybitsp.com",
	    BLUE,
	    width/2-100*ratio,
	    670*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
  
  set_text_size(25*ratio);
  
  draw_multicolored_text("\x0C" "Copyright (C) 2023 Bit by Bit Signal Processing LLC",
			 textcolors,
			 width/2-100*ratio,
			 745*ratio,
			 DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
  
  if(RFSoC4x2)
    {
      draw_multicolored_text("\x0C" "Permission is granted for non-commercial use/distribution of the RFSoC4x2",
			     textcolors,
			     width/2-100*ratio,
			     775*ratio,
			     DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
      
      draw_multicolored_text("\x0C" "version of this app by academic institutions and by Real Digital LLC",
			     textcolors,
			     width/2-100*ratio,
			     805*ratio,
			     DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
    }
  else if(ZCU111)
    {
      draw_multicolored_text("\x0C" "Permission is granted for non-commercial use/distribution of the ZCU111",
			     textcolors,
			     width/2-100*ratio,
			     775*ratio,
			     DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
      
      draw_multicolored_text("\x0C" "version of this app by all interested parties",
			     textcolors,
			     width/2-100*ratio,
			     805*ratio,
			     DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
    }
  else if(ZCU111)
    {
      draw_multicolored_text("\x0C" "Use of this app version is only allowed through",
			     textcolors,
			     width/2-100*ratio,
			     775*ratio,
			     DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
      
      draw_multicolored_text("\x0C" "license from Bit by Bit Signal Processing LLC",
			     textcolors,
			     width/2-100*ratio,
			     805*ratio,
			     DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
    }
  
  //
  // Get DNA
  //
  volatile uint32_t* dna_loc = hwalloc<uint32_t>( HW_RFSoC4x2_BxBDemo1::AXI_DNA_0.C_BASEADDR /*0xA0040000*/, 4);

  char version_str[200];
  bool serious_error = false;
  
  
  if(!dna_loc)
    {
      sprintf(version_str, "Can't find FPGA PL DNA.  WARNING: FPGA bitfile mismatches software.");
      serious_error = true;
    }
  else
    {
      uint32_t dna0 = dna_loc[0];
      uint32_t dna1 = dna_loc[1];
      uint32_t dna2 = dna_loc[2];
      uint32_t hwversion = dna_loc[3];
      
      hwfree(dna_loc, 4);
      
      if((hwversion&0xFF000000)!=0xDC000000)
	{
	  sprintf(version_str, "WARNING: FPGA Bitfile Mismatches Software.");
	  serious_error = true;
	}
      else
	{
	  sprintf(version_str, "Demo HW %d.%d.%d, SW 4.3.0.  PL DNA %08x%08x%08x",
		  (hwversion>>16) & 0xFF,
		  (hwversion>>8)  & 0xFF,
		  hwversion       & 0xFF,
		  dna0,
		  dna1,
		  dna2);
	}
    }
  
  if(!copyright_printed)
    {
      copyright_printed = true;
      printf("%s\n", version_str);
      printf("Copyright (C) 2022 Bit by Bit Signal Processing LLC\n");
    }
  fflush(stdout);
  
  draw_text(version_str,
	    serious_error ? RED : GREY9,
	    width/2-100*ratio,
	    840*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  layout_dirty = false;
  dirty = true;
}


void intro::draw_dirty()
{
  dirty = false;
}


void intro::draw_dynamic()
{
  if(!demo_is_ready)
    {
      blink_on = false;
      blink_count = 0;
    }
  if(blink_count>=blink_interval)
    {
      blink_on = !blink_on;
      blink_count = 0;
    }
  else
    {
      blink_count++;
    }

  //printf("blink_count=%d, blink on=%d.\n", blink_count, blink_on);

  if(blink_on)
    {
#ifdef NOTDEF
      set_text_size(25 * ratio);

      draw_text("Agree to",
		GREEN,
		70 * ratio - 10,
		30 * ratio - 10,
		DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_CENTER|DRAW_TEXT_ROTATE_0);

      draw_text("Terms and",
		GREEN,
		70 * ratio - 10,
		64 * ratio - 10,
		DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_CENTER|DRAW_TEXT_ROTATE_0);
#endif
      
      set_text_size(40 * ratio);

      draw_text("Start",
		GREEN,
		65 * ratio - 10,
		64 * ratio - 10,
		DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_CENTER|DRAW_TEXT_ROTATE_0);
    }


  int progress_size       = 40 * ratio;
  int progress_step       = 50 * ratio;
  int progress_x_position = width/2-100 * ratio;
  int progress_y_position = 890 * ratio;
  
  set_text_size(progress_size);
  
  //  if(display_initializing_clocks)
  //    {
  //      draw_text("Initializing Clocks",
  //		BLUE,
  //		progress_x_position,
  //		progress_y_position,
  //		DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
  //    }
  
  
  if(failed_initializing_clocks)
    {
      draw_text("Failed to initialize ADCs and DACs",
		BLUE,
		progress_x_position,
		progress_y_position,
		DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
    }
  
  
  if(clocks_initialized)
    {
      //draw_text("Clocks Initialized",
      //	BLUE,
      //	progress_x_position,
      //	progress_y_position,
      //	DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
      //progress_y_position += progress_step;      
      
      draw_text("Clocks, ADCs, and DACs Initialized",
		BLUEBLUE,
		progress_x_position,
		progress_y_position,
		DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
      progress_y_position += progress_step;	
  
      if(demo_is_ready)
	{
	  draw_text("Application is Ready!",
		    GREEN,
		    progress_x_position,
		    progress_y_position,
		    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
	  progress_y_position += progress_step;
	}
    }
  else
    {
      draw_text("Initializing Clocks",
		BLUEBLUE,
		progress_x_position+20,
		progress_y_position,
		DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
      progress_y_position += progress_step;	
    }

  // If we're on the intro page, no need to redraw too fast.  It just waste
  // battery on web displays.  Slow things down here.  But not too slow, or
  // the mouse gets jerky
  usleep(20000);
}



intro::intro() : window(BLACK)
{
  blink_count                  = 0;
  blink_on                     = false;
  ratio                        = 1;
}


intro::~intro()
{
}

