// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use, distribute, and modify
// this work, so long as such uses are non-commercial in nature,
// so long as any derived works are offered on the same terms,
// and so long as attribution is given to the original author.
// For further details, see the Creative Commons License
// "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "setup_XRFdc_config.h"
#include "RFSoC4x2_BxBDemo1.hh"



void MySetupXRFdc_Config(XRFdc_Config *c)
{
  using namespace HW_RFSoC4x2_BxBDemo1;
  const int UNKNOWN = 0;  // Marking items where I'm not sure how to derive the value.

  struct HW_usp_rf_data_converter& a = ADC_DAC_usp_rf_data_converter_1;
    
  c->DeviceId           = 0;
  c->BaseAddr           = a.C_BASEADDR;
  c->ADCType            = a.C_High_Speed_ADC;   /* ADC Type 4GSPS or 2GSPS*/
  c->MasterADCTile      = UNKNOWN;              /* ADC master Tile */
  c->MasterDACTile      = UNKNOWN;              /* DAC Master Tile */
  c->ADCSysRefSource    = a.C_Sysref_Source;
  c->DACSysRefSource    = a.C_Sysref_Source;
  c->IPType             = a.C_IP_Type;
  c->SiRevision         = a.C_Silicon_Revision;

  // DAC Tile 0
  
  c->DACTile_Config[0].Enable            = a.C_DAC0_Enable;
  c->DACTile_Config[0].PLLEnable         = a.C_DAC0_PLL_Enable;
  c->DACTile_Config[0].SamplingRate      = a.C_DAC0_Sampling_Rate;
  c->DACTile_Config[0].RefClkFreq        = a.C_DAC0_Refclk_Freq;
  c->DACTile_Config[0].FabClkFreq        = a.C_DAC0_Fabric_Freq;
  c->DACTile_Config[0].FeedbackDiv       = a.C_DAC0_FBDIV;
  c->DACTile_Config[0].OutputDiv         = a.C_DAC0_OutDiv;
  c->DACTile_Config[0].RefClkDiv         = a.C_DAC0_Refclk_Div;
  c->DACTile_Config[0].MultibandConfig   = a.C_DAC0_Band;
  c->DACTile_Config[0].MaxSampleRate     = a.C_DAC0_Fs_Max;
  c->DACTile_Config[0].NumSlices         = a.C_DAC0_Slices;

  // DAC Tile 0 Analog
  
  c->DACTile_Config[0].DACBlock_Analog_Config[0].BlockAvailable   = a.C_DAC_Slice00_Enable;
  c->DACTile_Config[0].DACBlock_Analog_Config[0].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl00;
  c->DACTile_Config[0].DACBlock_Analog_Config[0].MixMode          = a.C_DAC_Mixer_Mode00;
  c->DACTile_Config[0].DACBlock_Analog_Config[0].DecoderMode      = a.C_DAC_Decoder_Mode00;

  c->DACTile_Config[0].DACBlock_Analog_Config[1].BlockAvailable   = a.C_DAC_Slice01_Enable;
  c->DACTile_Config[0].DACBlock_Analog_Config[1].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl01;
  c->DACTile_Config[0].DACBlock_Analog_Config[1].MixMode          = a.C_DAC_Mixer_Mode01;
  c->DACTile_Config[0].DACBlock_Analog_Config[1].DecoderMode      = a.C_DAC_Decoder_Mode01;

  c->DACTile_Config[0].DACBlock_Analog_Config[2].BlockAvailable   = a.C_DAC_Slice02_Enable;
  c->DACTile_Config[0].DACBlock_Analog_Config[2].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl02;
  c->DACTile_Config[0].DACBlock_Analog_Config[2].MixMode          = a.C_DAC_Mixer_Mode02;
  c->DACTile_Config[0].DACBlock_Analog_Config[2].DecoderMode      = a.C_DAC_Decoder_Mode02;

  c->DACTile_Config[0].DACBlock_Analog_Config[3].BlockAvailable   = a.C_DAC_Slice03_Enable;
  c->DACTile_Config[0].DACBlock_Analog_Config[3].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl03;
  c->DACTile_Config[0].DACBlock_Analog_Config[3].MixMode          = a.C_DAC_Mixer_Mode03;
  c->DACTile_Config[0].DACBlock_Analog_Config[3].DecoderMode      = a.C_DAC_Decoder_Mode03;

  // DAC Tile 0 Digital
  
  c->DACTile_Config[0].DACBlock_Digital_Config[0].MixerInputDataType  = a.C_DAC_Data_Type00;
  c->DACTile_Config[0].DACBlock_Digital_Config[0].DataWidth           = a.C_DAC_Data_Width00;
  c->DACTile_Config[0].DACBlock_Digital_Config[0].InterpolationMode   = a.C_DAC_Interpolation_Mode00;
  c->DACTile_Config[0].DACBlock_Digital_Config[0].FifoEnable          = UNKNOWN;
  c->DACTile_Config[0].DACBlock_Digital_Config[0].AdderEnable         = UNKNOWN;
  c->DACTile_Config[0].DACBlock_Digital_Config[0].MixerType           = a.C_DAC_Mixer_Type00;

  c->DACTile_Config[0].DACBlock_Digital_Config[1].MixerInputDataType  = a.C_DAC_Data_Type01;
  c->DACTile_Config[0].DACBlock_Digital_Config[1].DataWidth           = a.C_DAC_Data_Width01;
  c->DACTile_Config[0].DACBlock_Digital_Config[1].InterpolationMode   = a.C_DAC_Interpolation_Mode01;
  c->DACTile_Config[0].DACBlock_Digital_Config[1].FifoEnable          = UNKNOWN;
  c->DACTile_Config[0].DACBlock_Digital_Config[1].AdderEnable         = UNKNOWN;
  c->DACTile_Config[0].DACBlock_Digital_Config[1].MixerType           = a.C_DAC_Mixer_Type01;

  c->DACTile_Config[0].DACBlock_Digital_Config[2].MixerInputDataType  = a.C_DAC_Data_Type02;
  c->DACTile_Config[0].DACBlock_Digital_Config[2].DataWidth           = a.C_DAC_Data_Width02;
  c->DACTile_Config[0].DACBlock_Digital_Config[2].InterpolationMode   = a.C_DAC_Interpolation_Mode02;
  c->DACTile_Config[0].DACBlock_Digital_Config[2].FifoEnable          = UNKNOWN;
  c->DACTile_Config[0].DACBlock_Digital_Config[2].AdderEnable         = UNKNOWN;
  c->DACTile_Config[0].DACBlock_Digital_Config[2].MixerType           = a.C_DAC_Mixer_Type02;

  c->DACTile_Config[0].DACBlock_Digital_Config[3].MixerInputDataType  = a.C_DAC_Data_Type03;
  c->DACTile_Config[0].DACBlock_Digital_Config[3].DataWidth           = a.C_DAC_Data_Width03;
  c->DACTile_Config[0].DACBlock_Digital_Config[3].InterpolationMode   = a.C_DAC_Interpolation_Mode03;
  c->DACTile_Config[0].DACBlock_Digital_Config[3].FifoEnable          = UNKNOWN;
  c->DACTile_Config[0].DACBlock_Digital_Config[3].AdderEnable         = UNKNOWN;
  c->DACTile_Config[0].DACBlock_Digital_Config[3].MixerType           = a.C_DAC_Mixer_Type03;


  // DAC Tile 1

  c->DACTile_Config[1].Enable            = a.C_DAC1_Enable;
  c->DACTile_Config[1].PLLEnable         = a.C_DAC1_PLL_Enable;
  c->DACTile_Config[1].SamplingRate      = a.C_DAC1_Sampling_Rate;
  c->DACTile_Config[1].RefClkFreq        = a.C_DAC1_Refclk_Freq;
  c->DACTile_Config[1].FabClkFreq        = a.C_DAC1_Fabric_Freq;
  c->DACTile_Config[1].FeedbackDiv       = a.C_DAC1_FBDIV;
  c->DACTile_Config[1].OutputDiv         = a.C_DAC1_OutDiv;
  c->DACTile_Config[1].RefClkDiv         = a.C_DAC1_Refclk_Div;
  c->DACTile_Config[1].MultibandConfig   = a.C_DAC1_Band;
  c->DACTile_Config[1].MaxSampleRate     = a.C_DAC1_Fs_Max;
  c->DACTile_Config[1].NumSlices         = a.C_DAC1_Slices;

  // DAC Tile 1 Analog

  c->DACTile_Config[1].DACBlock_Analog_Config[0].BlockAvailable   = a.C_DAC_Slice10_Enable;
  c->DACTile_Config[1].DACBlock_Analog_Config[0].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl10;
  c->DACTile_Config[1].DACBlock_Analog_Config[0].MixMode          = a.C_DAC_Mixer_Mode10;
  c->DACTile_Config[1].DACBlock_Analog_Config[0].DecoderMode      = a.C_DAC_Decoder_Mode10;

  c->DACTile_Config[1].DACBlock_Analog_Config[1].BlockAvailable   = a.C_DAC_Slice11_Enable;
  c->DACTile_Config[1].DACBlock_Analog_Config[1].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl11;
  c->DACTile_Config[1].DACBlock_Analog_Config[1].MixMode          = a.C_DAC_Mixer_Mode11;
  c->DACTile_Config[1].DACBlock_Analog_Config[1].DecoderMode      = a.C_DAC_Decoder_Mode11;

  c->DACTile_Config[1].DACBlock_Analog_Config[2].BlockAvailable   = a.C_DAC_Slice12_Enable;
  c->DACTile_Config[1].DACBlock_Analog_Config[2].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl12;
  c->DACTile_Config[1].DACBlock_Analog_Config[2].MixMode          = a.C_DAC_Mixer_Mode12;
  c->DACTile_Config[1].DACBlock_Analog_Config[2].DecoderMode      = a.C_DAC_Decoder_Mode12;

  c->DACTile_Config[1].DACBlock_Analog_Config[3].BlockAvailable   = a.C_DAC_Slice13_Enable;
  c->DACTile_Config[1].DACBlock_Analog_Config[3].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl13;
  c->DACTile_Config[1].DACBlock_Analog_Config[3].MixMode          = a.C_DAC_Mixer_Mode13;
  c->DACTile_Config[1].DACBlock_Analog_Config[3].DecoderMode      = a.C_DAC_Decoder_Mode13;

  // DAC Tile 1 Digital

  c->DACTile_Config[1].DACBlock_Digital_Config[0].MixerInputDataType  = a.C_DAC_Data_Type10;
  c->DACTile_Config[1].DACBlock_Digital_Config[0].DataWidth           = a.C_DAC_Data_Width10;
  c->DACTile_Config[1].DACBlock_Digital_Config[0].InterpolationMode   = a.C_DAC_Interpolation_Mode10;
  c->DACTile_Config[1].DACBlock_Digital_Config[0].FifoEnable          = UNKNOWN;
  c->DACTile_Config[1].DACBlock_Digital_Config[0].AdderEnable         = UNKNOWN;
  c->DACTile_Config[1].DACBlock_Digital_Config[0].MixerType           = a.C_DAC_Mixer_Type10;

  c->DACTile_Config[1].DACBlock_Digital_Config[1].MixerInputDataType  = a.C_DAC_Data_Type11;
  c->DACTile_Config[1].DACBlock_Digital_Config[1].DataWidth           = a.C_DAC_Data_Width11;
  c->DACTile_Config[1].DACBlock_Digital_Config[1].InterpolationMode   = a.C_DAC_Interpolation_Mode11;
  c->DACTile_Config[1].DACBlock_Digital_Config[1].FifoEnable          = UNKNOWN;
  c->DACTile_Config[1].DACBlock_Digital_Config[1].AdderEnable         = UNKNOWN;
  c->DACTile_Config[1].DACBlock_Digital_Config[1].MixerType           = a.C_DAC_Mixer_Type11;

  c->DACTile_Config[1].DACBlock_Digital_Config[2].MixerInputDataType  = a.C_DAC_Data_Type12;
  c->DACTile_Config[1].DACBlock_Digital_Config[2].DataWidth           = a.C_DAC_Data_Width12;
  c->DACTile_Config[1].DACBlock_Digital_Config[2].InterpolationMode   = a.C_DAC_Interpolation_Mode12;
  c->DACTile_Config[1].DACBlock_Digital_Config[2].FifoEnable          = UNKNOWN;
  c->DACTile_Config[1].DACBlock_Digital_Config[2].AdderEnable         = UNKNOWN;
  c->DACTile_Config[1].DACBlock_Digital_Config[2].MixerType           = a.C_DAC_Mixer_Type12;

  c->DACTile_Config[1].DACBlock_Digital_Config[3].MixerInputDataType  = a.C_DAC_Data_Type13;
  c->DACTile_Config[1].DACBlock_Digital_Config[3].DataWidth           = a.C_DAC_Data_Width13;
  c->DACTile_Config[1].DACBlock_Digital_Config[3].InterpolationMode   = a.C_DAC_Interpolation_Mode13;
  c->DACTile_Config[1].DACBlock_Digital_Config[3].FifoEnable          = UNKNOWN;
  c->DACTile_Config[1].DACBlock_Digital_Config[3].AdderEnable         = UNKNOWN;
  c->DACTile_Config[1].DACBlock_Digital_Config[3].MixerType           = a.C_DAC_Mixer_Type13;


  // DAC Tile 2

  c->DACTile_Config[2].Enable            = a.C_DAC2_Enable;
  c->DACTile_Config[2].PLLEnable         = a.C_DAC2_PLL_Enable;
  c->DACTile_Config[2].SamplingRate      = a.C_DAC2_Sampling_Rate;
  c->DACTile_Config[2].RefClkFreq        = a.C_DAC2_Refclk_Freq;
  c->DACTile_Config[2].FabClkFreq        = a.C_DAC2_Fabric_Freq;
  c->DACTile_Config[2].FeedbackDiv       = a.C_DAC2_FBDIV;
  c->DACTile_Config[2].OutputDiv         = a.C_DAC2_OutDiv;
  c->DACTile_Config[2].RefClkDiv         = a.C_DAC2_Refclk_Div;
  c->DACTile_Config[2].MultibandConfig   = a.C_DAC2_Band;
  c->DACTile_Config[2].MaxSampleRate     = a.C_DAC2_Fs_Max;
  c->DACTile_Config[2].NumSlices         = a.C_DAC2_Slices;

  // DAC Tile 2 Analog

  c->DACTile_Config[2].DACBlock_Analog_Config[0].BlockAvailable   = a.C_DAC_Slice20_Enable;
  c->DACTile_Config[2].DACBlock_Analog_Config[0].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl20;
  c->DACTile_Config[2].DACBlock_Analog_Config[0].MixMode          = a.C_DAC_Mixer_Mode20;
  c->DACTile_Config[2].DACBlock_Analog_Config[0].DecoderMode      = a.C_DAC_Decoder_Mode20;

  c->DACTile_Config[2].DACBlock_Analog_Config[1].BlockAvailable   = a.C_DAC_Slice21_Enable;
  c->DACTile_Config[2].DACBlock_Analog_Config[1].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl21;
  c->DACTile_Config[2].DACBlock_Analog_Config[1].MixMode          = a.C_DAC_Mixer_Mode21;
  c->DACTile_Config[2].DACBlock_Analog_Config[1].DecoderMode      = a.C_DAC_Decoder_Mode21;

  c->DACTile_Config[2].DACBlock_Analog_Config[2].BlockAvailable   = a.C_DAC_Slice22_Enable;
  c->DACTile_Config[2].DACBlock_Analog_Config[2].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl22;
  c->DACTile_Config[2].DACBlock_Analog_Config[2].MixMode          = a.C_DAC_Mixer_Mode22;
  c->DACTile_Config[2].DACBlock_Analog_Config[2].DecoderMode      = a.C_DAC_Decoder_Mode22;

  c->DACTile_Config[2].DACBlock_Analog_Config[3].BlockAvailable   = a.C_DAC_Slice23_Enable;
  c->DACTile_Config[2].DACBlock_Analog_Config[3].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl23;
  c->DACTile_Config[2].DACBlock_Analog_Config[3].MixMode          = a.C_DAC_Mixer_Mode23;
  c->DACTile_Config[2].DACBlock_Analog_Config[3].DecoderMode      = a.C_DAC_Decoder_Mode23;

  // DAC Tile 2 Digital

  c->DACTile_Config[2].DACBlock_Digital_Config[0].MixerInputDataType  = a.C_DAC_Data_Type20;
  c->DACTile_Config[2].DACBlock_Digital_Config[0].DataWidth           = a.C_DAC_Data_Width20;
  c->DACTile_Config[2].DACBlock_Digital_Config[0].InterpolationMode   = a.C_DAC_Interpolation_Mode20;
  c->DACTile_Config[2].DACBlock_Digital_Config[0].FifoEnable          = UNKNOWN;
  c->DACTile_Config[2].DACBlock_Digital_Config[0].AdderEnable         = UNKNOWN;
  c->DACTile_Config[2].DACBlock_Digital_Config[0].MixerType           = a.C_DAC_Mixer_Type20;

  c->DACTile_Config[2].DACBlock_Digital_Config[1].MixerInputDataType  = a.C_DAC_Data_Type21;
  c->DACTile_Config[2].DACBlock_Digital_Config[1].DataWidth           = a.C_DAC_Data_Width21;
  c->DACTile_Config[2].DACBlock_Digital_Config[1].InterpolationMode   = a.C_DAC_Interpolation_Mode21;
  c->DACTile_Config[2].DACBlock_Digital_Config[1].FifoEnable          = UNKNOWN;
  c->DACTile_Config[2].DACBlock_Digital_Config[1].AdderEnable         = UNKNOWN;
  c->DACTile_Config[2].DACBlock_Digital_Config[1].MixerType           = a.C_DAC_Mixer_Type21;

  c->DACTile_Config[2].DACBlock_Digital_Config[2].MixerInputDataType  = a.C_DAC_Data_Type22;
  c->DACTile_Config[2].DACBlock_Digital_Config[2].DataWidth           = a.C_DAC_Data_Width22;
  c->DACTile_Config[2].DACBlock_Digital_Config[2].InterpolationMode   = a.C_DAC_Interpolation_Mode22;
  c->DACTile_Config[2].DACBlock_Digital_Config[2].FifoEnable          = UNKNOWN;
  c->DACTile_Config[2].DACBlock_Digital_Config[2].AdderEnable         = UNKNOWN;
  c->DACTile_Config[2].DACBlock_Digital_Config[2].MixerType           = a.C_DAC_Mixer_Type22;

  c->DACTile_Config[2].DACBlock_Digital_Config[3].MixerInputDataType  = a.C_DAC_Data_Type23;
  c->DACTile_Config[2].DACBlock_Digital_Config[3].DataWidth           = a.C_DAC_Data_Width23;
  c->DACTile_Config[2].DACBlock_Digital_Config[3].InterpolationMode   = a.C_DAC_Interpolation_Mode23;
  c->DACTile_Config[2].DACBlock_Digital_Config[3].FifoEnable          = UNKNOWN;
  c->DACTile_Config[2].DACBlock_Digital_Config[3].AdderEnable         = UNKNOWN;
  c->DACTile_Config[2].DACBlock_Digital_Config[3].MixerType           = a.C_DAC_Mixer_Type23;


  // DAC Tile 3

  c->DACTile_Config[3].Enable            = a.C_DAC3_Enable;
  c->DACTile_Config[3].PLLEnable         = a.C_DAC3_PLL_Enable;
  c->DACTile_Config[3].SamplingRate      = a.C_DAC3_Sampling_Rate;
  c->DACTile_Config[3].RefClkFreq        = a.C_DAC3_Refclk_Freq;
  c->DACTile_Config[3].FabClkFreq        = a.C_DAC3_Fabric_Freq;
  c->DACTile_Config[3].FeedbackDiv       = a.C_DAC3_FBDIV;
  c->DACTile_Config[3].OutputDiv         = a.C_DAC3_OutDiv;
  c->DACTile_Config[3].RefClkDiv         = a.C_DAC3_Refclk_Div;
  c->DACTile_Config[3].MultibandConfig   = a.C_DAC3_Band;
  c->DACTile_Config[3].MaxSampleRate     = a.C_DAC3_Fs_Max;
  c->DACTile_Config[3].NumSlices         = a.C_DAC3_Slices;

  // DAC Tile 3 Analog
  
  c->DACTile_Config[3].DACBlock_Analog_Config[0].BlockAvailable   = a.C_DAC_Slice30_Enable;
  c->DACTile_Config[3].DACBlock_Analog_Config[0].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl30;
  c->DACTile_Config[3].DACBlock_Analog_Config[0].MixMode          = a.C_DAC_Mixer_Mode30;
  c->DACTile_Config[3].DACBlock_Analog_Config[0].DecoderMode      = a.C_DAC_Decoder_Mode30;

  c->DACTile_Config[3].DACBlock_Analog_Config[1].BlockAvailable   = a.C_DAC_Slice31_Enable;
  c->DACTile_Config[3].DACBlock_Analog_Config[1].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl31;
  c->DACTile_Config[3].DACBlock_Analog_Config[1].MixMode          = a.C_DAC_Mixer_Mode31;
  c->DACTile_Config[3].DACBlock_Analog_Config[1].DecoderMode      = a.C_DAC_Decoder_Mode31;

  c->DACTile_Config[3].DACBlock_Analog_Config[2].BlockAvailable   = a.C_DAC_Slice32_Enable;
  c->DACTile_Config[3].DACBlock_Analog_Config[2].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl32;
  c->DACTile_Config[3].DACBlock_Analog_Config[2].MixMode          = a.C_DAC_Mixer_Mode32;
  c->DACTile_Config[3].DACBlock_Analog_Config[2].DecoderMode      = a.C_DAC_Decoder_Mode32;

  c->DACTile_Config[3].DACBlock_Analog_Config[3].BlockAvailable   = a.C_DAC_Slice33_Enable;
  c->DACTile_Config[3].DACBlock_Analog_Config[3].InvSyncEnable    = a.C_DAC_Invsinc_Ctrl33;
  c->DACTile_Config[3].DACBlock_Analog_Config[3].MixMode          = a.C_DAC_Mixer_Mode33;
  c->DACTile_Config[3].DACBlock_Analog_Config[3].DecoderMode      = a.C_DAC_Decoder_Mode33;

  // DAC Tile 3 Digital

  c->DACTile_Config[3].DACBlock_Digital_Config[0].MixerInputDataType  = a.C_DAC_Data_Type30;
  c->DACTile_Config[3].DACBlock_Digital_Config[0].DataWidth           = a.C_DAC_Data_Width30;
  c->DACTile_Config[3].DACBlock_Digital_Config[0].InterpolationMode   = a.C_DAC_Interpolation_Mode30;
  c->DACTile_Config[3].DACBlock_Digital_Config[0].FifoEnable          = UNKNOWN;
  c->DACTile_Config[3].DACBlock_Digital_Config[0].AdderEnable         = UNKNOWN;
  c->DACTile_Config[3].DACBlock_Digital_Config[0].MixerType           = a.C_DAC_Mixer_Type30;

  c->DACTile_Config[3].DACBlock_Digital_Config[1].MixerInputDataType  = a.C_DAC_Data_Type31;
  c->DACTile_Config[3].DACBlock_Digital_Config[1].DataWidth           = a.C_DAC_Data_Width31;
  c->DACTile_Config[3].DACBlock_Digital_Config[1].InterpolationMode   = a.C_DAC_Interpolation_Mode31;
  c->DACTile_Config[3].DACBlock_Digital_Config[1].FifoEnable          = UNKNOWN;
  c->DACTile_Config[3].DACBlock_Digital_Config[1].AdderEnable         = UNKNOWN;
  c->DACTile_Config[3].DACBlock_Digital_Config[1].MixerType           = a.C_DAC_Mixer_Type31;

  c->DACTile_Config[3].DACBlock_Digital_Config[2].MixerInputDataType  = a.C_DAC_Data_Type32;
  c->DACTile_Config[3].DACBlock_Digital_Config[2].DataWidth           = a.C_DAC_Data_Width32;
  c->DACTile_Config[3].DACBlock_Digital_Config[2].InterpolationMode   = a.C_DAC_Interpolation_Mode02;
  c->DACTile_Config[3].DACBlock_Digital_Config[2].FifoEnable          = UNKNOWN;
  c->DACTile_Config[3].DACBlock_Digital_Config[2].AdderEnable         = UNKNOWN;
  c->DACTile_Config[3].DACBlock_Digital_Config[2].MixerType           = a.C_DAC_Mixer_Type32;

  c->DACTile_Config[3].DACBlock_Digital_Config[3].MixerInputDataType  = a.C_DAC_Data_Type33;
  c->DACTile_Config[3].DACBlock_Digital_Config[3].DataWidth           = a.C_DAC_Data_Width33;
  c->DACTile_Config[3].DACBlock_Digital_Config[3].InterpolationMode   = a.C_DAC_Interpolation_Mode33;
  c->DACTile_Config[3].DACBlock_Digital_Config[3].FifoEnable          = UNKNOWN;
  c->DACTile_Config[3].DACBlock_Digital_Config[3].AdderEnable         = UNKNOWN;
  c->DACTile_Config[3].DACBlock_Digital_Config[3].MixerType           = a.C_DAC_Mixer_Type33;


  // ADC Tile 0

  c->ADCTile_Config[0].Enable           = a.C_ADC0_Enable;
  c->ADCTile_Config[0].PLLEnable        = a.C_ADC0_PLL_Enable;
  c->ADCTile_Config[0].SamplingRate     = a.C_ADC0_Sampling_Rate;
  c->ADCTile_Config[0].RefClkFreq       = a.C_ADC0_Refclk_Freq;
  c->ADCTile_Config[0].FabClkFreq       = a.C_ADC0_Fabric_Freq;
  c->ADCTile_Config[0].FeedbackDiv      = a.C_ADC0_FBDIV;
  c->ADCTile_Config[0].OutputDiv        = a.C_ADC0_OutDiv;
  c->ADCTile_Config[0].RefClkDiv        = a.C_ADC0_Refclk_Div;
  c->ADCTile_Config[0].MultibandConfig  = a.C_ADC0_Band;
  c->ADCTile_Config[0].MaxSampleRate    = a.C_ADC0_Fs_Max;
  c->ADCTile_Config[0].NumSlices        = a.C_ADC0_Slices;

  // ADC Tile 0 Analog

  c->ADCTile_Config[0].ADCBlock_Analog_Config[0].BlockAvailable   = a.C_ADC_Slice00_Enable;
  c->ADCTile_Config[0].ADCBlock_Analog_Config[0].MixMode          = a.C_ADC_Mixer_Mode00;

  c->ADCTile_Config[0].ADCBlock_Analog_Config[1].BlockAvailable   = a.C_ADC_Slice01_Enable;
  c->ADCTile_Config[0].ADCBlock_Analog_Config[1].MixMode          = a.C_ADC_Mixer_Mode01;

  c->ADCTile_Config[0].ADCBlock_Analog_Config[2].BlockAvailable   = a.C_ADC_Slice02_Enable;
  c->ADCTile_Config[0].ADCBlock_Analog_Config[2].MixMode          = a.C_ADC_Mixer_Mode02;

  c->ADCTile_Config[0].ADCBlock_Analog_Config[3].BlockAvailable   = a.C_ADC_Slice03_Enable;
  c->ADCTile_Config[0].ADCBlock_Analog_Config[3].MixMode          = a.C_ADC_Mixer_Mode03;

  // ADC Tile 0 Digital

  c->ADCTile_Config[0].ADCBlock_Digital_Config[0].MixerInputDataType  = a.C_ADC_Data_Type00;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[0].DataWidth           = a.C_ADC_Data_Width00;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[0].DecimationMode      = a.C_ADC_Decimation_Mode00;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[0].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[0].MixerType           = a.C_ADC_Mixer_Type00;

  c->ADCTile_Config[0].ADCBlock_Digital_Config[1].MixerInputDataType  = a.C_ADC_Data_Type01;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[1].DataWidth           = a.C_ADC_Data_Width01;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[1].DecimationMode      = a.C_ADC_Decimation_Mode01;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[1].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[1].MixerType           = a.C_ADC_Mixer_Type01;

  c->ADCTile_Config[0].ADCBlock_Digital_Config[2].MixerInputDataType  = a.C_ADC_Data_Type02;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[2].DataWidth           = a.C_ADC_Data_Width02;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[2].DecimationMode      = a.C_ADC_Decimation_Mode02;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[2].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[2].MixerType           = a.C_ADC_Mixer_Type02;

  c->ADCTile_Config[0].ADCBlock_Digital_Config[3].MixerInputDataType  = a.C_ADC_Data_Type03;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[3].DataWidth           = a.C_ADC_Data_Width03;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[3].DecimationMode      = a.C_ADC_Decimation_Mode03;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[3].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[0].ADCBlock_Digital_Config[3].MixerType           = a.C_ADC_Mixer_Type03;
  


  // ADC Tile 1

  c->ADCTile_Config[1].Enable           = a.C_ADC1_Enable;
  c->ADCTile_Config[1].PLLEnable        = a.C_ADC1_PLL_Enable;
  c->ADCTile_Config[1].SamplingRate     = a.C_ADC1_Sampling_Rate;
  c->ADCTile_Config[1].RefClkFreq       = a.C_ADC1_Refclk_Freq;
  c->ADCTile_Config[1].FabClkFreq       = a.C_ADC1_Fabric_Freq;
  c->ADCTile_Config[1].FeedbackDiv      = a.C_ADC1_FBDIV;
  c->ADCTile_Config[1].OutputDiv        = a.C_ADC1_OutDiv;
  c->ADCTile_Config[1].RefClkDiv        = a.C_ADC1_Refclk_Div;
  c->ADCTile_Config[1].MultibandConfig  = a.C_ADC1_Band;
  c->ADCTile_Config[1].MaxSampleRate    = a.C_ADC1_Fs_Max;
  c->ADCTile_Config[1].NumSlices        = a.C_ADC1_Slices;

  // ADC Tile 1 Analog

  c->ADCTile_Config[1].ADCBlock_Analog_Config[0].BlockAvailable   = a.C_ADC_Slice10_Enable;
  c->ADCTile_Config[1].ADCBlock_Analog_Config[0].MixMode          = a.C_ADC_Mixer_Mode10;

  c->ADCTile_Config[1].ADCBlock_Analog_Config[1].BlockAvailable   = a.C_ADC_Slice11_Enable;
  c->ADCTile_Config[1].ADCBlock_Analog_Config[1].MixMode          = a.C_ADC_Mixer_Mode11;

  c->ADCTile_Config[1].ADCBlock_Analog_Config[2].BlockAvailable   = a.C_ADC_Slice12_Enable;
  c->ADCTile_Config[1].ADCBlock_Analog_Config[2].MixMode          = a.C_ADC_Mixer_Mode12;

  c->ADCTile_Config[1].ADCBlock_Analog_Config[3].BlockAvailable   = a.C_ADC_Slice13_Enable;
  c->ADCTile_Config[1].ADCBlock_Analog_Config[3].MixMode          = a.C_ADC_Mixer_Mode13;

  // ADC Tile 1 Digital

  c->ADCTile_Config[1].ADCBlock_Digital_Config[0].MixerInputDataType  = a.C_ADC_Data_Type10;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[0].DataWidth           = a.C_ADC_Data_Width10;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[0].DecimationMode      = a.C_ADC_Decimation_Mode10;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[0].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[0].MixerType           = a.C_ADC_Mixer_Type10;

  c->ADCTile_Config[1].ADCBlock_Digital_Config[1].MixerInputDataType  = a.C_ADC_Data_Type11;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[1].DataWidth           = a.C_ADC_Data_Width11;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[1].DecimationMode      = a.C_ADC_Decimation_Mode11;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[1].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[1].MixerType           = a.C_ADC_Mixer_Type11;

  c->ADCTile_Config[1].ADCBlock_Digital_Config[2].MixerInputDataType  = a.C_ADC_Data_Type12;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[2].DataWidth           = a.C_ADC_Data_Width12;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[2].DecimationMode      = a.C_ADC_Decimation_Mode12;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[2].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[2].MixerType           = a.C_ADC_Mixer_Type12;

  c->ADCTile_Config[1].ADCBlock_Digital_Config[3].MixerInputDataType  = a.C_ADC_Data_Type13;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[3].DataWidth           = a.C_ADC_Data_Width13;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[3].DecimationMode      = a.C_ADC_Decimation_Mode13;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[3].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[1].ADCBlock_Digital_Config[3].MixerType           = a.C_ADC_Mixer_Type13;
  

  // ADC Tile 2

  c->ADCTile_Config[2].Enable           = a.C_ADC2_Enable;
  c->ADCTile_Config[2].PLLEnable        = a.C_ADC2_PLL_Enable;
  c->ADCTile_Config[2].SamplingRate     = a.C_ADC2_Sampling_Rate;
  c->ADCTile_Config[2].RefClkFreq       = a.C_ADC2_Refclk_Freq;
  c->ADCTile_Config[2].FabClkFreq       = a.C_ADC2_Fabric_Freq;
  c->ADCTile_Config[2].FeedbackDiv      = a.C_ADC2_FBDIV;
  c->ADCTile_Config[2].OutputDiv        = a.C_ADC2_OutDiv;
  c->ADCTile_Config[2].RefClkDiv        = a.C_ADC2_Refclk_Div;
  c->ADCTile_Config[2].MultibandConfig  = a.C_ADC2_Band;
  c->ADCTile_Config[2].MaxSampleRate    = a.C_ADC2_Fs_Max;
  c->ADCTile_Config[2].NumSlices        = a.C_ADC2_Slices;

  // ADC Tile 2 Analog

  c->ADCTile_Config[2].ADCBlock_Analog_Config[0].BlockAvailable   = a.C_ADC_Slice20_Enable;
  c->ADCTile_Config[2].ADCBlock_Analog_Config[0].MixMode          = a.C_ADC_Mixer_Mode20;

  c->ADCTile_Config[2].ADCBlock_Analog_Config[1].BlockAvailable   = a.C_ADC_Slice21_Enable;
  c->ADCTile_Config[2].ADCBlock_Analog_Config[1].MixMode          = a.C_ADC_Mixer_Mode21;

  c->ADCTile_Config[2].ADCBlock_Analog_Config[2].BlockAvailable   = a.C_ADC_Slice22_Enable;
  c->ADCTile_Config[2].ADCBlock_Analog_Config[2].MixMode          = a.C_ADC_Mixer_Mode22;

  c->ADCTile_Config[2].ADCBlock_Analog_Config[3].BlockAvailable   = a.C_ADC_Slice23_Enable;
  c->ADCTile_Config[2].ADCBlock_Analog_Config[3].MixMode          = a.C_ADC_Mixer_Mode23;

  // ADC Tile 2 Digital

  c->ADCTile_Config[2].ADCBlock_Digital_Config[0].MixerInputDataType  = a.C_ADC_Data_Type20;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[0].DataWidth           = a.C_ADC_Data_Width20;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[0].DecimationMode      = a.C_ADC_Decimation_Mode20;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[0].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[0].MixerType           = a.C_ADC_Mixer_Type20;

  c->ADCTile_Config[2].ADCBlock_Digital_Config[1].MixerInputDataType  = a.C_ADC_Data_Type21;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[1].DataWidth           = a.C_ADC_Data_Width21;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[1].DecimationMode      = a.C_ADC_Decimation_Mode21;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[1].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[1].MixerType           = a.C_ADC_Mixer_Type21;

  c->ADCTile_Config[2].ADCBlock_Digital_Config[2].MixerInputDataType  = a.C_ADC_Data_Type22;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[2].DataWidth           = a.C_ADC_Data_Width22;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[2].DecimationMode      = a.C_ADC_Decimation_Mode22;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[2].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[2].MixerType           = a.C_ADC_Mixer_Type22;

  c->ADCTile_Config[2].ADCBlock_Digital_Config[3].MixerInputDataType  = a.C_ADC_Data_Type23;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[3].DataWidth           = a.C_ADC_Data_Width23;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[3].DecimationMode      = a.C_ADC_Decimation_Mode23;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[3].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[2].ADCBlock_Digital_Config[3].MixerType           = a.C_ADC_Mixer_Type23;
  


  // ADC Tile 3

  c->ADCTile_Config[3].Enable           = a.C_ADC3_Enable;
  c->ADCTile_Config[3].PLLEnable        = a.C_ADC3_PLL_Enable;
  c->ADCTile_Config[3].SamplingRate     = a.C_ADC3_Sampling_Rate;
  c->ADCTile_Config[3].RefClkFreq       = a.C_ADC3_Refclk_Freq;
  c->ADCTile_Config[3].FabClkFreq       = a.C_ADC3_Fabric_Freq;
  c->ADCTile_Config[3].FeedbackDiv      = a.C_ADC3_FBDIV;
  c->ADCTile_Config[3].OutputDiv        = a.C_ADC3_OutDiv;
  c->ADCTile_Config[3].RefClkDiv        = a.C_ADC3_Refclk_Div;
  c->ADCTile_Config[3].MultibandConfig  = a.C_ADC3_Band;
  c->ADCTile_Config[3].MaxSampleRate    = a.C_ADC3_Fs_Max;
  c->ADCTile_Config[3].NumSlices        = a.C_ADC3_Slices;

  // ADC Tile 3 Analog

  c->ADCTile_Config[3].ADCBlock_Analog_Config[0].BlockAvailable   = a.C_ADC_Slice30_Enable;
  c->ADCTile_Config[3].ADCBlock_Analog_Config[0].MixMode          = a.C_ADC_Mixer_Mode30;

  c->ADCTile_Config[3].ADCBlock_Analog_Config[1].BlockAvailable   = a.C_ADC_Slice31_Enable;
  c->ADCTile_Config[3].ADCBlock_Analog_Config[1].MixMode          = a.C_ADC_Mixer_Mode31;

  c->ADCTile_Config[3].ADCBlock_Analog_Config[2].BlockAvailable   = a.C_ADC_Slice32_Enable;
  c->ADCTile_Config[3].ADCBlock_Analog_Config[2].MixMode          = a.C_ADC_Mixer_Mode32;

  c->ADCTile_Config[3].ADCBlock_Analog_Config[3].BlockAvailable   = a.C_ADC_Slice33_Enable;
  c->ADCTile_Config[3].ADCBlock_Analog_Config[3].MixMode          = a.C_ADC_Mixer_Mode33;

  // ADC Tile 3 Digital

  c->ADCTile_Config[3].ADCBlock_Digital_Config[0].MixerInputDataType  = a.C_ADC_Data_Type30;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[0].DataWidth           = a.C_ADC_Data_Width30;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[0].DecimationMode      = a.C_ADC_Decimation_Mode30;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[0].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[0].MixerType           = a.C_ADC_Mixer_Type30;

  c->ADCTile_Config[3].ADCBlock_Digital_Config[1].MixerInputDataType  = a.C_ADC_Data_Type31;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[1].DataWidth           = a.C_ADC_Data_Width31;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[1].DecimationMode      = a.C_ADC_Decimation_Mode31;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[1].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[1].MixerType           = a.C_ADC_Mixer_Type31;

  c->ADCTile_Config[3].ADCBlock_Digital_Config[2].MixerInputDataType  = a.C_ADC_Data_Type32;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[2].DataWidth           = a.C_ADC_Data_Width32;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[2].DecimationMode      = a.C_ADC_Decimation_Mode32;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[2].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[2].MixerType           = a.C_ADC_Mixer_Type32;

  c->ADCTile_Config[3].ADCBlock_Digital_Config[3].MixerInputDataType  = a.C_ADC_Data_Type33;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[3].DataWidth           = a.C_ADC_Data_Width33;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[3].DecimationMode      = a.C_ADC_Decimation_Mode33;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[3].FifoEnable          = UNKNOWN;
  c->ADCTile_Config[3].ADCBlock_Digital_Config[3].MixerType           = a.C_ADC_Mixer_Type33;
  
}

