
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef BUTTON_HH
#define BUTTON_HH

#include "window.hh"
#include "global_beep.hh"
#include "draw_text.hh"
#include "event_types.hh"
#include "send_events.hh"

class button : public window, public sending_base_class<selection_changed_event, int>
{
public:

  const static int MAX_STRING  = 200;

  bool             silent;
  
  color            BG_COLOR;
  color            FG_COLOR;
  color            TEXT_COLOR;

  int              allowed_height;
  
  int              top_margin;
  int              bottom_margin;
  int              left_margin;
  int              right_margin;

  int              font_height;

  int              circle_width;

  int              highlight_count;

  char             text[MAX_STRING];
  
  virtual void     calculate_width_and_height(int& calc_width, int& calc_height, int desired_height, float ratio);

  virtual void     select();
  virtual void     deselect();

  virtual void     layout();
  virtual void     draw_dirty();
  virtual void     draw_dynamic();

  virtual void     set_text(const char* txt);
  
  virtual bool     handle_event(my_event& me);

                   button(const char* button_name,
			  int         font_size,
			  int         x_margin,
			  int         y_margin,
			  color       textcolor,
			  color       fg,
			  color       bg=BLACK,
			  int         circle_width=-1);
                   ~button();
};



#endif
