
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef GRAPH_DATA_STATIC_HH
#define GRAPH_DATA_STATIC_HH

#include "graph_data.hh"

template <typename T> class graph_data_static : public graph_data<T>
{
public:

  // In base class
  // int       num_graphs;
  // int       num_points;  
  // double    x_data_start;
  // double    x_data_step;
  // double    y_scale;
  // T**       y_data;

  graph_data_static(graph_type source_type, int num_graphs, int num_points, double x_data_start, double x_data_step);
  virtual ~graph_data_static();
};



template <typename T> graph_data_static<T>::graph_data_static(graph_type source_type, int num_graphs, int num_points, double x_data_start, double x_data_step)
  : graph_data<T>(source_type, num_graphs, num_points, x_data_start, x_data_step, 1.0)
{
  this->y_data = new base_data<T>*[num_graphs];
  
  for(int g=0; g<num_graphs; g++)
    {
      this->y_data[g] = new base_data<T>(num_points);

      for(int i=0; i<num_points; i++)
	this->y_data[g]->data[i] = 0;
    }
}


template <typename T> graph_data_static<T>::~graph_data_static()
{
  //
  // This is now in the base class
  //
  //for(int g=0; g<this->num_graphs; g++)
  //  {
  //    delete this->y_data[g];
  //  }
  //delete [] this->y_data;
}


#endif
