
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef MENU_HH
#define MENU_HH

#include "multiwindow.hh"
#include "layout.hh"
#include "global_beep.hh"
#include "draw_text.hh"
#include "all_svg.hh"
#include "backing_panel.hh"

//
// When a menu draws, it draws all tags of its children.  It draws at most one of the
// actual children -- and only the selected one.
//
// All children of class menu need to be dervived from class menu.
//
class menu : public multiwindow
{
  void add(menu* m, int screen);  // This shouldn't be called, ever.  It doesn't exist!  Hence, private.

public:

  color GROUPCOLOR;
  color TAGCOLOR;
  color TEXTCOLOR;
  color SELECTEDCOLOR;
  color ACTIONTEXTCOLOR;
  color DISABLEDTEXTCOLOR;
  
  int selected_y_offset;

  int top_margin;
  int bottom_margin;
  int left_margin;
  int right_margin;
  int mw_margin;

  int selection_margin;
  int tag_top_margin;
  int tag_bottom_margin;
  int tag_left_margin;
  int tag_right_margin;
  int tag_left_offset;
  int tag_right_offset;

  int item_area_height;
  int item_max_spacing;

  int tag_font_height;
  int tag_spacing;
  int tag_bottom_offset;
  int max_tag_width;
  int mw_left_edge;

  
  int               selected_num;    // -1 if none selected
  bool              selectable;

  
  // This is a subpanel of the parent menu, not of this menu.  Drawn explicity from the parent.
  subpanel          tag;
  char              tagname[200];
  
  virtual int       tag_width(int font_height);
  virtual void      draw_tag(int font_height, bool selected);

  virtual void      select_a_child(int num);
  virtual void      deselect_a_child();

  virtual void      this_selected();
  virtual void      this_deselected();
  
  virtual bool      handle_event(my_event& me);

  virtual void      layout();
  virtual void      draw_dirty();
  virtual void      draw_dynamic();

  void add(menu* m);
  
  menu(const char* tagname, color bg=BLACK);
  virtual ~menu();
};



#endif
