
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef MENU_ACTION_HH
#define MENU_ACTION_HH

#include "menu.hh"

class menu_action : public menu
{
  typedef void actionfunc(menu_action* menua, bool selected, void* data);

  actionfunc*  event_handling_function;
  void*        data;

  // This type of menu is terminal; can't add children.  Thus make these private.
  void add(menu_action* m, bool autodelete=true);
    
public:

  virtual void this_selected();
  virtual void this_deselected();

  menu_action(const char* tagname, actionfunc* event_handling_function, void* data, color bg=BLACK);
  ~menu_action();
};


inline void menu_action::this_selected()
{
  event_handling_function(this, true, data);
}


inline void menu_action::this_deselected()
{
  event_handling_function(this, false, data);
}

inline menu_action::menu_action(const char* tagname, actionfunc* event_handling_function, void* data, color bg)
  : menu(tagname, bg)
{
  this->event_handling_function = event_handling_function;
  this->data = data;
  this->selectable = false;
}

inline menu_action::~menu_action()
{
}

#endif
