
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef POINT_HH
#define POINT_HH

#include <math.h>

class point
{
public:
  int x;
  int y;
  
  point()               { x = 0;  y = 0;  }
  point(int xx, int yy) { x = xx; y = yy; }
};


class pointf
{
public:
  float x;
  float y;

  pointf()                    { x = 0.0; y = 0.0; }
  pointf(float xx, float yy)  { x = xx;  y = yy;  }
  pointf(const point p)       { x = p.x; y = p.y; }
};


inline bool operator==(point p0, point p1)
{
  return (p0.x==p1.x) && (p0.y == p1.y);
}

inline point point_from_pointf(pointf p)
{
  point pp;
  pp.x = (int)floor(p.x);
  pp.y = (int)floor(p.y);
  return pp;
}


inline point operator+(point p0, point p1)
{
  point pp;
  pp.x = p0.x + p1.x;
  pp.y = p0.y + p1.y;
  return pp;
}


inline point operator-(point p0, point p1)
{
  point pp;
  pp.x = p0.x - p1.x;
  pp.y = p0.y - p1.y;
  return pp;
}

inline pointf operator+(pointf p0, pointf p1)
{
  pointf pp;
  pp.x = p0.x + p1.x;
  pp.y = p0.y + p1.y;
  return pp;
}


inline pointf operator-(pointf p0, pointf p1)
{
  pointf pp;
  pp.x = p0.x - p1.x;
  pp.y = p0.y - p1.y;
  return pp;
}

#endif
