
/*
 * Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., http://www.fsf.org/about/contact/
 *
 */


#ifndef BASICLIST_HH
#define BASICLIST_HH


class BasicListElement
{
  BasicListElement* next_element;
  BasicListElement* previous_element;
  
  friend class BasicList;

public:

  BasicListElement* next()      { return next_element; }
  BasicListElement* previous()  { return previous_element; }

  BasicListElement() { next_element = previous_element = 0; }
  virtual ~BasicListElement() { }
};

class BasicList
{
  BasicListElement* first_element;
  BasicListElement* last_element;

public:
  BasicList() { first_element = last_element = 0; }
  ~BasicList();

  void              addAtEnd(BasicListElement* e);
  void              remove(BasicListElement* e);
  void              replace_extract(BasicListElement* orig, BasicListElement* replacement);
  
  BasicListElement* first()  { return first_element; }
  BasicListElement* last()   { return last_element; }
};


#endif
