

#include <math.h>
#include <stdio.h>
#include <unistd.h>
#include "physical_memory.hh"

int main(void)
{
  //int num_periods_in_dac_buffer = 170;
  //int dac_buffer_samples        = 65536;
  int adc_buffer_samples        = 65536;
  
  //physical_memory<int16_t>  dac_buffer  (0xB1000000, dac_buffer_samples);
  //physical_memory<uint32_t> dac_trigger (0xB2000000, 1);
  //physical_memory<uint32_t> adc_trigger (0xB2004000, 1);
  physical_memory<int32_t>  adc_buffer  (0xB0000000, adc_buffer_samples/2);

  //
  // Set up DAC buffer
  //
  //for(int i=0; i<dac_buffer_samples; i++)
  //  {
  //    float   radians = i * num_periods_in_dac_buffer * 2 * M_PI / dac_buffer_samples;
  //    int16_t sample  = int(floor(32767 * sin(radians) + 0.5));
  //
  //    dac_buffer.write_offset(i, sample);
  //  }

  //
  // Tell DAC to play the buffer
  //
  //dac_trigger.write_offset(0, 1);

  //
  // Wait for good data to go out DAC
  //
  //usleep(5000);

  //
  // Trigger an ADC Capture
  //
  //adc_trigger.write_offset(0, 0);
  //adc_trigger.write_offset(0, 1);
  //adc_trigger.write_offset(0, 0);

  //
  // Wait for data to be captured
  //
  //usleep(2000);
  
  //
  // Write the data to a file for plotting with GNUPlot
  //
  FILE* fp = fopen("adc0_capture.txt", "w");
  for(int i=0; i<adc_buffer_samples; i+=2)
    {
      uint32_t word = adc_buffer.read_offset(i/2);
      int16_t s0 = word;
      int16_t s1 = word>>16;
      fprintf(fp, "%d %d\n", i, (int)s0);
      fprintf(fp, "%d %d\n", i+1, (int)s1);
    }
  fclose(fp);

  printf("\n"
	 "\n"
	 "ADC Capture Complete.\n"
	 "\n"
	 "Output is in \"adc0_capture.txt\".\n"
	 "\n");
  
  return 0;
}
