

#include <stdio.h>
#include <unistd.h>
#include "hwalloc.hh"

struct gpio
{
  uint32_t data_bits;
  uint32_t direction_bits;  // 0 is output, 1 is input
};


int main(void)
{
  volatile gpio* g = hwalloc<gpio>(0xA00C0000);
  

  g->direction_bits = 0x00000000;  // All outputs

  
  g->data_bits = 0xFFFFFFFF;
  printf("Wrote 0x%08X, read 0x%08X\n", 0xFFFFFFFF, g->data_bits);

  g->data_bits = 0x00000000;
  printf("Wrote 0x%08X, read 0x%08X\n", 0x00000000, g->data_bits);

  g->data_bits = 0xFFFFFFFF;
  printf("Wrote 0x%08X, read 0x%08X\n", 0xFFFFFFFF, g->data_bits);


  // Blink LEDs in counting pattern.
  for(int i=0;;i++)
    {
      g->data_bits = i;
      usleep(100000);
    }

  hwfree(g);
  
  return 0;
}
