
// SPDX-License-Identifier: GPL-3.0-only
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, version 3.0 of the License.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

#ifndef RUNNABLE_H
#define RUNNABLE_H

#include <pthread.h>

#include <stdio.h>

//
// To use this class:  Derive some other class from this class, containing
// any thread variables.  Inside the constructor for the derived class, call
// start() to start up the thread.  This will call the virtual run() method
// of the derived class from a newly started thread.
//
class runnable
{
private:

  pthread_t       thread_id;  

  static void*    static_run(runnable* r) { r->run(); return 0; }

public:

  virtual void    run()                     = 0;

  pthread_t       get_thread_id() const     { return thread_id; }

//
// Called externally from the thread
//
                  runnable();
  virtual        ~runnable();

  void            start();
  void            cancel()              { pthread_cancel(thread_id);  }
  void            wait_for_completion() { pthread_join(thread_id, 0); }

//
// Called from within the thread
//
  void            wait(int milliseconds);
  void            wait()                    { wait(10); }
};



#endif
