
// SPDX-License-Identifier: GPL-3.0-only
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, version 3.0 of the License.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//


#include "runnable.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <time.h>
#include <sys/errno.h>


runnable::runnable()
{
  thread_id = 0;
}

void
runnable::start()
{

  int error = pthread_create(&thread_id, 
			     NULL, 
			     (void* (*)(void *))runnable::static_run, 
			     (void*)this);

  if(error)
    {
      printf("Can't create a thread for a runnable class:  ");

      if(error==ENOMEM)
	printf("No memory.\n");
      else if(error==EINVAL)
	printf("Bad attributes.\n");
      else if(error==EPERM)
	printf("Insufficient Permissions\n");
      else
	printf("Unknown error number %d (0x%x)\n", error, error);

      exit(20);
    }
}


runnable::~runnable()
{
  if(thread_id)
    {
      pthread_cancel(thread_id);
      pthread_join(thread_id, 0);
    }
}


void runnable::wait(int milliseconds)
{
  struct timespec t;
  struct timeval now;
  pthread_mutex_t ptcm;
  pthread_cond_t  ptc;

  pthread_mutex_init(&ptcm, NULL);
  pthread_cond_init(&ptc, NULL);

  gettimeofday(&now, NULL);
  t.tv_sec = now.tv_sec + milliseconds/1000;
  t.tv_nsec = ( (milliseconds%1000) * 1000L + now.tv_usec ) * 1000;

  pthread_cond_timedwait(&ptc, &ptcm, &t);

  pthread_testcancel();
}
