

#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>
#include <dirent.h>

#include "rfdc.hh"
#include "xrfdc_clk.h"

#include "hwalloc.hh"


//
// Data sets up clocking
//
// LMK04208 set to    Fosc: 122.88 MHz\n"
//                AXI Clk: 491.52 MHz\n"
//               SYSREF's:   5.12 MHz\n"
//         Ref Clk (auto):  12.80 MHz\n"

unsigned int LMK04208_CKin[1][26] = { { 0x00160040,0x00144800,0x00144801,0x001400C2,0xC0140023,
					0x40140024,0x80141E05,0x01100006,0x01100007,0x06010008,
					0x55555549,0x9102410A,0x0401100B,0x1B0C006C,0x2302886D,
					0x0200000E,0x8000800F,0xC1550410,0x00000058,0x02C9C419,
					0x8FA8001A,0x10001E1B,0x0021201C,0x0180031D,0x0200031E,0x003F001F } };


int main(void)
{
  const int I2CBUS = 12;
  
  printf("\n"
	 "Configuring the data converter clocks...\n"
	 "\n"
	 "Setting LMK04208 to   Fosc: 122.88 MHz\n"
	 "                   AXI Clk: 491.52 MHz\n"
	 "                  SYSREF's:   5.12 MHz\n"
	 "            Ref Clk (auto):  12.80 MHz\n"
	 "\n");

  LMK04208ClockConfig(I2CBUS, LMK04208_CKin);
  
  printf("Setting LMX2594's to ADC clk 3.932160 GHZ and DAC clk to 3.932160 GHZ\n"
	 "\n");
  
  LMX2594ClockConfig(I2CBUS, 3932160);
  /* LMX2594 clock options currently available, others can be added.
         204.80	MHz	-	 204800
         245.76	MHz	-	 245760
         409.60	MHz	-	 409600
         491.52	MHz	-	 491520
         737.28	MHz	-	 737280
        1474.56	MHz	-	1474560
        1966.08	MHz	-	1966080
        2048.00	MHz	-	2048000
        2457.60	MHz	-	2457600
        2949.12	MHz	-	2949120
        3072.00	MHz	-	3072000
        3276.80	MHz	-	3276800
        3686.40	MHz	-	3686400
        3932.16	MHz	-	3932160
        4000.00	MHz	-	4000000
        4096.00	MHz	-	4096000
        4423.68	MHz	-	4423680
        4669.44	MHz	-	4669440
        4915.20	MHz	-	4915200
        5120.00	MHz	-	5120000
        5734.40	MHz	-	5734400
        5898.24	MHz	-	5898240
        6144.00	MHz	-	6144000
        6389.76	MHz	-	6389760
        6400.00	MHz	-	6400000
        6553.60	MHz	-	6553600
        7340.03	MHz	-	7340032
        */

  printf("Clock setting complete.\n");

  //
  // Set up rfdc.  This can linger if there's a need to check interrupt status registers.
  // Interrupts aren't supported by this class, but the registers can be polled.
  //
  rfdc(true /* verbose */);


  printf("\n"
	 "System successfully initialized.\n"
	 "\n");
  
  return 0;
}



