#!/bin/bash -e

usage()
{
    echo ""
    echo "Usage:  load_fpga file.bin"
    echo ""
    echo "   Loads an FPGA binfile into the FPGA."
    echo ""
    echo "   binfiles must be converted from Vivado .bit"
    echo "   output files using bootgen."
    echo ""
    echo "   This script must be run as root."
    echo ""
    exit 20
}


BINFILE="$1"

if [ ! -f "$BINFILE" ]; then
    usage
fi


if [ `id -u` != 0 ]; then
    echo ""
    echo "You're NOT ROOT!"
    echo ""
    usage
fi


BIN=PL.bin
DTS=/tmp/PL.dtsi
DTB=/tmp/PL.dtbo


cat <<EOF >"$DTS"
/dts-v1/;
/plugin/;
/ {
	fragment@0 {
		target = <&fpga_full>;
		__overlay__ {
			firmware-name = "$BIN";
			config-complete-timeout-us = <30000000>;
		};
	};
};
EOF

dtc -O dtb -o "$DTB" -b 0 -@ "$DTS"


# Set flags for Full Bitstream.
# This appears to be old.  It doesn't work
#echo 0 > /sys/class/fpga_manager/fpga0/flags

# Create the directory where firmware is supposed to reside (if it doesn't already exist)
mkdir -p /lib/firmware

cp "$BINFILE"  /lib/firmware/"$BIN"
#cp "$DTB"      /lib/firmware/

#
# Load the FPGA
#
#mkdir -p /configfs
#
#if [ ! -d /configfs/device-tree ]; then
#    mount -t configfs configfs /configfs || true
#fi

OVERLAY_DIR=/sys/kernel/config/device-tree/overlays/fpga_load

if [ -d "$OVERLAY_DIR" ]; then
    echo 0 > "$OVERLAY_DIR"/status
    rmdir "$OVERLAY_DIR"
fi

mkdir -p "$OVERLAY_DIR"

cat "$DTB"  > "$OVERLAY_DIR"/dtbo
echo 1      > "$OVERLAY_DIR"/status


STATUS=`cat "$OVERLAY_DIR"/status`

if [ "$STATUS" = 1 ]; then
    echo "***********************************************************************"
    echo "**"
    echo "**  FPGA Successfully Loaded with \"$BINFILE\"."
    echo "**"
    echo "***********************************************************************"
else
    echo "***********************************************************************"
    echo "**"
    echo "**  FPGA FAILED to Load with \"$BINFILE\"."
    echo "**"
    echo "***********************************************************************"
fi
