
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "fontlist.hh"


const start_end codes_for_font_NotoSans_Regular[] =
{
  {     13,     13 },
  {     32,    126 },
  {    160,    887 },
  {    890,    895 },
  {    900,    906 },
  {    908,    908 },
  {    910,    929 },
  {    931,    993 },
  {   1008,   1327 },
  {   6832,   6848 },
  {   7296,   7304 },
  {   7424,   7673 },
  {   7675,   7957 },
  {   7960,   7965 },
  {   7968,   8005 },
  {   8008,   8013 },
  {   8016,   8023 },
  {   8025,   8025 },
  {   8027,   8027 },
  {   8029,   8029 },
  {   8031,   8061 },
  {   8064,   8116 },
  {   8118,   8132 },
  {   8134,   8147 },
  {   8150,   8155 },
  {   8157,   8175 },
  {   8178,   8180 },
  {   8182,   8190 },
  {   8192,   8292 },
  {   8294,   8305 },
  {   8308,   8334 },
  {   8336,   8348 },
  {   8352,   8383 },
  {   8432,   8432 },
  {   8448,   8543 },
  {   8580,   8580 },
  {   8585,   8585 },
  {   9676,   9676 },
  {  11360,  11391 },
  {  11744,  11858 },
  {  42560,  42655 },
  {  42752,  42943 },
  {  42946,  42954 },
  {  42997,  43007 },
  {  43310,  43310 },
  {  43824,  43883 },
  {  64256,  64262 },
  {  65024,  65024 },
  {  65056,  65071 },
  {  65279,  65279 },
  {  65532,  65533 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansYi_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  12289,  12290 },
  {  12296,  12305 },
  {  12308,  12315 },
  {  12539,  12539 },
  {  40960,  42124 },
  {  42128,  42182 },
  {  65377,  65381 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansCJK_Regular[] =
{
  {     32,    126 },
  {    160,    259 },
  {    272,    275 },
  {    282,    283 },
  {    296,    299 },
  {    323,    324 },
  {    327,    328 },
  {    332,    335 },
  {    338,    339 },
  {    360,    365 },
  {    402,    402 },
  {    416,    417 },
  {    431,    432 },
  {    461,    476 },
  {    504,    505 },
  {    593,    593 },
  {    609,    609 },
  {    699,    699 },
  {    711,    711 },
  {    713,    715 },
  {    729,    729 },
  {    746,    747 },
  {    768,    769 },
  {    772,    772 },
  {    775,    775 },
  {    780,    780 },
  {    913,    929 },
  {    931,    937 },
  {    945,    969 },
  {   1025,   1025 },
  {   1040,   1103 },
  {   1105,   1105 },
  {   4352,   4607 },
  {   7742,   7743 },
  {   7840,   7929 },
  {   8194,   8195 },
  {   8208,   8214 },
  {   8216,   8218 },
  {   8220,   8222 },
  {   8224,   8226 },
  {   8229,   8231 },
  {   8240,   8240 },
  {   8242,   8243 },
  {   8245,   8245 },
  {   8249,   8252 },
  {   8258,   8258 },
  {   8263,   8265 },
  {   8273,   8273 },
  {   8308,   8308 },
  {   8361,   8361 },
  {   8363,   8364 },
  {   8413,   8414 },
  {   8448,   8448 },
  {   8451,   8451 },
  {   8453,   8453 },
  {   8457,   8458 },
  {   8463,   8463 },
  {   8467,   8467 },
  {   8470,   8470 },
  {   8481,   8482 },
  {   8486,   8487 },
  {   8491,   8491 },
  {   8494,   8494 },
  {   8501,   8501 },
  {   8507,   8507 },
  {   8544,   8555 },
  {   8560,   8571 },
  {   8592,   8601 },
  {   8632,   8633 },
  {   8644,   8646 },
  {   8651,   8652 },
  {   8656,   8656 },
  {   8658,   8658 },
  {   8660,   8660 },
  {   8678,   8681 },
  {   8693,   8693 },
  {   8704,   8704 },
  {   8706,   8707 },
  {   8709,   8715 },
  {   8719,   8719 },
  {   8721,   8723 },
  {   8725,   8725 },
  {   8730,   8730 },
  {   8733,   8736 },
  {   8739,   8739 },
  {   8741,   8750 },
  {   8756,   8759 },
  {   8765,   8765 },
  {   8771,   8771 },
  {   8773,   8773 },
  {   8776,   8776 },
  {   8780,   8780 },
  {   8800,   8802 },
  {   8804,   8807 },
  {   8810,   8811 },
  {   8814,   8815 },
  {   8818,   8819 },
  {   8822,   8823 },
  {   8834,   8839 },
  {   8842,   8843 },
  {   8853,   8857 },
  {   8864,   8864 },
  {   8869,   8869 },
  {   8895,   8895 },
  {   8922,   8923 },
  {   8943,   8943 },
  {   8965,   8967 },
  {   8978,   8978 },
  {   8984,   8984 },
  {   9001,   9002 },
  {   9136,   9137 },
  {   9150,   9164 },
  {   9166,   9166 },
  {   9178,   9179 },
  {   9251,   9251 },
  {   9312,   9643 },
  {   9649,   9651 },
  {   9654,   9655 },
  {   9660,   9661 },
  {   9664,   9665 },
  {   9670,   9671 },
  {   9673,   9676 },
  {   9678,   9683 },
  {   9698,   9702 },
  {   9711,   9711 },
  {   9728,   9731 },
  {   9733,   9734 },
  {   9737,   9737 },
  {   9742,   9743 },
  {   9750,   9751 },
  {   9756,   9759 },
  {   9775,   9775 },
  {   9792,   9794 },
  {   9824,   9839 },
  {   9842,   9853 },
  {   9888,   9888 },
  {   9917,   9918 },
  {   9986,   9986 },
  {  10003,  10003 },
  {  10010,  10010 },
  {  10045,  10045 },
  {  10047,  10048 },
  {  10070,  10070 },
  {  10102,  10131 },
  {  10145,  10145 },
  {  10548,  10549 },
  {  10687,  10687 },
  {  10746,  10747 },
  {  11013,  11015 },
  {  11034,  11034 },
  {  11157,  11157 },
  {  11834,  11835 },
  {  11904,  11929 },
  {  11931,  12019 },
  {  12032,  12245 },
  {  12272,  12283 },
  {  12288,  12351 },
  {  12353,  12438 },
  {  12441,  12543 },
  {  12549,  12591 },
  {  12593,  12686 },
  {  12688,  12731 },
  {  12736,  12771 },
  {  12784,  12830 },
  {  12832,  13099 },
  {  13101,  19893 },
  {  19968,  40943 },
  {  43360,  43388 },
  {  44032,  55203 },
  {  55216,  55238 },
  {  55243,  55291 },
  {  63744,  64109 },
  {  64256,  64260 },
  {  65040,  65049 },
  {  65072,  65106 },
  {  65108,  65126 },
  {  65128,  65131 },
  {  65281,  65470 },
  {  65474,  65479 },
  {  65482,  65487 },
  {  65490,  65495 },
  {  65498,  65500 },
  {  65504,  65510 },
  {  65512,  65518 },
  { 127232, 127244 },
  { 127248, 127340 },
  { 127344, 127404 },
  { 127488, 127490 },
  { 127504, 127547 },
  { 127552, 127560 },
  { 127568, 127569 },
  { 131083, 131083 },
  { 131105, 131105 },
  { 131108, 131108 },
  { 131134, 131134 },
  { 131142, 131142 },
  { 131150, 131150 },
  { 131176, 131176 },
  { 131206, 131207 },
  { 131209, 131210 },
  { 131220, 131220 },
  { 131234, 131234 },
  { 131236, 131236 },
  { 131248, 131248 },
  { 131274, 131277 },
  { 131281, 131281 },
  { 131287, 131287 },
  { 131310, 131310 },
  { 131317, 131317 },
  { 131340, 131340 },
  { 131342, 131342 },
  { 131352, 131352 },
  { 131372, 131372 },
  { 131416, 131416 },
  { 131428, 131428 },
  { 131490, 131490 },
  { 131492, 131492 },
  { 131497, 131497 },
  { 131499, 131499 },
  { 131521, 131521 },
  { 131540, 131540 },
  { 131570, 131570 },
  { 131588, 131588 },
  { 131596, 131596 },
  { 131603, 131604 },
  { 131641, 131641 },
  { 131675, 131675 },
  { 131700, 131701 },
  { 131726, 131726 },
  { 131737, 131737 },
  { 131742, 131742 },
  { 131744, 131744 },
  { 131767, 131767 },
  { 131775, 131776 },
  { 131813, 131813 },
  { 131850, 131850 },
  { 131877, 131877 },
  { 131883, 131883 },
  { 131905, 131905 },
  { 131909, 131911 },
  { 131953, 131953 },
  { 131966, 131969 },
  { 132000, 132000 },
  { 132007, 132007 },
  { 132021, 132021 },
  { 132041, 132041 },
  { 132043, 132043 },
  { 132085, 132085 },
  { 132089, 132089 },
  { 132092, 132092 },
  { 132115, 132116 },
  { 132127, 132127 },
  { 132141, 132141 },
  { 132170, 132170 },
  { 132197, 132197 },
  { 132231, 132231 },
  { 132238, 132238 },
  { 132241, 132242 },
  { 132259, 132259 },
  { 132311, 132311 },
  { 132348, 132348 },
  { 132350, 132350 },
  { 132361, 132361 },
  { 132415, 132415 },
  { 132423, 132423 },
  { 132494, 132494 },
  { 132517, 132517 },
  { 132529, 132529 },
  { 132531, 132531 },
  { 132547, 132547 },
  { 132554, 132554 },
  { 132560, 132560 },
  { 132565, 132566 },
  { 132575, 132576 },
  { 132587, 132587 },
  { 132625, 132625 },
  { 132629, 132629 },
  { 132633, 132634 },
  { 132648, 132648 },
  { 132656, 132656 },
  { 132694, 132694 },
  { 132726, 132726 },
  { 132844, 132844 },
  { 132878, 132878 },
  { 132913, 132913 },
  { 132943, 132943 },
  { 132985, 132985 },
  { 133064, 133064 },
  { 133127, 133127 },
  { 133164, 133164 },
  { 133178, 133178 },
  { 133235, 133235 },
  { 133305, 133305 },
  { 133333, 133333 },
  { 133390, 133390 },
  { 133398, 133398 },
  { 133411, 133411 },
  { 133460, 133460 },
  { 133497, 133497 },
  { 133500, 133500 },
  { 133508, 133508 },
  { 133533, 133533 },
  { 133607, 133607 },
  { 133649, 133649 },
  { 133712, 133712 },
  { 133732, 133732 },
  { 133743, 133743 },
  { 133770, 133770 },
  { 133812, 133812 },
  { 133826, 133826 },
  { 133837, 133837 },
  { 133843, 133843 },
  { 133901, 133901 },
  { 133917, 133917 },
  { 134031, 134031 },
  { 134047, 134047 },
  { 134056, 134057 },
  { 134071, 134071 },
  { 134079, 134079 },
  { 134086, 134086 },
  { 134091, 134091 },
  { 134114, 134114 },
  { 134123, 134123 },
  { 134139, 134139 },
  { 134143, 134143 },
  { 134155, 134155 },
  { 134157, 134157 },
  { 134176, 134176 },
  { 134196, 134196 },
  { 134202, 134203 },
  { 134209, 134211 },
  { 134227, 134227 },
  { 134245, 134245 },
  { 134263, 134264 },
  { 134268, 134268 },
  { 134285, 134285 },
  { 134294, 134294 },
  { 134300, 134300 },
  { 134325, 134325 },
  { 134328, 134328 },
  { 134351, 134352 },
  { 134355, 134358 },
  { 134365, 134365 },
  { 134381, 134381 },
  { 134399, 134399 },
  { 134421, 134421 },
  { 134440, 134440 },
  { 134449, 134450 },
  { 134469, 134473 },
  { 134476, 134478 },
  { 134488, 134488 },
  { 134511, 134511 },
  { 134513, 134513 },
  { 134516, 134516 },
  { 134524, 134524 },
  { 134526, 134527 },
  { 134550, 134550 },
  { 134556, 134556 },
  { 134567, 134567 },
  { 134578, 134578 },
  { 134600, 134600 },
  { 134625, 134625 },
  { 134660, 134660 },
  { 134665, 134666 },
  { 134669, 134673 },
  { 134678, 134678 },
  { 134685, 134685 },
  { 134732, 134732 },
  { 134756, 134756 },
  { 134765, 134765 },
  { 134771, 134771 },
  { 134773, 134779 },
  { 134796, 134796 },
  { 134805, 134806 },
  { 134808, 134808 },
  { 134813, 134813 },
  { 134818, 134818 },
  { 134826, 134828 },
  { 134838, 134838 },
  { 134871, 134872 },
  { 134877, 134877 },
  { 134904, 134907 },
  { 134941, 134941 },
  { 134950, 134950 },
  { 134957, 134958 },
  { 134960, 134961 },
  { 134971, 134971 },
  { 134988, 134988 },
  { 135007, 135007 },
  { 135012, 135012 },
  { 135053, 135053 },
  { 135056, 135056 },
  { 135085, 135085 },
  { 135092, 135094 },
  { 135100, 135100 },
  { 135135, 135135 },
  { 135146, 135149 },
  { 135188, 135188 },
  { 135197, 135198 },
  { 135247, 135247 },
  { 135260, 135260 },
  { 135279, 135279 },
  { 135285, 135288 },
  { 135291, 135291 },
  { 135304, 135304 },
  { 135318, 135318 },
  { 135325, 135325 },
  { 135348, 135348 },
  { 135359, 135361 },
  { 135367, 135369 },
  { 135375, 135375 },
  { 135379, 135379 },
  { 135396, 135396 },
  { 135412, 135414 },
  { 135471, 135471 },
  { 135483, 135483 },
  { 135485, 135485 },
  { 135493, 135493 },
  { 135496, 135496 },
  { 135503, 135503 },
  { 135509, 135509 },
  { 135552, 135552 },
  { 135559, 135559 },
  { 135641, 135641 },
  { 135681, 135681 },
  { 135740, 135741 },
  { 135759, 135759 },
  { 135765, 135765 },
  { 135796, 135796 },
  { 135803, 135804 },
  { 135821, 135821 },
  { 135848, 135849 },
  { 135856, 135856 },
  { 135895, 135895 },
  { 135907, 135908 },
  { 135933, 135934 },
  { 135938, 135941 },
  { 135963, 135963 },
  { 135990, 135990 },
  { 135994, 135994 },
  { 136004, 136004 },
  { 136053, 136054 },
  { 136078, 136078 },
  { 136088, 136088 },
  { 136090, 136090 },
  { 136092, 136092 },
  { 136132, 136134 },
  { 136173, 136173 },
  { 136190, 136190 },
  { 136211, 136211 },
  { 136214, 136214 },
  { 136228, 136228 },
  { 136255, 136255 },
  { 136274, 136274 },
  { 136276, 136277 },
  { 136301, 136302 },
  { 136330, 136330 },
  { 136343, 136343 },
  { 136374, 136374 },
  { 136424, 136424 },
  { 136445, 136445 },
  { 136567, 136567 },
  { 136578, 136578 },
  { 136596, 136596 },
  { 136598, 136598 },
  { 136663, 136663 },
  { 136714, 136714 },
  { 136723, 136723 },
  { 136729, 136729 },
  { 136766, 136766 },
  { 136775, 136775 },
  { 136801, 136801 },
  { 136850, 136850 },
  { 136884, 136884 },
  { 136888, 136888 },
  { 136890, 136890 },
  { 136896, 136898 },
  { 136915, 136915 },
  { 136917, 136917 },
  { 136927, 136927 },
  { 136934, 136936 },
  { 136954, 136956 },
  { 136958, 136958 },
  { 136966, 136966 },
  { 136973, 136973 },
  { 136976, 136976 },
  { 136998, 136999 },
  { 137018, 137020 },
  { 137026, 137026 },
  { 137047, 137047 },
  { 137068, 137073 },
  { 137075, 137076 },
  { 137131, 137131 },
  { 137136, 137141 },
  { 137155, 137155 },
  { 137159, 137159 },
  { 137177, 137180 },
  { 137183, 137183 },
  { 137199, 137199 },
  { 137205, 137206 },
  { 137208, 137212 },
  { 137248, 137248 },
  { 137256, 137258 },
  { 137261, 137261 },
  { 137273, 137275 },
  { 137280, 137280 },
  { 137285, 137285 },
  { 137298, 137298 },
  { 137310, 137310 },
  { 137313, 137316 },
  { 137335, 137335 },
  { 137339, 137339 },
  { 137347, 137349 },
  { 137374, 137378 },
  { 137405, 137407 },
  { 137425, 137425 },
  { 137430, 137433 },
  { 137466, 137466 },
  { 137475, 137477 },
  { 137488, 137490 },
  { 137493, 137493 },
  { 137500, 137500 },
  { 137506, 137506 },
  { 137511, 137511 },
  { 137531, 137531 },
  { 137540, 137540 },
  { 137560, 137560 },
  { 137578, 137578 },
  { 137596, 137596 },
  { 137600, 137600 },
  { 137603, 137603 },
  { 137608, 137608 },
  { 137622, 137622 },
  { 137667, 137667 },
  { 137691, 137691 },
  { 137715, 137715 },
  { 137754, 137754 },
  { 137773, 137773 },
  { 137780, 137780 },
  { 137797, 137797 },
  { 137803, 137803 },
  { 137827, 137827 },
  { 138052, 138052 },
  { 138177, 138178 },
  { 138282, 138282 },
  { 138326, 138326 },
  { 138352, 138352 },
  { 138402, 138402 },
  { 138405, 138405 },
  { 138412, 138412 },
  { 138541, 138541 },
  { 138565, 138566 },
  { 138579, 138579 },
  { 138590, 138590 },
  { 138594, 138594 },
  { 138616, 138616 },
  { 138640, 138640 },
  { 138642, 138642 },
  { 138652, 138652 },
  { 138657, 138657 },
  { 138678, 138679 },
  { 138682, 138682 },
  { 138698, 138698 },
  { 138705, 138705 },
  { 138720, 138720 },
  { 138731, 138731 },
  { 138745, 138745 },
  { 138780, 138780 },
  { 138787, 138787 },
  { 138803, 138804 },
  { 138807, 138807 },
  { 138813, 138813 },
  { 138889, 138889 },
  { 138916, 138916 },
  { 138920, 138920 },
  { 138952, 138952 },
  { 138965, 138965 },
  { 139023, 139023 },
  { 139029, 139029 },
  { 139038, 139038 },
  { 139100, 139100 },
  { 139114, 139114 },
  { 139126, 139126 },
  { 139166, 139166 },
  { 139169, 139169 },
  { 139240, 139240 },
  { 139258, 139258 },
  { 139333, 139333 },
  { 139337, 139337 },
  { 139390, 139390 },
  { 139418, 139418 },
  { 139463, 139463 },
  { 139516, 139516 },
  { 139562, 139562 },
  { 139611, 139611 },
  { 139635, 139635 },
  { 139642, 139643 },
  { 139681, 139681 },
  { 139713, 139713 },
  { 139715, 139715 },
  { 139784, 139784 },
  { 139800, 139800 },
  { 139900, 139900 },
  { 140062, 140062 },
  { 140065, 140065 },
  { 140069, 140069 },
  { 140205, 140205 },
  { 140221, 140221 },
  { 140240, 140240 },
  { 140247, 140247 },
  { 140282, 140282 },
  { 140389, 140389 },
  { 140401, 140401 },
  { 140427, 140427 },
  { 140433, 140433 },
  { 140464, 140464 },
  { 140476, 140476 },
  { 140481, 140481 },
  { 140489, 140489 },
  { 140492, 140492 },
  { 140513, 140513 },
  { 140525, 140525 },
  { 140563, 140563 },
  { 140571, 140571 },
  { 140592, 140592 },
  { 140628, 140628 },
  { 140685, 140685 },
  { 140719, 140719 },
  { 140734, 140734 },
  { 140809, 140809 },
  { 140827, 140828 },
  { 140843, 140843 },
  { 140904, 140904 },
  { 140922, 140922 },
  { 140950, 140950 },
  { 140952, 140952 },
  { 141043, 141046 },
  { 141074, 141074 },
  { 141076, 141076 },
  { 141083, 141083 },
  { 141087, 141087 },
  { 141098, 141098 },
  { 141173, 141173 },
  { 141185, 141185 },
  { 141206, 141206 },
  { 141236, 141237 },
  { 141261, 141261 },
  { 141315, 141315 },
  { 141403, 141403 },
  { 141407, 141408 },
  { 141425, 141425 },
  { 141483, 141483 },
  { 141485, 141485 },
  { 141505, 141505 },
  { 141559, 141559 },
  { 141606, 141606 },
  { 141625, 141625 },
  { 141647, 141647 },
  { 141671, 141671 },
  { 141675, 141675 },
  { 141696, 141696 },
  { 141711, 141711 },
  { 141715, 141715 },
  { 141926, 141926 },
  { 142008, 142008 },
  { 142031, 142031 },
  { 142037, 142037 },
  { 142054, 142054 },
  { 142056, 142056 },
  { 142094, 142094 },
  { 142114, 142114 },
  { 142143, 142143 },
  { 142147, 142147 },
  { 142150, 142150 },
  { 142159, 142160 },
  { 142186, 142186 },
  { 142246, 142246 },
  { 142282, 142282 },
  { 142286, 142286 },
  { 142365, 142365 },
  { 142372, 142372 },
  { 142374, 142375 },
  { 142392, 142392 },
  { 142412, 142412 },
  { 142417, 142417 },
  { 142421, 142421 },
  { 142434, 142434 },
  { 142447, 142447 },
  { 142472, 142472 },
  { 142491, 142491 },
  { 142497, 142497 },
  { 142505, 142505 },
  { 142514, 142514 },
  { 142519, 142519 },
  { 142530, 142530 },
  { 142534, 142534 },
  { 142537, 142537 },
  { 142599, 142600 },
  { 142610, 142610 },
  { 142660, 142660 },
  { 142668, 142668 },
  { 142695, 142695 },
  { 142733, 142733 },
  { 142741, 142741 },
  { 142752, 142752 },
  { 142755, 142756 },
  { 142775, 142775 },
  { 142817, 142817 },
  { 142830, 142830 },
  { 142861, 142861 },
  { 142902, 142902 },
  { 142914, 142914 },
  { 142968, 142968 },
  { 142987, 142987 },
  { 143027, 143027 },
  { 143072, 143072 },
  { 143087, 143087 },
  { 143220, 143220 },
  { 143308, 143308 },
  { 143331, 143331 },
  { 143339, 143339 },
  { 143411, 143411 },
  { 143428, 143428 },
  { 143435, 143435 },
  { 143462, 143462 },
  { 143485, 143486 },
  { 143502, 143502 },
  { 143543, 143543 },
  { 143548, 143548 },
  { 143578, 143578 },
  { 143613, 143613 },
  { 143619, 143619 },
  { 143677, 143677 },
  { 143741, 143741 },
  { 143746, 143746 },
  { 143780, 143781 },
  { 143795, 143795 },
  { 143798, 143798 },
  { 143811, 143812 },
  { 143816, 143817 },
  { 143850, 143850 },
  { 143861, 143861 },
  { 143863, 143865 },
  { 143887, 143887 },
  { 143909, 143909 },
  { 143919, 143919 },
  { 143921, 143924 },
  { 143958, 143958 },
  { 143966, 143966 },
  { 143970, 143970 },
  { 144001, 144001 },
  { 144009, 144010 },
  { 144043, 144045 },
  { 144082, 144082 },
  { 144096, 144097 },
  { 144128, 144128 },
  { 144138, 144138 },
  { 144159, 144159 },
  { 144195, 144195 },
  { 144242, 144242 },
  { 144308, 144308 },
  { 144332, 144332 },
  { 144336, 144336 },
  { 144338, 144339 },
  { 144341, 144341 },
  { 144346, 144346 },
  { 144350, 144351 },
  { 144356, 144356 },
  { 144358, 144358 },
  { 144372, 144373 },
  { 144377, 144378 },
  { 144382, 144382 },
  { 144384, 144384 },
  { 144447, 144447 },
  { 144458, 144459 },
  { 144464, 144465 },
  { 144485, 144485 },
  { 144495, 144495 },
  { 144498, 144498 },
  { 144612, 144613 },
  { 144665, 144665 },
  { 144688, 144688 },
  { 144721, 144721 },
  { 144730, 144730 },
  { 144743, 144743 },
  { 144772, 144772 },
  { 144788, 144789 },
  { 144793, 144793 },
  { 144796, 144796 },
  { 144827, 144827 },
  { 144836, 144836 },
  { 144843, 144843 },
  { 144845, 144847 },
  { 144883, 144883 },
  { 144896, 144896 },
  { 144919, 144919 },
  { 144922, 144922 },
  { 144952, 144956 },
  { 144960, 144960 },
  { 144967, 144967 },
  { 144985, 144985 },
  { 144991, 144991 },
  { 145015, 145015 },
  { 145038, 145038 },
  { 145054, 145054 },
  { 145062, 145062 },
  { 145069, 145069 },
  { 145082, 145082 },
  { 145119, 145119 },
  { 145134, 145134 },
  { 145155, 145155 },
  { 145164, 145164 },
  { 145174, 145174 },
  { 145180, 145180 },
  { 145184, 145184 },
  { 145197, 145197 },
  { 145199, 145199 },
  { 145215, 145215 },
  { 145251, 145252 },
  { 145254, 145254 },
  { 145281, 145281 },
  { 145314, 145314 },
  { 145340, 145340 },
  { 145346, 145346 },
  { 145365, 145367 },
  { 145383, 145383 },
  { 145393, 145393 },
  { 145407, 145407 },
  { 145444, 145444 },
  { 145466, 145466 },
  { 145469, 145469 },
  { 145858, 145858 },
  { 146072, 146072 },
  { 146087, 146087 },
  { 146137, 146137 },
  { 146139, 146139 },
  { 146158, 146158 },
  { 146170, 146170 },
  { 146202, 146202 },
  { 146266, 146266 },
  { 146531, 146531 },
  { 146559, 146559 },
  { 146583, 146587 },
  { 146613, 146613 },
  { 146615, 146615 },
  { 146622, 146622 },
  { 146631, 146633 },
  { 146684, 146688 },
  { 146702, 146702 },
  { 146712, 146712 },
  { 146752, 146752 },
  { 146779, 146779 },
  { 146814, 146814 },
  { 146831, 146831 },
  { 146870, 146877 },
  { 146899, 146899 },
  { 146915, 146915 },
  { 146936, 146938 },
  { 146950, 146950 },
  { 146961, 146961 },
  { 146979, 146979 },
  { 146988, 146993 },
  { 147001, 147001 },
  { 147080, 147083 },
  { 147129, 147129 },
  { 147135, 147135 },
  { 147159, 147159 },
  { 147191, 147196 },
  { 147253, 147253 },
  { 147265, 147265 },
  { 147274, 147274 },
  { 147297, 147297 },
  { 147326, 147330 },
  { 147343, 147343 },
  { 147380, 147380 },
  { 147383, 147383 },
  { 147392, 147392 },
  { 147397, 147397 },
  { 147435, 147440 },
  { 147473, 147473 },
  { 147513, 147517 },
  { 147531, 147531 },
  { 147543, 147543 },
  { 147589, 147589 },
  { 147595, 147597 },
  { 147601, 147601 },
  { 147606, 147606 },
  { 147657, 147657 },
  { 147681, 147681 },
  { 147692, 147692 },
  { 147715, 147716 },
  { 147727, 147727 },
  { 147737, 147737 },
  { 147775, 147776 },
  { 147780, 147780 },
  { 147790, 147790 },
  { 147797, 147799 },
  { 147804, 147804 },
  { 147807, 147807 },
  { 147809, 147809 },
  { 147831, 147831 },
  { 147834, 147834 },
  { 147875, 147877 },
  { 147884, 147884 },
  { 147893, 147893 },
  { 147910, 147910 },
  { 147917, 147917 },
  { 147938, 147938 },
  { 147964, 147964 },
  { 147966, 147966 },
  { 147982, 147982 },
  { 147995, 147995 },
  { 148043, 148043 },
  { 148054, 148054 },
  { 148057, 148057 },
  { 148086, 148088 },
  { 148100, 148100 },
  { 148115, 148115 },
  { 148117, 148117 },
  { 148133, 148133 },
  { 148159, 148159 },
  { 148161, 148161 },
  { 148169, 148170 },
  { 148206, 148206 },
  { 148209, 148209 },
  { 148218, 148218 },
  { 148237, 148237 },
  { 148250, 148250 },
  { 148276, 148276 },
  { 148296, 148296 },
  { 148322, 148325 },
  { 148364, 148364 },
  { 148374, 148374 },
  { 148380, 148381 },
  { 148412, 148413 },
  { 148417, 148417 },
  { 148432, 148432 },
  { 148457, 148458 },
  { 148466, 148466 },
  { 148472, 148472 },
  { 148484, 148484 },
  { 148533, 148534 },
  { 148570, 148571 },
  { 148595, 148595 },
  { 148615, 148616 },
  { 148665, 148665 },
  { 148668, 148668 },
  { 148686, 148686 },
  { 148691, 148691 },
  { 148694, 148694 },
  { 148741, 148741 },
  { 148769, 148769 },
  { 148856, 148856 },
  { 148936, 148936 },
  { 149016, 149016 },
  { 149033, 149034 },
  { 149093, 149093 },
  { 149108, 149108 },
  { 149143, 149143 },
  { 149157, 149157 },
  { 149204, 149204 },
  { 149254, 149254 },
  { 149285, 149285 },
  { 149295, 149295 },
  { 149391, 149391 },
  { 149472, 149472 },
  { 149489, 149489 },
  { 149522, 149522 },
  { 149539, 149539 },
  { 149634, 149634 },
  { 149654, 149654 },
  { 149737, 149737 },
  { 149744, 149747 },
  { 149755, 149755 },
  { 149759, 149761 },
  { 149772, 149772 },
  { 149782, 149783 },
  { 149785, 149785 },
  { 149807, 149807 },
  { 149811, 149812 },
  { 149822, 149827 },
  { 149858, 149859 },
  { 149876, 149878 },
  { 149883, 149883 },
  { 149887, 149887 },
  { 149890, 149890 },
  { 149896, 149903 },
  { 149908, 149908 },
  { 149924, 149924 },
  { 149927, 149927 },
  { 149929, 149929 },
  { 149931, 149933 },
  { 149943, 149947 },
  { 149957, 149957 },
  { 149968, 149968 },
  { 149978, 149979 },
  { 149982, 149983 },
  { 149987, 149987 },
  { 149989, 149989 },
  { 149996, 149997 },
  { 150006, 150009 },
  { 150011, 150011 },
  { 150017, 150017 },
  { 150030, 150030 },
  { 150034, 150035 },
  { 150037, 150037 },
  { 150049, 150058 },
  { 150078, 150078 },
  { 150082, 150082 },
  { 150085, 150085 },
  { 150090, 150090 },
  { 150093, 150097 },
  { 150109, 150109 },
  { 150117, 150119 },
  { 150129, 150129 },
  { 150135, 150138 },
  { 150141, 150141 },
  { 150156, 150156 },
  { 150163, 150166 },
  { 150180, 150183 },
  { 150193, 150195 },
  { 150202, 150204 },
  { 150208, 150208 },
  { 150215, 150215 },
  { 150217, 150218 },
  { 150225, 150225 },
  { 150239, 150239 },
  { 150242, 150242 },
  { 150249, 150249 },
  { 150287, 150287 },
  { 150358, 150358 },
  { 150382, 150383 },
  { 150517, 150517 },
  { 150537, 150537 },
  { 150550, 150550 },
  { 150686, 150687 },
  { 150729, 150729 },
  { 150745, 150745 },
  { 150790, 150790 },
  { 150803, 150804 },
  { 150968, 150968 },
  { 151018, 151019 },
  { 151044, 151044 },
  { 151054, 151054 },
  { 151095, 151095 },
  { 151099, 151099 },
  { 151120, 151120 },
  { 151146, 151146 },
  { 151179, 151179 },
  { 151205, 151205 },
  { 151207, 151207 },
  { 151310, 151310 },
  { 151388, 151388 },
  { 151426, 151426 },
  { 151430, 151430 },
  { 151447, 151447 },
  { 151450, 151450 },
  { 151465, 151465 },
  { 151480, 151480 },
  { 151490, 151490 },
  { 151538, 151538 },
  { 151596, 151596 },
  { 151626, 151626 },
  { 151634, 151634 },
  { 151637, 151637 },
  { 151709, 151709 },
  { 151842, 151842 },
  { 151851, 151851 },
  { 151880, 151880 },
  { 151933, 151934 },
  { 151977, 151977 },
  { 152013, 152013 },
  { 152035, 152035 },
  { 152037, 152039 },
  { 152094, 152094 },
  { 152096, 152097 },
  { 152140, 152140 },
  { 152144, 152144 },
  { 152217, 152217 },
  { 152263, 152263 },
  { 152280, 152280 },
  { 152334, 152334 },
  { 152337, 152337 },
  { 152339, 152339 },
  { 152382, 152382 },
  { 152501, 152501 },
  { 152574, 152574 },
  { 152601, 152601 },
  { 152613, 152613 },
  { 152622, 152624 },
  { 152646, 152646 },
  { 152684, 152684 },
  { 152686, 152686 },
  { 152718, 152718 },
  { 152730, 152730 },
  { 152793, 152793 },
  { 152846, 152846 },
  { 152881, 152882 },
  { 152885, 152885 },
  { 152895, 152895 },
  { 152923, 152926 },
  { 152930, 152930 },
  { 152933, 152934 },
  { 152961, 152961 },
  { 152964, 152964 },
  { 152975, 152975 },
  { 152999, 153000 },
  { 153017, 153017 },
  { 153045, 153045 },
  { 153051, 153051 },
  { 153056, 153056 },
  { 153093, 153093 },
  { 153141, 153141 },
  { 153169, 153169 },
  { 153215, 153215 },
  { 153219, 153219 },
  { 153237, 153237 },
  { 153315, 153315 },
  { 153334, 153334 },
  { 153350, 153350 },
  { 153373, 153373 },
  { 153381, 153381 },
  { 153405, 153405 },
  { 153457, 153458 },
  { 153513, 153513 },
  { 153524, 153524 },
  { 153543, 153543 },
  { 153567, 153569 },
  { 153650, 153650 },
  { 153658, 153658 },
  { 153687, 153687 },
  { 153693, 153693 },
  { 153714, 153714 },
  { 153716, 153716 },
  { 153800, 153800 },
  { 153822, 153822 },
  { 153825, 153825 },
  { 153859, 153859 },
  { 153926, 153926 },
  { 153942, 153942 },
  { 153976, 153976 },
  { 154028, 154028 },
  { 154052, 154052 },
  { 154060, 154060 },
  { 154068, 154068 },
  { 154196, 154196 },
  { 154261, 154261 },
  { 154268, 154268 },
  { 154286, 154287 },
  { 154327, 154327 },
  { 154339, 154340 },
  { 154345, 154345 },
  { 154353, 154353 },
  { 154484, 154484 },
  { 154505, 154505 },
  { 154519, 154519 },
  { 154546, 154548 },
  { 154566, 154566 },
  { 154596, 154596 },
  { 154600, 154600 },
  { 154625, 154625 },
  { 154630, 154630 },
  { 154657, 154657 },
  { 154698, 154699 },
  { 154724, 154725 },
  { 154769, 154769 },
  { 154788, 154788 },
  { 154816, 154817 },
  { 154878, 154878 },
  { 154912, 154912 },
  { 154928, 154928 },
  { 154947, 154947 },
  { 155033, 155033 },
  { 155041, 155041 },
  { 155065, 155065 },
  { 155150, 155150 },
  { 155182, 155182 },
  { 155204, 155204 },
  { 155209, 155209 },
  { 155222, 155222 },
  { 155234, 155234 },
  { 155237, 155237 },
  { 155265, 155267 },
  { 155302, 155302 },
  { 155324, 155324 },
  { 155330, 155330 },
  { 155351, 155352 },
  { 155368, 155368 },
  { 155418, 155418 },
  { 155427, 155427 },
  { 155467, 155467 },
  { 155484, 155484 },
  { 155604, 155604 },
  { 155616, 155618 },
  { 155643, 155643 },
  { 155660, 155660 },
  { 155671, 155671 },
  { 155681, 155681 },
  { 155689, 155689 },
  { 155720, 155720 },
  { 155735, 155735 },
  { 155744, 155744 },
  { 155748, 155748 },
  { 155779, 155779 },
  { 155799, 155799 },
  { 155812, 155813 },
  { 155885, 155885 },
  { 155906, 155906 },
  { 155937, 155937 },
  { 155993, 155996 },
  { 156077, 156078 },
  { 156082, 156082 },
  { 156125, 156125 },
  { 156193, 156194 },
  { 156248, 156248 },
  { 156257, 156257 },
  { 156266, 156267 },
  { 156272, 156272 },
  { 156294, 156294 },
  { 156368, 156368 },
  { 156469, 156469 },
  { 156491, 156492 },
  { 156497, 156497 },
  { 156606, 156606 },
  { 156661, 156661 },
  { 156664, 156664 },
  { 156674, 156674 },
  { 156688, 156690 },
  { 156746, 156746 },
  { 156777, 156777 },
  { 156804, 156804 },
  { 156808, 156809 },
  { 156813, 156813 },
  { 156824, 156824 },
  { 156946, 156946 },
  { 157042, 157042 },
  { 157088, 157088 },
  { 157092, 157092 },
  { 157101, 157101 },
  { 157119, 157119 },
  { 157202, 157202 },
  { 157222, 157222 },
  { 157302, 157302 },
  { 157310, 157310 },
  { 157359, 157361 },
  { 157365, 157365 },
  { 157402, 157402 },
  { 157416, 157416 },
  { 157436, 157436 },
  { 157462, 157462 },
  { 157469, 157469 },
  { 157505, 157505 },
  { 157564, 157564 },
  { 157593, 157593 },
  { 157619, 157620 },
  { 157644, 157644 },
  { 157656, 157656 },
  { 157724, 157724 },
  { 157766, 157766 },
  { 157790, 157790 },
  { 157806, 157806 },
  { 157832, 157832 },
  { 157834, 157834 },
  { 157843, 157843 },
  { 157895, 157895 },
  { 157917, 157917 },
  { 157930, 157930 },
  { 157966, 157966 },
  { 157969, 157969 },
  { 157990, 157990 },
  { 158009, 158009 },
  { 158033, 158033 },
  { 158063, 158063 },
  { 158105, 158105 },
  { 158120, 158120 },
  { 158133, 158133 },
  { 158173, 158173 },
  { 158194, 158194 },
  { 158202, 158202 },
  { 158238, 158238 },
  { 158253, 158254 },
  { 158260, 158260 },
  { 158274, 158274 },
  { 158289, 158290 },
  { 158296, 158296 },
  { 158348, 158348 },
  { 158391, 158391 },
  { 158463, 158463 },
  { 158469, 158469 },
  { 158474, 158474 },
  { 158483, 158483 },
  { 158485, 158485 },
  { 158499, 158499 },
  { 158504, 158504 },
  { 158544, 158547 },
  { 158555, 158556 },
  { 158581, 158581 },
  { 158594, 158594 },
  { 158614, 158615 },
  { 158621, 158621 },
  { 158643, 158643 },
  { 158656, 158656 },
  { 158711, 158711 },
  { 158753, 158753 },
  { 158761, 158761 },
  { 158784, 158785 },
  { 158790, 158790 },
  { 158835, 158835 },
  { 158846, 158850 },
  { 158878, 158878 },
  { 158884, 158884 },
  { 158903, 158904 },
  { 158909, 158909 },
  { 158912, 158912 },
  { 158915, 158915 },
  { 158929, 158929 },
  { 158941, 158941 },
  { 159010, 159018 },
  { 159057, 159057 },
  { 159092, 159092 },
  { 159136, 159143 },
  { 159150, 159150 },
  { 159196, 159196 },
  { 159210, 159211 },
  { 159216, 159216 },
  { 159232, 159232 },
  { 159237, 159237 },
  { 159239, 159239 },
  { 159250, 159250 },
  { 159296, 159296 },
  { 159298, 159301 },
  { 159333, 159333 },
  { 159342, 159342 },
  { 159346, 159346 },
  { 159351, 159351 },
  { 159364, 159364 },
  { 159368, 159368 },
  { 159371, 159371 },
  { 159385, 159385 },
  { 159440, 159447 },
  { 159526, 159526 },
  { 159603, 159604 },
  { 159636, 159636 },
  { 159647, 159647 },
  { 159649, 159649 },
  { 159678, 159678 },
  { 159710, 159711 },
  { 159734, 159736 },
  { 159758, 159758 },
  { 159819, 159819 },
  { 159826, 159827 },
  { 159880, 159880 },
  { 159917, 159919 },
  { 159949, 159949 },
  { 159954, 159954 },
  { 159984, 159984 },
  { 159988, 159988 },
  { 159992, 159992 },
  { 160009, 160009 },
  { 160012, 160013 },
  { 160038, 160039 },
  { 160057, 160057 },
  { 160068, 160068 },
  { 160100, 160101 },
  { 160117, 160117 },
  { 160205, 160205 },
  { 160283, 160283 },
  { 160359, 160359 },
  { 160384, 160384 },
  { 160389, 160389 },
  { 160395, 160395 },
  { 160434, 160434 },
  { 160438, 160438 },
  { 160486, 160486 },
  { 160594, 160594 },
  { 160666, 160666 },
  { 160730, 160731 },
  { 160766, 160767 },
  { 160784, 160784 },
  { 160802, 160802 },
  { 160841, 160841 },
  { 160848, 160848 },
  { 160900, 160900 },
  { 160902, 160902 },
  { 160957, 160957 },
  { 161140, 161140 },
  { 161187, 161187 },
  { 161248, 161248 },
  { 161252, 161252 },
  { 161277, 161279 },
  { 161287, 161287 },
  { 161292, 161292 },
  { 161300, 161301 },
  { 161317, 161317 },
  { 161329, 161330 },
  { 161337, 161337 },
  { 161365, 161367 },
  { 161412, 161412 },
  { 161427, 161428 },
  { 161550, 161551 },
  { 161571, 161571 },
  { 161589, 161590 },
  { 161601, 161601 },
  { 161618, 161618 },
  { 161630, 161630 },
  { 161668, 161669 },
  { 161740, 161740 },
  { 161880, 161880 },
  { 161904, 161904 },
  { 161949, 161949 },
  { 161970, 161970 },
  { 161992, 161992 },
  { 162084, 162084 },
  { 162151, 162151 },
  { 162170, 162170 },
  { 162181, 162181 },
  { 162208, 162208 },
  { 162228, 162228 },
  { 162269, 162269 },
  { 162301, 162301 },
  { 162314, 162314 },
  { 162318, 162318 },
  { 162366, 162366 },
  { 162385, 162385 },
  { 162387, 162387 },
  { 162393, 162393 },
  { 162425, 162425 },
  { 162436, 162436 },
  { 162493, 162494 },
  { 162548, 162548 },
  { 162562, 162562 },
  { 162566, 162566 },
  { 162571, 162571 },
  { 162584, 162584 },
  { 162616, 162618 },
  { 162632, 162632 },
  { 162661, 162661 },
  { 162739, 162739 },
  { 162750, 162750 },
  { 162759, 162759 },
  { 162799, 162799 },
  { 162804, 162804 },
  { 162834, 162834 },
  { 162876, 162876 },
  { 162924, 162924 },
  { 162993, 162993 },
  { 163000, 163000 },
  { 163013, 163013 },
  { 163055, 163055 },
  { 163119, 163119 },
  { 163155, 163156 },
  { 163174, 163174 },
  { 163187, 163187 },
  { 163204, 163204 },
  { 163215, 163215 },
  { 163224, 163224 },
  { 163232, 163232 },
  { 163261, 163261 },
  { 163292, 163292 },
  { 163344, 163344 },
  { 163405, 163405 },
  { 163407, 163407 },
  { 163453, 163453 },
  { 163503, 163503 },
  { 163611, 163611 },
  { 163630, 163630 },
  { 163767, 163767 },
  { 163833, 163833 },
  { 163842, 163842 },
  { 163849, 163849 },
  { 163870, 163870 },
  { 163875, 163876 },
  { 163912, 163912 },
  { 163971, 163971 },
  { 163978, 163978 },
  { 163984, 163984 },
  { 164027, 164027 },
  { 164029, 164030 },
  { 164072, 164073 },
  { 164084, 164084 },
  { 164142, 164142 },
  { 164175, 164175 },
  { 164189, 164189 },
  { 164207, 164207 },
  { 164233, 164233 },
  { 164271, 164271 },
  { 164284, 164284 },
  { 164359, 164359 },
  { 164376, 164376 },
  { 164378, 164378 },
  { 164438, 164438 },
  { 164471, 164471 },
  { 164476, 164476 },
  { 164482, 164482 },
  { 164507, 164507 },
  { 164557, 164557 },
  { 164578, 164578 },
  { 164595, 164595 },
  { 164614, 164614 },
  { 164632, 164632 },
  { 164655, 164655 },
  { 164666, 164666 },
  { 164709, 164709 },
  { 164717, 164717 },
  { 164733, 164733 },
  { 164746, 164746 },
  { 164813, 164813 },
  { 164854, 164854 },
  { 164872, 164872 },
  { 164876, 164876 },
  { 164882, 164882 },
  { 164949, 164949 },
  { 164968, 164968 },
  { 164972, 164972 },
  { 164979, 164979 },
  { 164994, 164994 },
  { 165084, 165084 },
  { 165121, 165121 },
  { 165180, 165181 },
  { 165227, 165228 },
  { 165320, 165321 },
  { 165352, 165352 },
  { 165364, 165364 },
  { 165376, 165376 },
  { 165387, 165387 },
  { 165413, 165413 },
  { 165435, 165435 },
  { 165496, 165496 },
  { 165525, 165525 },
  { 165546, 165547 },
  { 165554, 165554 },
  { 165564, 165564 },
  { 165591, 165592 },
  { 165606, 165606 },
  { 165626, 165626 },
  { 165647, 165647 },
  { 165651, 165651 },
  { 165856, 165856 },
  { 165892, 165892 },
  { 165931, 165931 },
  { 166157, 166157 },
  { 166195, 166195 },
  { 166214, 166214 },
  { 166216, 166217 },
  { 166230, 166230 },
  { 166244, 166244 },
  { 166248, 166248 },
  { 166251, 166253 },
  { 166270, 166270 },
  { 166279, 166281 },
  { 166312, 166312 },
  { 166314, 166315 },
  { 166328, 166328 },
  { 166330, 166332 },
  { 166336, 166336 },
  { 166364, 166364 },
  { 166366, 166366 },
  { 166369, 166369 },
  { 166371, 166372 },
  { 166375, 166376 },
  { 166393, 166396 },
  { 166415, 166415 },
  { 166422, 166422 },
  { 166430, 166430 },
  { 166437, 166437 },
  { 166441, 166441 },
  { 166450, 166450 },
  { 166454, 166454 },
  { 166467, 166475 },
  { 166489, 166490 },
  { 166513, 166513 },
  { 166529, 166531 },
  { 166553, 166556 },
  { 166592, 166592 },
  { 166598, 166598 },
  { 166603, 166606 },
  { 166621, 166629 },
  { 166634, 166634 },
  { 166652, 166652 },
  { 166668, 166668 },
  { 166675, 166675 },
  { 166689, 166690 },
  { 166699, 166701 },
  { 166703, 166703 },
  { 166726, 166726 },
  { 166729, 166729 },
  { 166732, 166732 },
  { 166734, 166734 },
  { 166736, 166736 },
  { 166755, 166758 },
  { 166764, 166764 },
  { 166799, 166799 },
  { 166809, 166809 },
  { 166812, 166813 },
  { 166841, 166841 },
  { 166849, 166850 },
  { 166853, 166853 },
  { 166868, 166868 },
  { 166871, 166871 },
  { 166873, 166874 },
  { 166887, 166892 },
  { 166895, 166895 },
  { 166901, 166901 },
  { 166911, 166911 },
  { 166915, 166915 },
  { 166921, 166921 },
  { 166940, 166941 },
  { 166947, 166947 },
  { 166950, 166950 },
  { 166955, 166955 },
  { 166960, 166960 },
  { 166969, 166969 },
  { 166971, 166971 },
  { 166983, 166983 },
  { 166991, 166991 },
  { 166993, 166993 },
  { 166996, 166996 },
  { 167114, 167114 },
  { 167117, 167117 },
  { 167122, 167122 },
  { 167133, 167133 },
  { 167184, 167184 },
  { 167220, 167220 },
  { 167281, 167281 },
  { 167306, 167306 },
  { 167321, 167321 },
  { 167329, 167329 },
  { 167353, 167353 },
  { 167419, 167419 },
  { 167439, 167439 },
  { 167447, 167447 },
  { 167455, 167455 },
  { 167478, 167478 },
  { 167481, 167481 },
  { 167525, 167526 },
  { 167561, 167561 },
  { 167575, 167575 },
  { 167577, 167577 },
  { 167596, 167596 },
  { 167602, 167603 },
  { 167641, 167641 },
  { 167655, 167655 },
  { 167659, 167659 },
  { 167670, 167670 },
  { 167730, 167730 },
  { 167877, 167877 },
  { 167928, 167928 },
  { 168057, 168057 },
  { 168072, 168072 },
  { 168075, 168075 },
  { 168083, 168083 },
  { 168111, 168113 },
  { 168128, 168128 },
  { 168164, 168165 },
  { 168172, 168173 },
  { 168205, 168205 },
  { 168208, 168208 },
  { 168252, 168252 },
  { 168269, 168269 },
  { 168283, 168283 },
  { 168286, 168286 },
  { 168304, 168304 },
  { 168348, 168348 },
  { 168360, 168360 },
  { 168405, 168405 },
  { 168419, 168419 },
  { 168427, 168427 },
  { 168608, 168608 },
  { 168625, 168625 },
  { 168989, 168989 },
  { 168992, 168992 },
  { 169011, 169011 },
  { 169023, 169023 },
  { 169032, 169032 },
  { 169104, 169104 },
  { 169168, 169168 },
  { 169177, 169178 },
  { 169182, 169182 },
  { 169189, 169189 },
  { 169191, 169191 },
  { 169225, 169225 },
  { 169374, 169374 },
  { 169392, 169392 },
  { 169400, 169400 },
  { 169423, 169423 },
  { 169431, 169431 },
  { 169449, 169449 },
  { 169460, 169460 },
  { 169599, 169599 },
  { 169712, 169712 },
  { 169753, 169753 },
  { 169760, 169760 },
  { 169778, 169778 },
  { 169808, 169808 },
  { 169940, 169940 },
  { 170000, 170000 },
  { 170043, 170043 },
  { 170071, 170071 },
  { 170148, 170148 },
  { 170182, 170182 },
  { 170193, 170193 },
  { 170218, 170218 },
  { 170225, 170225 },
  { 170234, 170234 },
  { 170243, 170243 },
  { 170245, 170245 },
  { 170287, 170287 },
  { 170309, 170309 },
  { 170311, 170313 },
  { 170333, 170333 },
  { 170346, 170346 },
  { 170397, 170397 },
  { 170435, 170435 },
  { 170441, 170441 },
  { 170536, 170536 },
  { 170573, 170573 },
  { 170610, 170610 },
  { 170757, 170757 },
  { 170766, 170766 },
  { 170965, 170965 },
  { 171123, 171123 },
  { 171181, 171181 },
  { 171326, 171326 },
  { 171339, 171339 },
  { 171354, 171354 },
  { 171388, 171388 },
  { 171416, 171416 },
  { 171419, 171419 },
  { 171483, 171483 },
  { 171510, 171510 },
  { 171526, 171526 },
  { 171541, 171541 },
  { 171565, 171565 },
  { 171581, 171581 },
  { 171593, 171593 },
  { 171624, 171624 },
  { 171658, 171658 },
  { 171692, 171692 },
  { 171696, 171696 },
  { 171715, 171716 },
  { 171739, 171739 },
  { 171753, 171753 },
  { 171768, 171768 },
  { 171811, 171811 },
  { 171824, 171824 },
  { 171902, 171902 },
  { 171907, 171907 },
  { 171916, 171916 },
  { 171959, 171959 },
  { 171982, 171982 },
  { 171991, 171991 },
  { 171998, 171998 },
  { 172052, 172052 },
  { 172058, 172058 },
  { 172079, 172079 },
  { 172162, 172162 },
  { 172167, 172167 },
  { 172217, 172217 },
  { 172257, 172257 },
  { 172269, 172269 },
  { 172275, 172275 },
  { 172280, 172281 },
  { 172286, 172286 },
  { 172295, 172295 },
  { 172323, 172323 },
  { 172339, 172340 },
  { 172368, 172368 },
  { 172432, 172432 },
  { 172434, 172435 },
  { 172459, 172459 },
  { 172468, 172469 },
  { 172511, 172511 },
  { 172533, 172533 },
  { 172576, 172576 },
  { 172595, 172595 },
  { 172691, 172691 },
  { 172703, 172703 },
  { 172717, 172717 },
  { 172722, 172722 },
  { 172724, 172724 },
  { 172726, 172726 },
  { 172730, 172730 },
  { 172733, 172733 },
  { 172767, 172767 },
  { 172799, 172799 },
  { 172881, 172881 },
  { 172940, 172940 },
  { 172969, 172969 },
  { 173037, 173037 },
  { 173108, 173108 },
  { 173111, 173111 },
  { 173147, 173147 },
  { 173264, 173264 },
  { 173279, 173279 },
  { 173510, 173510 },
  { 173515, 173515 },
  { 173553, 173553 },
  { 173569, 173570 },
  { 173594, 173594 },
  { 173618, 173618 },
  { 173642, 173642 },
  { 173659, 173659 },
  { 173668, 173668 },
  { 173737, 173737 },
  { 173746, 173746 },
  { 174045, 174045 },
  { 174331, 174331 },
  { 174359, 174359 },
  { 174566, 174566 },
  { 174640, 174640 },
  { 174646, 174646 },
  { 174680, 174680 },
  { 175615, 175615 },
  { 176034, 176034 },
  { 176423, 176424 },
  { 176439, 176440 },
  { 176621, 176621 },
  { 176896, 176896 },
  { 176995, 176995 },
  { 177007, 177007 },
  { 177010, 177010 },
  { 177021, 177021 },
  { 177156, 177156 },
  { 177168, 177168 },
  { 177171, 177171 },
  { 177249, 177249 },
  { 177383, 177383 },
  { 177391, 177391 },
  { 177398, 177398 },
  { 177401, 177401 },
  { 177421, 177422 },
  { 177462, 177462 },
  { 177582, 177583 },
  { 177587, 177587 },
  { 177639, 177639 },
  { 177652, 177652 },
  { 177692, 177693 },
  { 177702, 177704 },
  { 177706, 177706 },
  { 177708, 177708 },
  { 177801, 177801 },
  { 177813, 177814 },
  { 177837, 177837 },
  { 177901, 177901 },
  { 177990, 177990 },
  { 178001, 178001 },
  { 178003, 178003 },
  { 178010, 178010 },
  { 178012, 178012 },
  { 178021, 178021 },
  { 178038, 178039 },
  { 178044, 178044 },
  { 178050, 178050 },
  { 178057, 178057 },
  { 178059, 178059 },
  { 178062, 178062 },
  { 178068, 178068 },
  { 178089, 178089 },
  { 178092, 178092 },
  { 178095, 178095 },
  { 178109, 178109 },
  { 178117, 178117 },
  { 178121, 178121 },
  { 178127, 178127 },
  { 178130, 178130 },
  { 178136, 178136 },
  { 178150, 178150 },
  { 178160, 178160 },
  { 178167, 178167 },
  { 178169, 178169 },
  { 178172, 178172 },
  { 178182, 178182 },
  { 178186, 178186 },
  { 178189, 178189 },
  { 178199, 178199 },
  { 178202, 178202 },
  { 178204, 178204 },
  { 178360, 178360 },
  { 178887, 178887 },
  { 179039, 179039 },
  { 179042, 179042 },
  { 179068, 179068 },
  { 179075, 179075 },
  { 179227, 179227 },
  { 179575, 179575 },
  { 179591, 179591 },
  { 179703, 179703 },
  { 179753, 179753 },
  { 180265, 180266 },
  { 180353, 180353 },
  { 180393, 180393 },
  { 180426, 180426 },
  { 180501, 180501 },
  { 180693, 180693 },
  { 180697, 180697 },
  { 180729, 180729 },
  { 180860, 180860 },
  { 180872, 180872 },
  { 180900, 180900 },
  { 181015, 181015 },
  { 181083, 181083 },
  { 181089, 181089 },
  { 181092, 181092 },
  { 181126, 181126 },
  { 181384, 181384 },
  { 181396, 181396 },
  { 181399, 181399 },
  { 181570, 181570 },
  { 181779, 181779 },
  { 181784, 181784 },
  { 181793, 181793 },
  { 181801, 181801 },
  { 181803, 181805 },
  { 181807, 181807 },
  { 181826, 181826 },
  { 181834, 181835 },
  { 182060, 182060 },
  { 182063, 182063 },
  { 182175, 182175 },
  { 182209, 182209 },
  { 182227, 182227 },
  { 182269, 182269 },
  { 182489, 182489 },
  { 182494, 182494 },
  { 182497, 182497 },
  { 182515, 182515 },
  { 182535, 182535 },
  { 182538, 182538 },
  { 182557, 182557 },
  { 182786, 182786 },
  { 182798, 182798 },
  { 182909, 182909 },
  { 182953, 182953 },
  { 183081, 183081 },
  { 183085, 183086 },
  { 183089, 183089 },
  { 183096, 183097 },
  { 183099, 183099 },
  { 183103, 183103 },
  { 183105, 183105 },
  { 183114, 183114 },
  { 183118, 183118 },
  { 183130, 183131 },
  { 183140, 183140 },
  { 183145, 183145 },
  { 183148, 183148 },
  { 183151, 183151 },
  { 183155, 183155 },
  { 183158, 183158 },
  { 183160, 183160 },
  { 183164, 183164 },
  { 183217, 183217 },
  { 183231, 183232 },
  { 183246, 183246 },
  { 183382, 183382 },
  { 183391, 183391 },
  { 183541, 183542 },
  { 183549, 183549 },
  { 183551, 183551 },
  { 183554, 183555 },
  { 183562, 183562 },
  { 183691, 183691 },
  { 183693, 183693 },
  { 183695, 183696 },
  { 183711, 183712 },
  { 183720, 183720 },
  { 183725, 183726 },
  { 183765, 183765 },
  { 183832, 183832 },
  { 183834, 183834 },
  { 183843, 183843 },
  { 183846, 183846 },
  { 183850, 183850 },
  { 183932, 183932 },
  { 183944, 183944 },
  { 183955, 183955 },
  { 185668, 185668 },
  { 188436, 188436 },
  { 189048, 189048 },
  { 189801, 189801 },
  { 190186, 190186 },
  { 194564, 194564 },
  { 194575, 194575 },
  { 194581, 194581 },
  { 194584, 194584 },
  { 194586, 194586 },
  { 194594, 194594 },
  { 194597, 194597 },
  { 194600, 194600 },
  { 194604, 194604 },
  { 194611, 194611 },
  { 194619, 194619 },
  { 194623, 194624 },
  { 194630, 194630 },
  { 194642, 194642 },
  { 194658, 194658 },
  { 194669, 194669 },
  { 194675, 194675 },
  { 194679, 194680 },
  { 194692, 194692 },
  { 194708, 194708 },
  { 194713, 194714 },
  { 194726, 194726 },
  { 194732, 194732 },
  { 194738, 194738 },
  { 194742, 194742 },
  { 194765, 194765 },
  { 194771, 194771 },
  { 194779, 194780 },
  { 194785, 194785 },
  { 194789, 194789 },
  { 194794, 194794 },
  { 194797, 194797 },
  { 194812, 194812 },
  { 194819, 194819 },
  { 194827, 194827 },
  { 194831, 194831 },
  { 194842, 194842 },
  { 194848, 194849 },
  { 194885, 194885 },
  { 194887, 194887 },
  { 194924, 194924 },
  { 194964, 194965 },
  { 194994, 194994 },
  { 195004, 195004 },
  { 195024, 195024 },
  { 195028, 195028 },
  { 195038, 195039 },
  { 195060, 195060 },
  { 198441, 198441 },
  { 200413, 200414 },
  { 200812, 200812 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansLao_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   3713,   3714 },
  {   3716,   3716 },
  {   3719,   3720 },
  {   3722,   3722 },
  {   3725,   3725 },
  {   3732,   3735 },
  {   3737,   3743 },
  {   3745,   3747 },
  {   3749,   3749 },
  {   3751,   3751 },
  {   3754,   3755 },
  {   3757,   3769 },
  {   3771,   3773 },
  {   3776,   3780 },
  {   3782,   3782 },
  {   3784,   3789 },
  {   3792,   3801 },
  {   3804,   3807 },
  {   8203,   8205 },
  {   8365,   8365 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMro_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  92736,  92766 },
  {  92768,  92777 },
  {  92782,  92783 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansNKo_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   1548,   1548 },
  {   1563,   1563 },
  {   1567,   1567 },
  {   1642,   1642 },
  {   1984,   2042 },
  {   2045,   2047 },
  {   8204,   8207 },
  {   9676,   9676 },
  {  11804,  11805 },
  {  64830,  64831 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansVai_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  42240,  42539 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansCham_Regular[] =
{
  {     13,     13 },
  {     32,     34 },
  {     39,     41 },
  {     44,     47 },
  {     58,     59 },
  {     63,     63 },
  {    160,    160 },
  {    173,    173 },
  {   8204,   8205 },
  {   8208,   8208 },
  {   9676,   9676 },
  {  43520,  43574 },
  {  43584,  43597 },
  {  43600,  43609 },
  {  43612,  43615 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansLisu_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     45,     45 },
  {    160,    160 },
  {    700,    700 },
  {    717,    717 },
  {   8208,   8208 },
  {  12298,  12299 },
  {  42192,  42239 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMath_Regular[] =
{
  {     13,     13 },
  {     32,    126 },
  {    160,    160 },
  {    167,    167 },
  {    172,    172 },
  {    177,    177 },
  {    215,    215 },
  {    247,    247 },
  {    770,    771 },
  {    773,    773 },
  {    775,    776 },
  {    816,    816 },
  {    913,    929 },
  {    931,    937 },
  {    945,    969 },
  {    977,    977 },
  {    981,    982 },
  {   1008,   1009 },
  {   1012,   1013 },
  {   8242,   8247 },
  {   8279,   8279 },
  {   8400,   8412 },
  {   8417,   8417 },
  {   8421,   8431 },
  {   8450,   8450 },
  {   8458,   8462 },
  {   8464,   8466 },
  {   8469,   8469 },
  {   8473,   8477 },
  {   8484,   8484 },
  {   8488,   8488 },
  {   8492,   8493 },
  {   8495,   8497 },
  {   8499,   8504 },
  {   8508,   8512 },
  {   8517,   8521 },
  {   8592,   8622 },
  {   8624,   8677 },
  {   8689,   8690 },
  {   8692,   8959 },
  {   8968,   8971 },
  {   8976,   8976 },
  {   8985,   8985 },
  {   8988,   8993 },
  {   9014,   9082 },
  {   9084,   9084 },
  {   9109,   9109 },
  {   9115,   9142 },
  {   9168,   9168 },
  {   9180,   9185 },
  {   9332,   9333 },
  {   9647,   9647 },
  {   9651,   9651 },
  {   9655,   9655 },
  {   9661,   9661 },
  {   9665,   9665 },
  {   9674,   9674 },
  {   9676,   9676 },
  {   9723,   9723 },
  {   9837,   9839 },
  {  10176,  10239 },
  {  10496,  11007 },
  {  11022,  11025 },
  {  11056,  11084 },
  {  11262,  11262 },
  {  65371,  65371 },
  {  65373,  65373 },
  { 119808, 119892 },
  { 119894, 119964 },
  { 119966, 119967 },
  { 119970, 119970 },
  { 119973, 119974 },
  { 119977, 119980 },
  { 119982, 119993 },
  { 119995, 119995 },
  { 119997, 120003 },
  { 120005, 120069 },
  { 120071, 120074 },
  { 120077, 120084 },
  { 120086, 120092 },
  { 120094, 120121 },
  { 120123, 120126 },
  { 120128, 120132 },
  { 120134, 120134 },
  { 120138, 120144 },
  { 120146, 120485 },
  { 120488, 120779 },
  { 120782, 120831 },
  { 126464, 126467 },
  { 126469, 126495 },
  { 126497, 126498 },
  { 126500, 126500 },
  { 126503, 126503 },
  { 126505, 126514 },
  { 126516, 126519 },
  { 126521, 126521 },
  { 126523, 126523 },
  { 126530, 126530 },
  { 126535, 126535 },
  { 126537, 126537 },
  { 126539, 126539 },
  { 126541, 126543 },
  { 126545, 126546 },
  { 126548, 126548 },
  { 126551, 126551 },
  { 126553, 126553 },
  { 126555, 126555 },
  { 126557, 126557 },
  { 126559, 126559 },
  { 126561, 126562 },
  { 126564, 126564 },
  { 126567, 126570 },
  { 126572, 126578 },
  { 126580, 126583 },
  { 126585, 126588 },
  { 126590, 126590 },
  { 126592, 126601 },
  { 126603, 126619 },
  { 126625, 126627 },
  { 126629, 126633 },
  { 126635, 126651 },
  { 126704, 126705 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMiao_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   9676,   9676 },
  {  93952,  94026 },
  {  94031,  94087 },
  {  94095,  94111 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansModi_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  43056,  43065 },
  {  71168,  71236 },
  {  71248,  71257 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMono_Regular[] =
{
  {     13,     13 },
  {     32,    126 },
  {    160,    887 },
  {    890,    895 },
  {    900,    906 },
  {    908,    908 },
  {    910,    929 },
  {    931,    993 },
  {   1008,   1327 },
  {   6832,   6848 },
  {   7296,   7304 },
  {   7424,   7673 },
  {   7675,   7957 },
  {   7960,   7965 },
  {   7968,   8005 },
  {   8008,   8013 },
  {   8016,   8023 },
  {   8025,   8025 },
  {   8027,   8027 },
  {   8029,   8029 },
  {   8031,   8061 },
  {   8064,   8116 },
  {   8118,   8132 },
  {   8134,   8147 },
  {   8150,   8155 },
  {   8157,   8175 },
  {   8178,   8180 },
  {   8182,   8190 },
  {   8192,   8292 },
  {   8294,   8305 },
  {   8308,   8334 },
  {   8336,   8348 },
  {   8352,   8383 },
  {   8432,   8432 },
  {   8448,   8543 },
  {   8580,   8580 },
  {   8585,   8585 },
  {   8592,   8597 },
  {   8604,   8606 },
  {   8608,   8608 },
  {   8610,   8612 },
  {   8614,   8614 },
  {   8656,   8660 },
  {   8666,   8667 },
  {   8678,   8678 },
  {   8680,   8680 },
  {   8704,   8718 },
  {   8720,   8720 },
  {   8722,   8722 },
  {   8728,   8730 },
  {   8734,   8734 },
  {   8736,   8736 },
  {   8739,   8739 },
  {   8743,   8746 },
  {   8756,   8760 },
  {   8764,   8765 },
  {   8769,   8769 },
  {   8771,   8771 },
  {   8773,   8773 },
  {   8775,   8780 },
  {   8788,   8789 },
  {   8791,   8791 },
  {   8799,   8802 },
  {   8804,   8805 },
  {   8812,   8812 },
  {   8814,   8821 },
  {   8826,   8827 },
  {   8834,   8841 },
  {   8846,   8846 },
  {   8849,   8860 },
  {   8866,   8869 },
  {   8884,   8885 },
  {   8888,   8888 },
  {   8898,   8900 },
  {   8902,   8902 },
  {   8904,   8906 },
  {   8909,   8910 },
  {   8912,   8913 },
  {   8930,   8931 },
  {   8968,   8971 },
  {   8976,   8976 },
  {   8985,   8985 },
  {   8992,   8993 },
  {   9014,   9082 },
  {   9109,   9109 },
  {   9115,   9134 },
  {   9136,   9149 },
  {   9180,   9185 },
  {   9332,   9333 },
  {   9472,   9727 },
  {   9837,   9839 },
  {  10038,  10038 },
  {  10072,  10074 },
  {  10197,  10199 },
  {  10204,  10204 },
  {  10214,  10219 },
  {  10229,  10230 },
  {  10631,  10632 },
  {  10659,  10659 },
  {  10680,  10680 },
  {  10752,  10752 },
  {  10757,  10758 },
  {  11360,  11391 },
  {  11744,  11858 },
  {  42560,  42655 },
  {  42752,  42943 },
  {  42946,  42954 },
  {  42997,  43007 },
  {  43310,  43310 },
  {  43824,  43883 },
  {  65024,  65024 },
  {  65056,  65071 },
  {  65279,  65279 },
  {  65371,  65371 },
  {  65373,  65373 },
  {  65532,  65533 },
  { 128636, 128639 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansNewa_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    183,    183 },
  {   7675,   7675 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  70656,  70747 },
  {  70749,  70753 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansThai_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     45,     45 },
  {    160,    160 },
  {    700,    700 },
  {    727,    727 },
  {    771,    771 },
  {    817,    817 },
  {   3585,   3642 },
  {   3647,   3675 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansAdlam_Regular[] =
{
  {     13,     13 },
  {     32,     47 },
  {     58,     64 },
  {     91,     95 },
  {    123,    125 },
  {    160,    160 },
  {    171,    171 },
  {    187,    187 },
  {   1567,   1567 },
  {   1600,   1600 },
  {   8211,   8213 },
  {   8216,   8222 },
  {   8224,   8226 },
  {   8230,   8230 },
  {   8240,   8240 },
  {   8249,   8250 },
  {   8260,   8260 },
  {   8271,   8271 },
  {   9676,   9676 },
  {  11816,  11817 },
  {  11841,  11841 },
  { 125184, 125259 },
  { 125264, 125273 },
  { 125278, 125279 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansBamum_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  42656,  42743 },
  {  92160,  92728 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansBatak_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   7104,   7155 },
  {   7164,   7167 },
  {   8203,   8205 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansBuhid_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   5941,   5942 },
  {   5952,   5971 },
  {   8203,   8205 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansKhmer_Regular[] =
{
  {     13,     13 },
  {     32,     34 },
  {     39,     41 },
  {     44,     47 },
  {     58,     59 },
  {     63,     63 },
  {    160,    160 },
  {    171,    171 },
  {    173,    173 },
  {    187,    187 },
  {   6016,   6109 },
  {   6112,   6121 },
  {   6128,   6137 },
  {   6624,   6655 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansLaoUI_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   3713,   3714 },
  {   3716,   3716 },
  {   3719,   3720 },
  {   3722,   3722 },
  {   3725,   3725 },
  {   3732,   3735 },
  {   3737,   3743 },
  {   3745,   3747 },
  {   3749,   3749 },
  {   3751,   3751 },
  {   3754,   3755 },
  {   3757,   3769 },
  {   3771,   3773 },
  {   3776,   3780 },
  {   3782,   3782 },
  {   3784,   3789 },
  {   3792,   3801 },
  {   3804,   3807 },
  {   8203,   8205 },
  {   8365,   8365 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansLimbu_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   2405,   2405 },
  {   6400,   6430 },
  {   6432,   6443 },
  {   6448,   6459 },
  {   6464,   6464 },
  {   6468,   6479 },
  {   8203,   8205 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansNushu_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  94177,  94177 },
  { 110960, 111355 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOgham_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   5760,   5788 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOriya_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     44 },
  {     46,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {   2404,   2405 },
  {   2817,   2819 },
  {   2821,   2828 },
  {   2831,   2832 },
  {   2835,   2856 },
  {   2858,   2864 },
  {   2866,   2867 },
  {   2869,   2873 },
  {   2876,   2884 },
  {   2887,   2888 },
  {   2891,   2893 },
  {   2902,   2903 },
  {   2908,   2909 },
  {   2911,   2915 },
  {   2918,   2935 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOsage_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    769,    769 },
  {    772,    772 },
  {    779,    779 },
  {    856,    856 },
  {   9676,   9676 },
  {  66736,  66771 },
  {  66776,  66811 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansRunic_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   5792,   5880 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTaiLe_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    768,    769 },
  {    775,    776 },
  {    780,    780 },
  {   4160,   4169 },
  {   6480,   6509 },
  {   6512,   6516 },
  {   8203,   8205 },
  {   9676,   9676 },
  {  12289,  12290 },
  {  12296,  12299 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTakri_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   2404,   2405 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  43056,  43065 },
  {  71296,  71352 },
  {  71360,  71369 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTamil_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    178,    179 },
  {    215,    215 },
  {    247,    247 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   2946,   2947 },
  {   2949,   2954 },
  {   2958,   2960 },
  {   2962,   2965 },
  {   2969,   2970 },
  {   2972,   2972 },
  {   2974,   2975 },
  {   2979,   2980 },
  {   2984,   2986 },
  {   2990,   3001 },
  {   3006,   3010 },
  {   3014,   3016 },
  {   3018,   3021 },
  {   3024,   3024 },
  {   3031,   3031 },
  {   3046,   3066 },
  {   7386,   7386 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8308,   8308 },
  {   8322,   8324 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  43251,  43251 },
  {  70401,  70401 },
  {  70403,  70403 },
  {  70459,  70460 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansArabic_Regular[] =
{
  {     13,     13 },
  {     32,     33 },
  {     44,     46 },
  {     48,     58 },
  {    160,    160 },
  {    171,    171 },
  {    187,    187 },
  {    847,    847 },
  {   1536,   1564 },
  {   1566,   1791 },
  {   1872,   1919 },
  {   2208,   2228 },
  {   2230,   2238 },
  {   2259,   2303 },
  {   8203,   8209 },
  {   8271,   8271 },
  {   9676,   9676 },
  {  11841,  11841 },
  {  64336,  64449 },
  {  64467,  64831 },
  {  64848,  64911 },
  {  64914,  64967 },
  {  65008,  65021 },
  {  65136,  65140 },
  {  65142,  65276 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansBrahmi_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8203,   8205 },
  {   9676,   9676 },
  {  69632,  69709 },
  {  69714,  69743 },
  {  69759,  69759 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansCarian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  66208,  66256 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansChakma_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   2534,   2543 },
  {   4160,   4169 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  69888,  69940 },
  {  69942,  69958 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansCoptic_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     45,     45 },
  {    160,    160 },
  {    768,    770 },
  {    772,    773 },
  {    775,    776 },
  {    803,    803 },
  {    831,    831 },
  {    865,    865 },
  {    884,    885 },
  {    994,   1007 },
  {   7629,   7629 },
  {   8208,   8208 },
  {   9676,   9676 },
  {  11392,  11507 },
  {  11513,  11519 },
  {  65060,  65062 },
  {  66272,  66299 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansGothic_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    772,    773 },
  {    776,    776 },
  {    817,    817 },
  {  66352,  66378 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansHatran_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8204,   8204 },
  {  67808,  67826 },
  {  67828,  67829 },
  {  67835,  67839 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansHebrew_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     45,     45 },
  {    160,    160 },
  {   1425,   1479 },
  {   1488,   1514 },
  {   1520,   1524 },
  {   8204,   8208 },
  {   8362,   8362 },
  {   9676,   9676 },
  {  64285,  64310 },
  {  64312,  64316 },
  {  64318,  64318 },
  {  64320,  64321 },
  {  64323,  64324 },
  {  64326,  64335 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansKaithi_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     45,     45 },
  {    160,    160 },
  {   2406,   2415 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   9676,   9676 },
  {  43056,  43065 },
  {  69760,  69825 },
  {  69837,  69837 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansKhojki_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   2790,   2799 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  43056,  43065 },
  {  70144,  70161 },
  {  70163,  70206 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansLepcha_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   7168,   7223 },
  {   7227,   7241 },
  {   7245,   7247 },
  {   8203,   8205 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansLycian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  66176,  66204 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansLydian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  67872,  67897 },
  {  67903,  67903 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansRejang_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8203,   8205 },
  {   9676,   9676 },
  {  43312,  43347 },
  {  43359,  43359 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSyriac_Regular[] =
{
  {     13,     13 },
  {     32,     33 },
  {     40,     43 },
  {     45,     47 },
  {     58,     58 },
  {     61,     61 },
  {     91,     93 },
  {    160,    160 },
  {    171,    171 },
  {    176,    176 },
  {    187,    187 },
  {    771,    772 },
  {    775,    776 },
  {    778,    778 },
  {    800,    800 },
  {    803,    805 },
  {    813,    814 },
  {    816,    817 },
  {   1548,   1548 },
  {   1563,   1563 },
  {   1567,   1567 },
  {   1569,   1569 },
  {   1600,   1600 },
  {   1611,   1621 },
  {   1632,   1644 },
  {   1648,   1648 },
  {   1792,   1805 },
  {   1807,   1866 },
  {   1869,   1871 },
  {   8204,   8207 },
  {   8230,   8230 },
  {   8260,   8260 },
  {   8722,   8722 },
  {   9676,   9676 },
  {   9840,   9841 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTelugu_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   3072,   3084 },
  {   3086,   3088 },
  {   3090,   3112 },
  {   3114,   3129 },
  {   3133,   3140 },
  {   3142,   3144 },
  {   3146,   3149 },
  {   3157,   3158 },
  {   3160,   3162 },
  {   3168,   3171 },
  {   3174,   3183 },
  {   3191,   3199 },
  {   7386,   7386 },
  {   7410,   7410 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansThaana_Regular[] =
{
  {     13,     13 },
  {     32,     33 },
  {     40,     41 },
  {     44,     44 },
  {     46,     46 },
  {     58,     59 },
  {    160,    160 },
  {   1548,   1548 },
  {   1563,   1563 },
  {   1567,   1567 },
  {   1632,   1644 },
  {   1920,   1969 },
  {   8203,   8207 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   9676,   9676 },
  {  65010,  65010 },
  {  65021,  65021 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansThaiUI_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     45,     45 },
  {    160,    160 },
  {    700,    700 },
  {    727,    727 },
  {    771,    771 },
  {    817,    817 },
  {   3585,   3642 },
  {   3647,   3675 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansWancho_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     34,     34 },
  {     39,     41 },
  {     44,     47 },
  {     91,     93 },
  {    123,    123 },
  {    125,    125 },
  {    160,    160 },
  {   8220,   8221 },
  {   9676,   9676 },
  { 123584, 123641 },
  { 123647, 123647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansAvestan_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     46,     46 },
  {    160,    160 },
  {    183,    183 },
  {   8204,   8205 },
  {  11824,  11825 },
  {  68352,  68405 },
  {  68409,  68415 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansBengali_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {    700,    700 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   2432,   2435 },
  {   2437,   2444 },
  {   2447,   2448 },
  {   2451,   2472 },
  {   2474,   2480 },
  {   2482,   2482 },
  {   2486,   2489 },
  {   2492,   2500 },
  {   2503,   2504 },
  {   2507,   2510 },
  {   2519,   2519 },
  {   2524,   2525 },
  {   2527,   2531 },
  {   2534,   2558 },
  {   7376,   7376 },
  {   7378,   7378 },
  {   7381,   7382 },
  {   7384,   7384 },
  {   7393,   7393 },
  {   7402,   7402 },
  {   7405,   7405 },
  {   7410,   7410 },
  {   7413,   7415 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  43249,  43249 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansCypriot_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  67584,  67589 },
  {  67592,  67592 },
  {  67594,  67637 },
  {  67639,  67640 },
  {  67644,  67644 },
  {  67647,  67647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansDeseret_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  66560,  66639 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansDisplay_Regular[] =
{
  {     13,     13 },
  {     32,    126 },
  {    160,    887 },
  {    890,    895 },
  {    900,    906 },
  {    908,    908 },
  {    910,    929 },
  {    931,    993 },
  {   1008,   1327 },
  {   6832,   6848 },
  {   7296,   7304 },
  {   7424,   7673 },
  {   7675,   7957 },
  {   7960,   7965 },
  {   7968,   8005 },
  {   8008,   8013 },
  {   8016,   8023 },
  {   8025,   8025 },
  {   8027,   8027 },
  {   8029,   8029 },
  {   8031,   8061 },
  {   8064,   8116 },
  {   8118,   8132 },
  {   8134,   8147 },
  {   8150,   8155 },
  {   8157,   8175 },
  {   8178,   8180 },
  {   8182,   8190 },
  {   8192,   8292 },
  {   8294,   8305 },
  {   8308,   8334 },
  {   8336,   8348 },
  {   8352,   8383 },
  {   8432,   8432 },
  {   8448,   8543 },
  {   8580,   8580 },
  {   8585,   8585 },
  {   9676,   9676 },
  {  11360,  11391 },
  {  11744,  11858 },
  {  42560,  42655 },
  {  42752,  42943 },
  {  42946,  42954 },
  {  42997,  43007 },
  {  43310,  43310 },
  {  43824,  43883 },
  {  64256,  64262 },
  {  65024,  65024 },
  {  65056,  65071 },
  {  65279,  65279 },
  {  65532,  65533 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansElbasan_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    183,    183 },
  {    773,    773 },
  {    913,    929 },
  {    931,    937 },
  {    986,    986 },
  {    988,    988 },
  {    990,    990 },
  {   9676,   9676 },
  {  66816,  66855 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansElymaic_Regular[] =
{
  {     32,     32 },
  {    160,    160 },
  {  69600,  69622 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansGrantha_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   2986,   2986 },
  {   2997,   2997 },
  {   3046,   3058 },
  {   7376,   7376 },
  {   7378,   7379 },
  {   7410,   7412 },
  {   7416,   7417 },
  {   8204,   8205 },
  {   8432,   8432 },
  {   9676,   9676 },
  {  70400,  70403 },
  {  70405,  70412 },
  {  70415,  70416 },
  {  70419,  70440 },
  {  70442,  70448 },
  {  70450,  70451 },
  {  70453,  70457 },
  {  70459,  70468 },
  {  70471,  70472 },
  {  70475,  70477 },
  {  70480,  70480 },
  {  70487,  70487 },
  {  70493,  70499 },
  {  70502,  70508 },
  {  70512,  70516 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansHanunoo_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   5920,   5942 },
  {   8203,   8205 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansKannada_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   3200,   3212 },
  {   3214,   3216 },
  {   3218,   3240 },
  {   3242,   3251 },
  {   3253,   3257 },
  {   3260,   3268 },
  {   3270,   3272 },
  {   3274,   3277 },
  {   3285,   3286 },
  {   3294,   3294 },
  {   3296,   3299 },
  {   3302,   3311 },
  {   3313,   3314 },
  {   7376,   7376 },
  {   7378,   7378 },
  {   7386,   7386 },
  {   7410,   7410 },
  {   7412,   7413 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  43056,  43061 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansKayahLi_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     45,     45 },
  {    160,    160 },
  {   8204,   8205 },
  {   8208,   8208 },
  {   9676,   9676 },
  {  43264,  43311 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansKhmerUI_Regular[] =
{
  {     13,     13 },
  {     32,     34 },
  {     39,     41 },
  {     44,     47 },
  {     58,     59 },
  {     63,     63 },
  {    160,    160 },
  {    171,    171 },
  {    173,    173 },
  {    187,    187 },
  {   6016,   6109 },
  {   6112,   6121 },
  {   6128,   6137 },
  {   6624,   6655 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansLinearA_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  67072,  67382 },
  {  67392,  67413 },
  {  67424,  67431 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansLinearB_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  65536,  65547 },
  {  65549,  65574 },
  {  65576,  65594 },
  {  65596,  65597 },
  {  65599,  65613 },
  {  65616,  65629 },
  {  65664,  65786 },
  {  65792,  65794 },
  {  65799,  65843 },
  {  65847,  65855 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMandaic_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   1600,   1600 },
  {   2112,   2139 },
  {   2142,   2142 },
  {   8204,   8205 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMarchen_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   9676,   9676 },
  {  72816,  72847 },
  {  72850,  72871 },
  {  72873,  72886 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMultani_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   2662,   2671 },
  {  70272,  70278 },
  {  70280,  70280 },
  {  70282,  70285 },
  {  70287,  70301 },
  {  70303,  70313 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMyanmar_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     63,     63 },
  {    160,    160 },
  {   4096,   4255 },
  {   8203,   8205 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   9676,   9676 },
  {  43310,  43310 },
  {  43488,  43518 },
  {  43616,  43647 },
  {  65024,  65024 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOlChiki_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   7248,   7295 },
  {   8377,   8377 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOriyaUI_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     44 },
  {     46,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {   2404,   2405 },
  {   2817,   2819 },
  {   2821,   2828 },
  {   2831,   2832 },
  {   2835,   2856 },
  {   2858,   2864 },
  {   2866,   2867 },
  {   2869,   2873 },
  {   2876,   2884 },
  {   2887,   2888 },
  {   2891,   2893 },
  {   2902,   2903 },
  {   2908,   2909 },
  {   2911,   2915 },
  {   2918,   2935 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOsmanya_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  66688,  66717 },
  {  66720,  66729 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansPhagsPa_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   6145,   6147 },
  {   6149,   6149 },
  {   8203,   8207 },
  {   8229,   8230 },
  {   9676,   9676 },
  {  12289,  12290 },
  {  12295,  12305 },
  {  12308,  12315 },
  {  43072,  43127 },
  {  65024,  65024 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSharada_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   2385,   2385 },
  {   7383,   7383 },
  {   7385,   7385 },
  {   7388,   7389 },
  {   7392,   7392 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  70016,  70111 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansShavian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  66640,  66687 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSiddham_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  71040,  71093 },
  {  71096,  71133 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSinhala_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {   2404,   2405 },
  {   3457,   3459 },
  {   3461,   3478 },
  {   3482,   3505 },
  {   3507,   3515 },
  {   3517,   3517 },
  {   3520,   3526 },
  {   3530,   3530 },
  {   3535,   3540 },
  {   3542,   3542 },
  {   3544,   3551 },
  {   3558,   3567 },
  {   3570,   3572 },
  {   8203,   8205 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  70113,  70132 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSogdian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   1600,   1600 },
  {   8204,   8204 },
  {   9676,   9676 },
  {  69424,  69465 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSoyombo_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   9676,   9676 },
  {  72272,  72354 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSymbols_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     48,     57 },
  {     65,     90 },
  {     97,    122 },
  {    160,    160 },
  {   8413,   8416 },
  {   8418,   8420 },
  {   8544,   8579 },
  {   8581,   8584 },
  {   8586,   8587 },
  {   8592,   8601 },
  {   8960,   8975 },
  {   8977,   8981 },
  {   8983,   8983 },
  {   8988,   8991 },
  {   8994,   8995 },
  {   9001,   9002 },
  {   9004,   9013 },
  {   9084,   9084 },
  {   9088,   9108 },
  {   9110,   9114 },
  {   9135,   9135 },
  {   9150,   9165 },
  {   9168,   9179 },
  {   9186,   9192 },
  {   9312,   9471 },
  {   9676,   9676 },
  {   9738,   9741 },
  {   9747,   9747 },
  {   9764,   9775 },
  {   9784,   9787 },
  {   9789,   9811 },
  {   9833,   9854 },
  {   9872,   9885 },
  {   9890,   9897 },
  {   9901,   9916 },
  {   9934,   9934 },
  {   9954,   9983 },
  {  10013,  10017 },
  {  10102,  10131 },
  {  10529,  10530 },
  { 127232, 127244 },
  { 127248, 127340 },
  { 127344, 127376 },
  { 127387, 127404 },
  { 128326, 128329 },
  { 128335, 128335 },
  { 128528, 128528 },
  { 128768, 128883 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTagalog_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   5888,   5900 },
  {   5902,   5908 },
  {   5941,   5942 },
  {   8203,   8205 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTaiTham_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   6688,   6750 },
  {   6752,   6780 },
  {   6783,   6793 },
  {   6800,   6809 },
  {   6816,   6829 },
  {   8203,   8205 },
  {   8729,   8729 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTaiViet_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8203,   8205 },
  {   9676,   9676 },
  {  42891,  42892 },
  {  43648,  43714 },
  {  43739,  43743 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTamilUI_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    178,    179 },
  {    215,    215 },
  {    247,    247 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   2946,   2947 },
  {   2949,   2954 },
  {   2958,   2960 },
  {   2962,   2965 },
  {   2969,   2970 },
  {   2972,   2972 },
  {   2974,   2975 },
  {   2979,   2980 },
  {   2984,   2986 },
  {   2990,   3001 },
  {   3006,   3010 },
  {   3014,   3016 },
  {   3018,   3021 },
  {   3024,   3024 },
  {   3031,   3031 },
  {   3046,   3066 },
  {   7386,   7386 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8308,   8308 },
  {   8322,   8324 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  43251,  43251 },
  {  70401,  70401 },
  {  70403,  70403 },
  {  70459,  70460 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTirhuta_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   2548,   2551 },
  {   7410,   7410 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  43056,  43065 },
  {  70784,  70855 },
  {  70864,  70873 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansArabicUI_Regular[] =
{
  {     13,     13 },
  {     32,     33 },
  {     44,     46 },
  {     48,     58 },
  {    160,    160 },
  {    171,    171 },
  {    187,    187 },
  {    847,    847 },
  {   1536,   1564 },
  {   1566,   1791 },
  {   1872,   1919 },
  {   2208,   2228 },
  {   2230,   2238 },
  {   2259,   2303 },
  {   8203,   8209 },
  {   8271,   8271 },
  {   9676,   9676 },
  {  11841,  11841 },
  {  64336,  64449 },
  {  64467,  64831 },
  {  64848,  64911 },
  {  64914,  64967 },
  {  65008,  65021 },
  {  65136,  65140 },
  {  65142,  65276 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansArmenian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     45,     45 },
  {    160,    160 },
  {    776,    776 },
  {   1329,   1366 },
  {   1369,   1418 },
  {   1421,   1423 },
  {   8208,   8208 },
  {   9676,   9676 },
  {  64275,  64279 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansBalinese_Regular[] =
{
  {     29,     29 },
  {     32,     32 },
  {     63,     63 },
  {    160,    160 },
  {   6912,   6987 },
  {   6992,   7036 },
  {   8203,   8205 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansBassaVah_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   9676,   9676 },
  {  92880,  92909 },
  {  92912,  92917 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansBuginese_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   6656,   6683 },
  {   6686,   6687 },
  {   8203,   8205 },
  {   9676,   9676 },
  {  43471,  43471 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansCherokee_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    768,    770 },
  {    772,    772 },
  {    779,    780 },
  {    803,    804 },
  {    816,    817 },
  {   5024,   5109 },
  {   5112,   5117 },
  {  43888,  43967 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansDuployan_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8204,   8205 },
  {   9676,   9676 },
  { 113664, 113770 },
  { 113776, 113788 },
  { 113792, 113800 },
  { 113808, 113817 },
  { 113820, 113827 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansEthiopic_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     45,     45 },
  {    160,    160 },
  {    776,    776 },
  {    782,    782 },
  {   4608,   4680 },
  {   4682,   4685 },
  {   4688,   4694 },
  {   4696,   4696 },
  {   4698,   4701 },
  {   4704,   4744 },
  {   4746,   4749 },
  {   4752,   4784 },
  {   4786,   4789 },
  {   4792,   4798 },
  {   4800,   4800 },
  {   4802,   4805 },
  {   4808,   4822 },
  {   4824,   4880 },
  {   4882,   4885 },
  {   4888,   4954 },
  {   4957,   4988 },
  {   4992,   5017 },
  {   8208,   8208 },
  {   8942,   8942 },
  {   9676,   9676 },
  {  11648,  11670 },
  {  11680,  11686 },
  {  11688,  11694 },
  {  11696,  11702 },
  {  11704,  11710 },
  {  11712,  11718 },
  {  11720,  11726 },
  {  11728,  11734 },
  {  11736,  11742 },
  {  43777,  43782 },
  {  43785,  43790 },
  {  43793,  43798 },
  {  43808,  43814 },
  {  43816,  43822 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansGeorgian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     45,     45 },
  {    160,    160 },
  {    769,    770 },
  {    772,    772 },
  {    776,    776 },
  {   1417,   1417 },
  {   4256,   4293 },
  {   4295,   4295 },
  {   4301,   4301 },
  {   4304,   4351 },
  {   7312,   7354 },
  {   7357,   7359 },
  {   8208,   8208 },
  {   8382,   8382 },
  {  11520,  11557 },
  {  11559,  11559 },
  {  11565,  11565 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansGujarati_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   2689,   2691 },
  {   2693,   2701 },
  {   2703,   2705 },
  {   2707,   2728 },
  {   2730,   2736 },
  {   2738,   2739 },
  {   2741,   2745 },
  {   2748,   2757 },
  {   2759,   2761 },
  {   2763,   2765 },
  {   2768,   2768 },
  {   2784,   2787 },
  {   2790,   2801 },
  {   2809,   2815 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  43056,  43065 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansGurmukhi_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   2561,   2563 },
  {   2565,   2570 },
  {   2575,   2576 },
  {   2579,   2600 },
  {   2602,   2608 },
  {   2610,   2611 },
  {   2613,   2614 },
  {   2616,   2617 },
  {   2620,   2620 },
  {   2622,   2626 },
  {   2631,   2632 },
  {   2635,   2637 },
  {   2641,   2641 },
  {   2649,   2652 },
  {   2654,   2654 },
  {   2662,   2678 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {   9772,   9772 },
  {  43056,  43065 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansJavanese_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8203,   8205 },
  {   9676,   9676 },
  {  43392,  43469 },
  {  43471,  43481 },
  {  43486,  43487 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMahajani_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   2404,   2415 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  43056,  43065 },
  {  69968,  70006 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMeroitic_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     58,     58 },
  {    160,    160 },
  {   8230,   8230 },
  {   8285,   8285 },
  {  67968,  68023 },
  {  68028,  68047 },
  {  68050,  68095 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSymbols2_Regular[] =
{
  {      1,     32 },
  {     35,     35 },
  {     42,     42 },
  {     48,     57 },
  {    127,    160 },
  {   8226,   8226 },
  {   8418,   8419 },
  {   8623,   8623 },
  {   8678,   8688 },
  {   8691,   8691 },
  {   8728,   8729 },
  {   8857,   8857 },
  {   8900,   8902 },
  {   8982,   8982 },
  {   8984,   8984 },
  {   8986,   8987 },
  {   8996,   9000 },
  {   9003,   9003 },
  {   9083,   9083 },
  {   9085,   9087 },
  {   9108,   9108 },
  {   9166,   9167 },
  {   9193,   9194 },
  {   9197,   9199 },
  {   9201,   9254 },
  {   9280,   9290 },
  {   9632,   9737 },
  {   9742,   9746 },
  {   9748,   9763 },
  {   9776,   9783 },
  {   9788,   9788 },
  {   9812,   9832 },
  {   9855,   9871 },
  {   9886,   9889 },
  {   9898,   9900 },
  {   9917,   9933 },
  {   9935,   9953 },
  {   9984,   9988 },
  {   9990,   9993 },
  {   9995,  10012 },
  {  10018,  10023 },
  {  10025,  10059 },
  {  10061,  10061 },
  {  10063,  10067 },
  {  10070,  10101 },
  {  10132,  10132 },
  {  10136,  10159 },
  {  10161,  10174 },
  {  10240,  10495 },
  {  10625,  10625 },
  {  10687,  10687 },
  {  10731,  10731 },
  {  11008,  11021 },
  {  11026,  11055 },
  {  11085,  11123 },
  {  11126,  11157 },
  {  11159,  11261 },
  {  11263,  11263 },
  {  19904,  19967 },
  {  65529,  65531 },
  {  65856,  65934 },
  {  65936,  65948 },
  {  65952,  65952 },
  {  66000,  66045 },
  {  66272,  66299 },
  {  69216,  69246 },
  { 119520, 119539 },
  { 119552, 119638 },
  { 119648, 119672 },
  { 126976, 127019 },
  { 127024, 127123 },
  { 127136, 127150 },
  { 127153, 127167 },
  { 127169, 127183 },
  { 127185, 127221 },
  { 127757, 127759 },
  { 127765, 127765 },
  { 127772, 127772 },
  { 127777, 127788 },
  { 127798, 127798 },
  { 127864, 127864 },
  { 127869, 127869 },
  { 127891, 127903 },
  { 127911, 127911 },
  { 127916, 127918 },
  { 127938, 127938 },
  { 127940, 127940 },
  { 127942, 127942 },
  { 127946, 127950 },
  { 127956, 127968 },
  { 127981, 127981 },
  { 127985, 127987 },
  { 127989, 127991 },
  { 128008, 128008 },
  { 128021, 128021 },
  { 128031, 128031 },
  { 128038, 128038 },
  { 128063, 128063 },
  { 128065, 128066 },
  { 128070, 128073 },
  { 128076, 128078 },
  { 128083, 128083 },
  { 128106, 128106 },
  { 128125, 128125 },
  { 128163, 128163 },
  { 128176, 128176 },
  { 128179, 128179 },
  { 128185, 128185 },
  { 128187, 128187 },
  { 128191, 128191 },
  { 128200, 128203 },
  { 128218, 128218 },
  { 128223, 128223 },
  { 128228, 128230 },
  { 128234, 128237 },
  { 128247, 128247 },
  { 128249, 128251 },
  { 128253, 128254 },
  { 128259, 128259 },
  { 128263, 128266 },
  { 128269, 128269 },
  { 128274, 128275 },
  { 128318, 128325 },
  { 128330, 128330 },
  { 128336, 128377 },
  { 128379, 128404 },
  { 128407, 128419 },
  { 128421, 128506 },
  { 128592, 128639 },
  { 128647, 128647 },
  { 128653, 128653 },
  { 128657, 128657 },
  { 128660, 128660 },
  { 128664, 128664 },
  { 128685, 128685 },
  { 128690, 128690 },
  { 128697, 128698 },
  { 128700, 128700 },
  { 128710, 128715 },
  { 128717, 128719 },
  { 128723, 128727 },
  { 128736, 128746 },
  { 128752, 128755 },
  { 128759, 128764 },
  { 128896, 128984 },
  { 128992, 129003 },
  { 129024, 129035 },
  { 129040, 129095 },
  { 129104, 129113 },
  { 129120, 129159 },
  { 129168, 129197 },
  { 129200, 129201 },
  { 129339, 129339 },
  { 129350, 129350 },
  { 129536, 129619 },
  { 129632, 129645 },
  { 129648, 129652 },
  { 129656, 129658 },
  { 129664, 129670 },
  { 129680, 129704 },
  { 129712, 129718 },
  { 129728, 129730 },
  { 129744, 129750 },
  { 129792, 129938 },
  { 129940, 129994 },
  { 130032, 130041 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTagbanwa_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   5941,   5942 },
  {   5984,   5996 },
  {   5998,   6000 },
  {   6002,   6003 },
  {   8203,   8205 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTeluguUI_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   3072,   3084 },
  {   3086,   3088 },
  {   3090,   3112 },
  {   3114,   3129 },
  {   3133,   3140 },
  {   3142,   3144 },
  {   3146,   3149 },
  {   3157,   3158 },
  {   3160,   3162 },
  {   3168,   3171 },
  {   3174,   3183 },
  {   3191,   3199 },
  {   7386,   7386 },
  {   7410,   7410 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTifinagh_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    711,    711 },
  {    769,    770 },
  {    772,    772 },
  {    774,    775 },
  {    777,    777 },
  {    803,    803 },
  {    817,    817 },
  {   8204,   8205 },
  {   8238,   8238 },
  {   9676,   9676 },
  {  11568,  11623 },
  {  11631,  11632 },
  {  11647,  11647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansUgaritic_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  66432,  66461 },
  {  66463,  66463 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansBengaliUI_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {    700,    700 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   2432,   2435 },
  {   2437,   2444 },
  {   2447,   2448 },
  {   2451,   2472 },
  {   2474,   2480 },
  {   2482,   2482 },
  {   2486,   2489 },
  {   2492,   2500 },
  {   2503,   2504 },
  {   2507,   2510 },
  {   2519,   2519 },
  {   2524,   2525 },
  {   2527,   2531 },
  {   2534,   2558 },
  {   7376,   7376 },
  {   7378,   7378 },
  {   7381,   7382 },
  {   7384,   7384 },
  {   7393,   7393 },
  {   7402,   7402 },
  {   7405,   7405 },
  {   7410,   7410 },
  {   7413,   7415 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  43249,  43249 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansBhaiksuki_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8203,   8203 },
  {   9676,   9676 },
  {  72704,  72712 },
  {  72714,  72758 },
  {  72760,  72773 },
  {  72784,  72812 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansCuneiform_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  73728,  74649 },
  {  74752,  74862 },
  {  74864,  74868 },
  {  74880,  75075 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansKannadaUI_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   3200,   3212 },
  {   3214,   3216 },
  {   3218,   3240 },
  {   3242,   3251 },
  {   3253,   3257 },
  {   3260,   3268 },
  {   3270,   3272 },
  {   3274,   3277 },
  {   3285,   3286 },
  {   3294,   3294 },
  {   3296,   3299 },
  {   3302,   3311 },
  {   3313,   3314 },
  {   7376,   7376 },
  {   7378,   7378 },
  {   7386,   7386 },
  {   7410,   7410 },
  {   7412,   7413 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  43056,  43061 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansKhudawadi_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   2404,   2405 },
  {   8204,   8205 },
  {   8211,   8212 },
  {   9676,   9676 },
  {  43056,  43065 },
  {  70320,  70378 },
  {  70384,  70393 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMalayalam_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {    775,    775 },
  {    803,    803 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   3328,   3340 },
  {   3342,   3344 },
  {   3346,   3396 },
  {   3398,   3400 },
  {   3402,   3407 },
  {   3412,   3427 },
  {   3430,   3455 },
  {   7386,   7386 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  43056,  43058 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMongolian_Regular[] =
{
  {     13,     13 },
  {     32,     34 },
  {     40,     41 },
  {     45,     45 },
  {     63,     63 },
  {    160,    160 },
  {   6144,   6158 },
  {   6160,   6169 },
  {   6176,   6264 },
  {   6272,   6314 },
  {   8204,   8205 },
  {   8211,   8212 },
  {   8220,   8221 },
  {   8239,   8239 },
  {   8264,   8265 },
  {   9312,   9331 },
  {   9676,   9676 },
  {  12289,  12290 },
  {  12298,  12303 },
  {  65085,  65086 },
  {  65089,  65092 },
  {  71264,  71276 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMyanmarUI_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     63,     63 },
  {    160,    160 },
  {   4096,   4255 },
  {   8203,   8205 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   9676,   9676 },
  {  43310,  43310 },
  {  43488,  43518 },
  {  43616,  43647 },
  {  65024,  65024 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansNabataean_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  67712,  67742 },
  {  67751,  67759 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansNewTaiLue_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   6528,   6571 },
  {   6576,   6601 },
  {   6608,   6618 },
  {   6622,   6623 },
  {   8204,   8205 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOldItalic_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  66304,  66339 },
  {  66349,  66351 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOldPermic_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    768,    768 },
  {    774,    776 },
  {    787,    787 },
  {   1155,   1155 },
  {   8411,   8411 },
  {   9676,   9676 },
  {  66384,  66426 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOldTurkic_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  68608,  68680 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansPalmyrene_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  67680,  67711 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansPauCinHau_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  72384,  72440 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSamaritan_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   2048,   2093 },
  {   2096,   2110 },
  {  11825,  11825 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSinhalaUI_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {   2404,   2405 },
  {   3457,   3459 },
  {   3461,   3478 },
  {   3482,   3505 },
  {   3507,   3515 },
  {   3517,   3517 },
  {   3520,   3526 },
  {   3530,   3530 },
  {   3535,   3540 },
  {   3542,   3542 },
  {   3544,   3551 },
  {   3558,   3567 },
  {   3570,   3572 },
  {   8203,   8205 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  70113,  70132 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSundanese_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     45,     45 },
  {    160,    160 },
  {   7040,   7103 },
  {   7360,   7367 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansDevanagari_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {    700,    700 },
  {   2304,   2431 },
  {   7376,   7414 },
  {   7416,   7417 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8432,   8432 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  43056,  43065 },
  {  43232,  43263 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansGlagolitic_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    771,    771 },
  {    773,    773 },
  {   1156,   1156 },
  {   1159,   1159 },
  {  11264,  11310 },
  {  11312,  11358 },
  {  42607,  42607 },
  { 122880, 122886 },
  { 122888, 122904 },
  { 122907, 122913 },
  { 122915, 122916 },
  { 122918, 122922 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansGujaratiUI_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   2689,   2691 },
  {   2693,   2701 },
  {   2703,   2705 },
  {   2707,   2728 },
  {   2730,   2736 },
  {   2738,   2739 },
  {   2741,   2745 },
  {   2748,   2757 },
  {   2759,   2761 },
  {   2763,   2765 },
  {   2768,   2768 },
  {   2784,   2787 },
  {   2790,   2801 },
  {   2809,   2815 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  43056,  43065 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansGurmukhiUI_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   2561,   2563 },
  {   2565,   2570 },
  {   2575,   2576 },
  {   2579,   2600 },
  {   2602,   2608 },
  {   2610,   2611 },
  {   2613,   2614 },
  {   2616,   2617 },
  {   2620,   2620 },
  {   2622,   2626 },
  {   2631,   2632 },
  {   2635,   2637 },
  {   2641,   2641 },
  {   2649,   2652 },
  {   2654,   2654 },
  {   2662,   2678 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {   9772,   9772 },
  {  43056,  43065 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansKharoshthi_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     45,     45 },
  {    160,    160 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   9676,   9676 },
  {  68096,  68099 },
  {  68101,  68102 },
  {  68108,  68115 },
  {  68117,  68119 },
  {  68121,  68149 },
  {  68152,  68154 },
  {  68159,  68168 },
  {  68176,  68184 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansManichaean_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   1600,   1600 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  65024,  65024 },
  {  68288,  68326 },
  {  68331,  68342 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOldPersian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  66464,  66499 },
  {  66504,  66517 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOldSogdian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  69376,  69415 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansPhoenician_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  67840,  67867 },
  {  67871,  67871 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSaurashtra_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8203,   8205 },
  {   9676,   9676 },
  {  43136,  43205 },
  {  43214,  43225 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansWarangCiti_Regular[] =
{
  {     32,     32 },
  {     39,     39 },
  {    160,    160 },
  {   8204,   8205 },
  {  71840,  71922 },
  {  71935,  71935 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMalayalamUI_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {    775,    775 },
  {    803,    803 },
  {   2385,   2386 },
  {   2404,   2405 },
  {   3328,   3340 },
  {   3342,   3344 },
  {   3346,   3396 },
  {   3398,   3400 },
  {   3402,   3407 },
  {   3412,   3427 },
  {   3430,   3455 },
  {   7386,   7386 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  43056,  43058 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMedefaidrin_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  93760,  93850 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMeeteiMayek_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8203,   8205 },
  {   9676,   9676 },
  {  43744,  43766 },
  {  43968,  44013 },
  {  44016,  44025 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansPahawhHmong_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  92928,  92997 },
  {  93008,  93017 },
  {  93019,  93025 },
  {  93027,  93047 },
  {  93053,  93071 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSignWriting_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8203,   8204 },
  {   9676,   9676 },
  { 120832, 121483 },
  { 121499, 121503 },
  { 121505, 121519 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSoraSompeng_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {     45,     45 },
  {    160,    160 },
  {   8208,   8208 },
  {  69840,  69864 },
  {  69872,  69881 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansSylotiNagri_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   2404,   2405 },
  {   2534,   2543 },
  {   8203,   8205 },
  {   8208,   8209 },
  {   8277,   8277 },
  {   9676,   9676 },
  {  43008,  43052 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTifinaghAir_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    711,    711 },
  {    769,    770 },
  {    772,    772 },
  {    774,    775 },
  {    777,    777 },
  {    803,    803 },
  {    817,    817 },
  {   8204,   8205 },
  {   8238,   8238 },
  {   9676,   9676 },
  {  11568,  11623 },
  {  11631,  11632 },
  {  11647,  11647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTifinaghAPT_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    711,    711 },
  {    769,    770 },
  {    772,    772 },
  {    774,    775 },
  {    777,    777 },
  {    803,    803 },
  {    817,    817 },
  {   8204,   8205 },
  {   8238,   8238 },
  {   9676,   9676 },
  {  11568,  11623 },
  {  11631,  11632 },
  {  11647,  11647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTifinaghSIL_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    711,    711 },
  {    769,    770 },
  {    772,    772 },
  {    774,    775 },
  {    777,    777 },
  {    803,    803 },
  {    817,    817 },
  {   8204,   8205 },
  {   8238,   8238 },
  {   9676,   9676 },
  {  11568,  11623 },
  {  11631,  11632 },
  {  11647,  11647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansDevanagariUI_Regular[] =
{
  {     13,     13 },
  {     32,     35 },
  {     37,     37 },
  {     39,     63 },
  {     91,     95 },
  {    123,    126 },
  {    160,    160 },
  {    173,    173 },
  {    215,    215 },
  {    247,    247 },
  {    700,    700 },
  {   2304,   2431 },
  {   7376,   7414 },
  {   7416,   7417 },
  {   8203,   8205 },
  {   8208,   8208 },
  {   8211,   8212 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8377,   8377 },
  {   8432,   8432 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  43056,  43065 },
  {  43232,  43263 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansGunjalaGondi_Regular[] =
{
  {     13,     13 },
  {     32,     33 },
  {     37,     37 },
  {     39,     47 },
  {     58,     58 },
  {     60,     63 },
  {    160,    160 },
  {    215,    215 },
  {    247,    247 },
  {   8204,   8205 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  73056,  73061 },
  {  73063,  73064 },
  {  73066,  73102 },
  {  73104,  73105 },
  {  73107,  73112 },
  {  73120,  73129 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMasaramGondi_Regular[] =
{
  {     13,     13 },
  {     32,     34 },
  {     37,     37 },
  {     39,     47 },
  {     58,     63 },
  {    160,    160 },
  {    215,    215 },
  {    247,    247 },
  {   2404,   2405 },
  {   8216,   8217 },
  {   8220,   8221 },
  {   8230,   8230 },
  {   8722,   8722 },
  {   9676,   9676 },
  {  72960,  72966 },
  {  72968,  72969 },
  {  72971,  73014 },
  {  73018,  73018 },
  {  73020,  73021 },
  {  73023,  73031 },
  {  73040,  73049 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMendeKikakui_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   9676,   9676 },
  { 124928, 125124 },
  { 125127, 125142 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOldHungarian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8205,   8205 },
  {  68736,  68786 },
  {  68800,  68850 },
  {  68858,  68863 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTifinaghGhat_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    711,    711 },
  {    769,    770 },
  {    772,    772 },
  {    774,    775 },
  {    777,    777 },
  {    803,    803 },
  {    817,    817 },
  {   8204,   8205 },
  {   8238,   8238 },
  {   9676,   9676 },
  {  11568,  11623 },
  {  11631,  11632 },
  {  11647,  11647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansAdlamUnjoined_Regular[] =
{
  {     13,     13 },
  {     32,     47 },
  {     58,     64 },
  {     91,     95 },
  {    123,    125 },
  {    160,    160 },
  {    171,    171 },
  {    187,    187 },
  {   1567,   1567 },
  {   1600,   1600 },
  {   8211,   8213 },
  {   8216,   8222 },
  {   8224,   8226 },
  {   8230,   8230 },
  {   8240,   8240 },
  {   8249,   8250 },
  {   8260,   8260 },
  {   8271,   8271 },
  {   9676,   9676 },
  {  11816,  11817 },
  {  11841,  11841 },
  { 125184, 125259 },
  { 125264, 125273 },
  { 125278, 125279 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansMayanNumerals_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  { 119520, 119539 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTifinaghAdrar_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    711,    711 },
  {    769,    770 },
  {    772,    772 },
  {    774,    775 },
  {    777,    777 },
  {    803,    803 },
  {    817,    817 },
  {   8204,   8205 },
  {   8238,   8238 },
  {   9676,   9676 },
  {  11568,  11623 },
  {  11631,  11632 },
  {  11647,  11647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTifinaghHawad_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    711,    711 },
  {    769,    770 },
  {    772,    772 },
  {    774,    775 },
  {    777,    777 },
  {    803,    803 },
  {    817,    817 },
  {   8204,   8205 },
  {   8238,   8238 },
  {   9676,   9676 },
  {  11568,  11623 },
  {  11631,  11632 },
  {  11647,  11647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansHanifiRohingya_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    171,    171 },
  {    187,    187 },
  {   1548,   1548 },
  {   1563,   1563 },
  {   1567,   1567 },
  {   1600,   1600 },
  {   1632,   1632 },
  {   1748,   1748 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  68864,  68903 },
  {  68912,  68921 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansPsalterPahlavi_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   1600,   1600 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  68480,  68497 },
  {  68505,  68508 },
  {  68521,  68527 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansImperialAramaic_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  67648,  67669 },
  {  67671,  67679 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOldNorthArabian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  68224,  68255 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansOldSouthArabian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  68192,  68223 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTamilSupplement_Regular[] =
{
  {     13,     13 },
  {  73664,  73713 },
  {  73727,  73727 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTifinaghAhaggar_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    711,    711 },
  {    769,    770 },
  {    772,    772 },
  {    774,    775 },
  {    777,    777 },
  {    803,    803 },
  {    817,    817 },
  {   8204,   8205 },
  {   8238,   8238 },
  {   9676,   9676 },
  {  11568,  11623 },
  {  11631,  11632 },
  {  11647,  11647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTifinaghAzawagh_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    711,    711 },
  {    769,    770 },
  {    772,    772 },
  {    774,    775 },
  {    777,    777 },
  {    803,    803 },
  {    817,    817 },
  {   8204,   8205 },
  {   8238,   8238 },
  {   9676,   9676 },
  {  11568,  11623 },
  {  11631,  11632 },
  {  11647,  11647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansZanabazarSquare_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   9676,   9676 },
  {  72192,  72263 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansCaucasianAlbanian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    772,    772 },
  {    817,    817 },
  {   9676,   9676 },
  {  65056,  65071 },
  {  66864,  66915 },
  {  66927,  66927 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansIndicSiyaqNumbers_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   1575,   1575 },
  {   1632,   1641 },
  {   1776,   1785 },
  { 126065, 126132 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTifinaghRhissaIxa_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    711,    711 },
  {    769,    770 },
  {    772,    772 },
  {    774,    775 },
  {    777,    777 },
  {    803,    803 },
  {    817,    817 },
  {   8204,   8205 },
  {   8238,   8238 },
  {   9676,   9676 },
  {  11568,  11623 },
  {  11631,  11632 },
  {  11647,  11647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansCanadianAboriginal_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    305,    305 },
  {    711,    711 },
  {    728,    731 },
  {    775,    775 },
  {   5120,   5759 },
  {   6320,   6389 },
  {   9676,   9676 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansEgyptianHieroglyphs_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8204,   8205 },
  {   9676,   9676 },
  {  77824,  78894 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTifinaghTawellemmet_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    711,    711 },
  {    769,    770 },
  {    772,    772 },
  {    774,    775 },
  {    777,    777 },
  {    803,    803 },
  {    817,    817 },
  {   8204,   8205 },
  {   8238,   8238 },
  {   9676,   9676 },
  {  11568,  11623 },
  {  11631,  11632 },
  {  11647,  11647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansAnatolianHieroglyphs_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {   8203,   8203 },
  {  82944,  83526 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansInscriptionalPahlavi_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  68448,  68466 },
  {  68472,  68479 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansInscriptionalParthian_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {  68416,  68437 },
  {  68440,  68447 },
  {      0,      0 },
};

const start_end codes_for_font_NotoSansTifinaghAgrawImazighen_Regular[] =
{
  {     13,     13 },
  {     32,     32 },
  {    160,    160 },
  {    711,    711 },
  {    769,    770 },
  {    772,    772 },
  {    774,    775 },
  {    777,    777 },
  {    803,    803 },
  {    817,    817 },
  {   8204,   8205 },
  {   8238,   8238 },
  {   9676,   9676 },
  {  11568,  11623 },
  {  11631,  11632 },
  {  11647,  11647 },
  {      0,      0 },
};

const start_end codes_for_font_NotoColorEmoji[] =
{
  {     13,     13 },
  {     32,     32 },
  {     35,     35 },
  {     42,     42 },
  {     48,     57 },
  {    169,    169 },
  {    174,    174 },
  {   8205,   8205 },
  {   8252,   8252 },
  {   8265,   8265 },
  {   8419,   8419 },
  {   8482,   8482 },
  {   8505,   8505 },
  {   8596,   8601 },
  {   8617,   8618 },
  {   8986,   8987 },
  {   9000,   9000 },
  {   9167,   9167 },
  {   9193,   9203 },
  {   9208,   9210 },
  {   9410,   9410 },
  {   9642,   9643 },
  {   9654,   9654 },
  {   9664,   9664 },
  {   9723,   9726 },
  {   9728,   9732 },
  {   9742,   9742 },
  {   9745,   9745 },
  {   9748,   9749 },
  {   9752,   9752 },
  {   9757,   9757 },
  {   9760,   9760 },
  {   9762,   9763 },
  {   9766,   9766 },
  {   9770,   9770 },
  {   9774,   9775 },
  {   9784,   9786 },
  {   9792,   9792 },
  {   9794,   9794 },
  {   9800,   9811 },
  {   9823,   9824 },
  {   9827,   9827 },
  {   9829,   9830 },
  {   9832,   9832 },
  {   9851,   9851 },
  {   9854,   9855 },
  {   9874,   9879 },
  {   9881,   9881 },
  {   9883,   9884 },
  {   9888,   9889 },
  {   9895,   9895 },
  {   9898,   9899 },
  {   9904,   9905 },
  {   9917,   9918 },
  {   9924,   9925 },
  {   9928,   9928 },
  {   9934,   9935 },
  {   9937,   9937 },
  {   9939,   9940 },
  {   9961,   9962 },
  {   9968,   9973 },
  {   9975,   9978 },
  {   9981,   9981 },
  {   9986,   9986 },
  {   9989,   9989 },
  {   9992,   9997 },
  {   9999,   9999 },
  {  10002,  10002 },
  {  10004,  10004 },
  {  10006,  10006 },
  {  10013,  10013 },
  {  10017,  10017 },
  {  10024,  10024 },
  {  10035,  10036 },
  {  10052,  10052 },
  {  10055,  10055 },
  {  10060,  10060 },
  {  10062,  10062 },
  {  10067,  10069 },
  {  10071,  10071 },
  {  10083,  10084 },
  {  10133,  10135 },
  {  10145,  10145 },
  {  10160,  10160 },
  {  10175,  10175 },
  {  10548,  10549 },
  {  11013,  11015 },
  {  11035,  11036 },
  {  11088,  11088 },
  {  11093,  11093 },
  {  12336,  12336 },
  {  12349,  12349 },
  {  12951,  12951 },
  {  12953,  12953 },
  { 126980, 126980 },
  { 127183, 127183 },
  { 127344, 127345 },
  { 127358, 127359 },
  { 127374, 127374 },
  { 127377, 127386 },
  { 127462, 127487 },
  { 127489, 127490 },
  { 127514, 127514 },
  { 127535, 127535 },
  { 127538, 127546 },
  { 127568, 127569 },
  { 127744, 127777 },
  { 127780, 127891 },
  { 127894, 127895 },
  { 127897, 127899 },
  { 127902, 127984 },
  { 127987, 127989 },
  { 127991, 128253 },
  { 128255, 128317 },
  { 128329, 128334 },
  { 128336, 128359 },
  { 128367, 128368 },
  { 128371, 128378 },
  { 128391, 128391 },
  { 128394, 128397 },
  { 128400, 128400 },
  { 128405, 128406 },
  { 128420, 128421 },
  { 128424, 128424 },
  { 128433, 128434 },
  { 128444, 128444 },
  { 128450, 128452 },
  { 128465, 128467 },
  { 128476, 128478 },
  { 128481, 128481 },
  { 128483, 128483 },
  { 128488, 128488 },
  { 128495, 128495 },
  { 128499, 128499 },
  { 128506, 128591 },
  { 128640, 128709 },
  { 128715, 128722 },
  { 128725, 128727 },
  { 128732, 128741 },
  { 128745, 128745 },
  { 128747, 128748 },
  { 128752, 128752 },
  { 128755, 128764 },
  { 128992, 129003 },
  { 129008, 129008 },
  { 129292, 129338 },
  { 129340, 129349 },
  { 129351, 129535 },
  { 129648, 129660 },
  { 129664, 129673 },
  { 129679, 129734 },
  { 129742, 129756 },
  { 129759, 129769 },
  { 129776, 129784 },
  { 917552, 917561 },
  { 917601, 917626 },
  { 917631, 917631 },
  { 1041637, 1041646 },
  { 1042476, 1042476 },
  { 1042478, 1042487 },
  {      0,      0 },
};



font fontlist[] =
{
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSans-Regular.ttf",
    .codes   =  codes_for_font_NotoSans_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansYi-Regular.ttf",
    .codes   =  codes_for_font_NotoSansYi_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/opentype/noto/NotoSansCJK-Regular.ttc",
    .codes   =  codes_for_font_NotoSansCJK_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansLao-Regular.ttf",
    .codes   =  codes_for_font_NotoSansLao_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMro-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMro_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansNKo-Regular.ttf",
    .codes   =  codes_for_font_NotoSansNKo_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansVai-Regular.ttf",
    .codes   =  codes_for_font_NotoSansVai_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansCham-Regular.ttf",
    .codes   =  codes_for_font_NotoSansCham_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansLisu-Regular.ttf",
    .codes   =  codes_for_font_NotoSansLisu_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMath-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMath_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMiao-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMiao_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansModi-Regular.ttf",
    .codes   =  codes_for_font_NotoSansModi_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMono-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMono_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansNewa-Regular.ttf",
    .codes   =  codes_for_font_NotoSansNewa_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansThai-Regular.ttf",
    .codes   =  codes_for_font_NotoSansThai_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansAdlam-Regular.ttf",
    .codes   =  codes_for_font_NotoSansAdlam_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansBamum-Regular.ttf",
    .codes   =  codes_for_font_NotoSansBamum_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansBatak-Regular.ttf",
    .codes   =  codes_for_font_NotoSansBatak_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansBuhid-Regular.ttf",
    .codes   =  codes_for_font_NotoSansBuhid_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansKhmer-Regular.ttf",
    .codes   =  codes_for_font_NotoSansKhmer_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansLaoUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansLaoUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansLimbu-Regular.ttf",
    .codes   =  codes_for_font_NotoSansLimbu_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansNushu-Regular.ttf",
    .codes   =  codes_for_font_NotoSansNushu_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOgham-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOgham_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOriya-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOriya_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOsage-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOsage_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansRunic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansRunic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTaiLe-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTaiLe_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTakri-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTakri_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTamil-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTamil_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansArabic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansArabic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansBrahmi-Regular.ttf",
    .codes   =  codes_for_font_NotoSansBrahmi_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansCarian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansCarian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansChakma-Regular.ttf",
    .codes   =  codes_for_font_NotoSansChakma_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansCoptic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansCoptic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansGothic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansGothic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansHatran-Regular.ttf",
    .codes   =  codes_for_font_NotoSansHatran_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansHebrew-Regular.ttf",
    .codes   =  codes_for_font_NotoSansHebrew_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansKaithi-Regular.ttf",
    .codes   =  codes_for_font_NotoSansKaithi_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansKhojki-Regular.ttf",
    .codes   =  codes_for_font_NotoSansKhojki_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansLepcha-Regular.ttf",
    .codes   =  codes_for_font_NotoSansLepcha_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansLycian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansLycian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansLydian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansLydian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansRejang-Regular.ttf",
    .codes   =  codes_for_font_NotoSansRejang_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSyriac-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSyriac_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTelugu-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTelugu_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansThaana-Regular.ttf",
    .codes   =  codes_for_font_NotoSansThaana_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansThaiUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansThaiUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansWancho-Regular.ttf",
    .codes   =  codes_for_font_NotoSansWancho_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansAvestan-Regular.ttf",
    .codes   =  codes_for_font_NotoSansAvestan_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansBengali-Regular.ttf",
    .codes   =  codes_for_font_NotoSansBengali_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansCypriot-Regular.ttf",
    .codes   =  codes_for_font_NotoSansCypriot_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansDeseret-Regular.ttf",
    .codes   =  codes_for_font_NotoSansDeseret_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansDisplay-Regular.ttf",
    .codes   =  codes_for_font_NotoSansDisplay_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansElbasan-Regular.ttf",
    .codes   =  codes_for_font_NotoSansElbasan_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansElymaic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansElymaic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansGrantha-Regular.ttf",
    .codes   =  codes_for_font_NotoSansGrantha_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansHanunoo-Regular.ttf",
    .codes   =  codes_for_font_NotoSansHanunoo_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansKannada-Regular.ttf",
    .codes   =  codes_for_font_NotoSansKannada_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansKayahLi-Regular.ttf",
    .codes   =  codes_for_font_NotoSansKayahLi_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansKhmerUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansKhmerUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansLinearA-Regular.ttf",
    .codes   =  codes_for_font_NotoSansLinearA_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansLinearB-Regular.ttf",
    .codes   =  codes_for_font_NotoSansLinearB_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMandaic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMandaic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMarchen-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMarchen_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMultani-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMultani_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMyanmar-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMyanmar_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOlChiki-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOlChiki_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOriyaUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOriyaUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOsmanya-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOsmanya_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansPhagsPa-Regular.ttf",
    .codes   =  codes_for_font_NotoSansPhagsPa_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSharada-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSharada_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansShavian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansShavian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSiddham-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSiddham_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSinhala-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSinhala_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSogdian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSogdian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSoyombo-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSoyombo_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSymbols-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSymbols_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTagalog-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTagalog_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTaiTham-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTaiTham_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTaiViet-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTaiViet_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTamilUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTamilUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTirhuta-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTirhuta_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansArabicUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansArabicUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansArmenian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansArmenian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansBalinese-Regular.ttf",
    .codes   =  codes_for_font_NotoSansBalinese_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansBassaVah-Regular.ttf",
    .codes   =  codes_for_font_NotoSansBassaVah_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansBuginese-Regular.ttf",
    .codes   =  codes_for_font_NotoSansBuginese_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansCherokee-Regular.ttf",
    .codes   =  codes_for_font_NotoSansCherokee_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansDuployan-Regular.ttf",
    .codes   =  codes_for_font_NotoSansDuployan_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansEthiopic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansEthiopic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansGeorgian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansGeorgian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansGujarati-Regular.ttf",
    .codes   =  codes_for_font_NotoSansGujarati_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansGurmukhi-Regular.ttf",
    .codes   =  codes_for_font_NotoSansGurmukhi_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansJavanese-Regular.ttf",
    .codes   =  codes_for_font_NotoSansJavanese_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMahajani-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMahajani_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMeroitic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMeroitic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSymbols2-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSymbols2_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTagbanwa-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTagbanwa_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTeluguUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTeluguUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTifinagh-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTifinagh_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansUgaritic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansUgaritic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansBengaliUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansBengaliUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansBhaiksuki-Regular.ttf",
    .codes   =  codes_for_font_NotoSansBhaiksuki_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansCuneiform-Regular.ttf",
    .codes   =  codes_for_font_NotoSansCuneiform_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansKannadaUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansKannadaUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansKhudawadi-Regular.ttf",
    .codes   =  codes_for_font_NotoSansKhudawadi_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMalayalam-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMalayalam_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMongolian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMongolian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMyanmarUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMyanmarUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansNabataean-Regular.ttf",
    .codes   =  codes_for_font_NotoSansNabataean_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansNewTaiLue-Regular.ttf",
    .codes   =  codes_for_font_NotoSansNewTaiLue_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOldItalic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOldItalic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOldPermic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOldPermic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOldTurkic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOldTurkic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansPalmyrene-Regular.ttf",
    .codes   =  codes_for_font_NotoSansPalmyrene_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansPauCinHau-Regular.ttf",
    .codes   =  codes_for_font_NotoSansPauCinHau_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSamaritan-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSamaritan_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSinhalaUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSinhalaUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSundanese-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSundanese_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansDevanagari-Regular.ttf",
    .codes   =  codes_for_font_NotoSansDevanagari_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansGlagolitic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansGlagolitic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansGujaratiUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansGujaratiUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansGurmukhiUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansGurmukhiUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansKharoshthi-Regular.ttf",
    .codes   =  codes_for_font_NotoSansKharoshthi_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansManichaean-Regular.ttf",
    .codes   =  codes_for_font_NotoSansManichaean_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOldPersian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOldPersian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOldSogdian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOldSogdian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansPhoenician-Regular.ttf",
    .codes   =  codes_for_font_NotoSansPhoenician_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSaurashtra-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSaurashtra_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansWarangCiti-Regular.ttf",
    .codes   =  codes_for_font_NotoSansWarangCiti_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMalayalamUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMalayalamUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMedefaidrin-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMedefaidrin_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMeeteiMayek-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMeeteiMayek_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansPahawhHmong-Regular.ttf",
    .codes   =  codes_for_font_NotoSansPahawhHmong_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSignWriting-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSignWriting_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSoraSompeng-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSoraSompeng_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansSylotiNagri-Regular.ttf",
    .codes   =  codes_for_font_NotoSansSylotiNagri_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTifinaghAir-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTifinaghAir_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTifinaghAPT-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTifinaghAPT_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTifinaghSIL-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTifinaghSIL_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansDevanagariUI-Regular.ttf",
    .codes   =  codes_for_font_NotoSansDevanagariUI_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansGunjalaGondi-Regular.ttf",
    .codes   =  codes_for_font_NotoSansGunjalaGondi_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMasaramGondi-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMasaramGondi_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMendeKikakui-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMendeKikakui_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOldHungarian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOldHungarian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTifinaghGhat-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTifinaghGhat_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansAdlamUnjoined-Regular.ttf",
    .codes   =  codes_for_font_NotoSansAdlamUnjoined_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansMayanNumerals-Regular.ttf",
    .codes   =  codes_for_font_NotoSansMayanNumerals_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTifinaghAdrar-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTifinaghAdrar_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTifinaghHawad-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTifinaghHawad_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansHanifiRohingya-Regular.ttf",
    .codes   =  codes_for_font_NotoSansHanifiRohingya_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansPsalterPahlavi-Regular.ttf",
    .codes   =  codes_for_font_NotoSansPsalterPahlavi_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansImperialAramaic-Regular.ttf",
    .codes   =  codes_for_font_NotoSansImperialAramaic_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOldNorthArabian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOldNorthArabian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansOldSouthArabian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansOldSouthArabian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTamilSupplement-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTamilSupplement_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTifinaghAhaggar-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTifinaghAhaggar_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTifinaghAzawagh-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTifinaghAzawagh_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansZanabazarSquare-Regular.ttf",
    .codes   =  codes_for_font_NotoSansZanabazarSquare_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansCaucasianAlbanian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansCaucasianAlbanian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansIndicSiyaqNumbers-Regular.ttf",
    .codes   =  codes_for_font_NotoSansIndicSiyaqNumbers_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTifinaghRhissaIxa-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTifinaghRhissaIxa_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansCanadianAboriginal-Regular.ttf",
    .codes   =  codes_for_font_NotoSansCanadianAboriginal_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansEgyptianHieroglyphs-Regular.ttf",
    .codes   =  codes_for_font_NotoSansEgyptianHieroglyphs_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTifinaghTawellemmet-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTifinaghTawellemmet_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansAnatolianHieroglyphs-Regular.ttf",
    .codes   =  codes_for_font_NotoSansAnatolianHieroglyphs_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansInscriptionalPahlavi-Regular.ttf",
    .codes   =  codes_for_font_NotoSansInscriptionalPahlavi_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansInscriptionalParthian-Regular.ttf",
    .codes   =  codes_for_font_NotoSansInscriptionalParthian_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoSansTifinaghAgrawImazighen-Regular.ttf",
    .codes   =  codes_for_font_NotoSansTifinaghAgrawImazighen_Regular,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  "/usr/share/fonts/truetype/noto/NotoColorEmoji.ttf",
    .codes   =  codes_for_font_NotoColorEmoji,
    .face    =  0,
    .height  =  0
  },
  {
    .name    =  0,
    .codes   =  0,
    .face    =  0,
    .height  =  0
  },
};
