
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef DOCUMENT_WINDOW_HH
#define DOCUMENT_WINDOW_HH

#include "draw_text.hh"
#include "multiwindow.hh"

class document_window : public multiwindow
{
public:
  char             name[100];
  char             directory[200];
  char             full_directory[500];

  int              num_pages;
  int              current_page;
  int              last_current_page;
  
  bool             active;

  int              svg_width;
  int              svg_height;
  
  int              draw_width;
  int              draw_height;
  
  int              center_x;
  int              center_y;
  double           zoom;
  double           last_zoom;

  int              selected_x;
  int              selected_y;
  int              selected_center_x;
  int              selected_center_y;
  double           selected_zoom;
  double           selected_h;
  int              selected_page;
  
  bool             draw_grid;
  bool             draw_page_number;
  bool             page_absolute;

  int              delayed_redraw_count;

  virtual void  layout();
  virtual void  draw_dirty();

  virtual bool  handle_event(my_event& me);

  document_window(const char* directory, const char* document_name, color bg=BLACK);
  virtual ~document_window();

  virtual void draw_dynamic();
};




#endif
