
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef DRAW_TEXT_HH
#define DRAW_TEXT_HH


#include "color.hh"

class panel;


#define DRAW_TEXT_X_LEFT     0x00
#define DRAW_TEXT_X_CENTER   0x01
#define DRAW_TEXT_X_RIGHT    0x02
#define DRAW_TEXT_X_MASK     0x03

#define DRAW_TEXT_Y_BOTTOM   0x00
#define DRAW_TEXT_Y_CENTER   0x10
#define DRAW_TEXT_Y_TOP      0x20
#define DRAW_TEXT_Y_MASK     0x30

#define DRAW_TEXT_ROTATE_0        0x000
#define DRAW_TEXT_ROTATE_90_LEFT  0x100
#define DRAW_TEXT_ROTATE_90_RIGHT 0x200
#define DRAW_TEXT_ROTATE_MASK     0x300

#define MAX_COLORS 22

struct dt_colors
{
  color c[MAX_COLORS];
};

//
// Put these in the middle of two strings to switch color to the
// specified color number in dt_colors.  This is when printing
// text with draw_multicolored_text().
//
#define DT_COLOR_0  "\x0A"
#define DT_COLOR_1  "\x0B"
#define DT_COLOR_2  "\x0C"
#define DT_COLOR_3  "\x0D"
#define DT_COLOR_4  "\x0E"
#define DT_COLOR_5  "\x0F"
#define DT_COLOR_6  "\x10"
#define DT_COLOR_7  "\x11"
#define DT_COLOR_8  "\x12"
#define DT_COLOR_9  "\x13"
#define DT_COLOR_10 "\x14"
#define DT_COLOR_11 "\x15"
#define DT_COLOR_12 "\x16"
#define DT_COLOR_13 "\x17"
#define DT_COLOR_14 "\x18"
#define DT_COLOR_15 "\x19"
#define DT_COLOR_16 "\x1A"
#define DT_COLOR_17 "\x1B"
#define DT_COLOR_18 "\x1C"
#define DT_COLOR_19 "\x1D"
#define DT_COLOR_20 "\x1E"
#define DT_COLOR_21 "\x1F"

//
// Here, T could be char, or wchar_t, or char16_t, or char32_t
//
// if T is char, it's UTF8.
//

template <typename T> void global_draw_text(const T*   text,
					    color      c,
					    panel*     p,
					    int        x,
					    int        y,
					    int        flags = 0);

//
// multicolor text uses control codes x = 10 (0x0A) and up to indicate a switch to color
// c[x-10].
//
template <typename T> void global_draw_multicolored_text(const T*   text,
							 dt_colors& c,
							 int        start_color,
							 panel*     p,
							 int        x,
							 int        y,
							 int        flags = 0);


template <typename T> void global_draw_multicolored_text(const T*    text,
							 dt_colors&  c,
							 panel*      p,
							 int         x,
							 int         y,
							 int         flags = 0)
{
  global_draw_multicolored_text(text, c, 0, p, x, y, flags);
}

template <typename T> int global_calculate_text_width(const T* text);
template <typename T> int global_calculate_text_height(const T* text);

void global_set_text_size(int height_pixels);
int  global_get_text_size();


#endif
