
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef GRAPH_DATA_HH
#define GRAPH_DATA_HH

//
// This contains the data to graph, or an error message if the
// data is bad.
//

#include "dataset.hh"
#include "color.hh"
#include "multilingua.hh"

class graph_data
{
public:

  constexpr static int MAX_DATASETS      = 13;
  constexpr static int MAX_STRING_LENGTH = 200;

  int              max_datasets;  // Maximum datasets for which memory is allocated
  int              num_datasets;  // Number of datasets currently in this graph data

  int              num_points;
  
  double           x_data_start;
  double           x_data_step;
  
  dataset**        y_data;

  template<class TXT> void set_error_text(const TXT* text, int language=0);
  void find_ymin_ymax (double& ymin, double& ymax);

  graph_data(int max_datasets, int num_points, double x_data_start, double x_data_step);
  ~graph_data();

  // if first character is non-null, error_text will be displayed instead of a graph.
  multilingua error_text;
};


//
// Accepts TXT of char, wchar_t, char16_t, or char32_t
//
template<class TXT> void graph_data::set_error_text(const TXT* text, int language)
{
  error_text.set_text(text, language);
}



#endif
