
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef HOTSPOT_HH
#define HOTSPOT_HH

#include "window.hh"

//
// The hotspot is a transparent window, used by its parent window for implementing buttons
// that are drawn (or not drawn) by the parent.  For example, the parent may have some text,
// and cover that text with a hotspot for handling events of touching that text.
//
// The parent is some class derived from a multiwindow.
//
// draw_hotspots and unhandled_button_press_event_time are used to highlight areas where
// the user can interact with the screen.  This isn't just hotspots, but anything that
// can be clicked on.  Since hotspots are a primary item, these variables are here
// (for now).  In some cases we might not want a hotspot to be highlighted in this way.
// In that case we can set draw_this_hotspot to false.
//
// Unlike most windows, hotspots aren't layed out in normal fashion -- they go on top
// of other things.  So window_subject_to_layout is false.  This doesn't mean that
// resize() isn't called, but rather (by default) that it is called with the entire area of the
// parent window, so that the hotspot can put itself in the correct place (assuming it
// has enough data to do so), and whatever
// layout is done on the hotspot is ignored regarding placement of other windows.
// Typically, the layout() function of the parent specifies an exact area for the hotspot
// with custom code.  It is also possible to use hotspot_percent to specify
// placement as percentages of the parent window.

extern bool draw_hotspots;
extern struct timeval unhandled_button_press_event_time;


class hotspot : public window
{
public:
  
  typedef bool hotfunc(hotspot* hotspot, my_event&me, void* data);

  hotfunc*  event_handling_function;
  void*     data;
  bool      draw_this_hotspot;
	  
  virtual void   draw_static     (panel* p = 0);
  virtual void   draw_dynamic    ();
  virtual void   draw_dirty      ();

  virtual bool   handle_event(my_event& me);
  
  hotspot(hotfunc*  event_handling_function,
	  void*     data,
	  bool      draw_this_hotspot=true);
  
  virtual ~hotspot();
};


#endif
