
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef MENU_HH
#define MENU_HH

#include "multiwindow.hh"
#include "layout.hh"
#include "global_beep.hh"
#include "draw_text.hh"
#include "all_svg.hh"
#include "backing_panel.hh"
#include "menu_item.hh"

//
// When a menu draws, it draws all tags of its children.  It draws at most one of the
// actual children -- and only the selected one.
//
// All children of class menu need to be dervived from class menu_item.
//
class menu : public multiwindow
{
private:
  // Disallow the multiwindow add method.  Use menu's instead.
  void add(window* win, bool stealthy = false);

  List<menu_item> mil;
  
public:

  color GROUPCOLOR;
  color TAGCOLOR;
  color TEXTCOLOR;
  color SELECTEDCOLOR;
  color ACTIONTEXTCOLOR;
  color DISABLEDTEXTCOLOR;
  
  int selected_y_offset;

  int top_margin;
  int bottom_margin;
  int left_margin;
  int right_margin;
  int mw_margin;

  int selection_margin;
  int tag_top_margin;
  int tag_bottom_margin;
  int tag_left_margin;
  int tag_right_margin;
  int tag_left_offset;
  int tag_right_offset;

  int item_area_height;
  int item_max_spacing;

  int tag_font_height;
  int tag_spacing;
  int tag_bottom_offset;
  int max_tag_width;
  int mw_left_edge;

  int selected_num;    // -1 if none selected

  bool redraw_all;
  
  virtual int       tag_largest_width(int font_height);
  virtual void      draw_tag(menu_item* m, bool selected);
  
  virtual void      select_a_child(int num);
  virtual void      deselect_a_child();

  virtual bool      handle_event(my_event& me);

  virtual void      layout();
  virtual void      draw_dirty();
  virtual void      draw_dynamic();

  virtual int       get_selected_y_offset();

  // Use this add method for normal menu_items.
  template <typename T> menu_item* add(T* name, color bg = BLACK);

  // Use this add method if menu_item is extended,
  // for example with modified layout()
  void add(menu_item* m) { multiwindow::add(m); mil.addAtEnd(m, true /* autodelete */); }

  // menu_item uses this add method when it needs to
  // add items to its parent.
  void add_by_menu_item(window* w) { multiwindow::add(w); }

  menu(color bg=BLACK);
  virtual ~menu();
};


template <typename T> menu_item* menu::add(T* name, color bgcolor)
{
  menu_item* mi = new menu_item(name, bgcolor);
  add(mi);
  return mi;
}


#endif
