
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef MENU_ITEM_HH
#define MENU_ITEM_HH

#include "multiwindow.hh"
#include "multilingua.hh"

typedef void select_function(int number, class menu* m, class menu_item* mi, void* data);

//
// This is a helper class for the menu class.
//
// If the multiwindow contains any items and it is selected, the
// multiwindow appears.
//
// If sf is nonzero:  when selected, this function is called.
// If sf is nonzero, the multiwindow is never displayed, unless
// as one of its actions the function selects it.
//

class menu_item : public window
{
public:
  constexpr static int STRING_LENGTH = 200;
  
  multilingua       name;
  select_function*  sf;
  void*             data;
  multiwindow*      mw;
  color             bgcolor;

  virtual void add(window* win);

  //
  // The menu_item is bypassed for drawing and layout.
  // Instead, this is handled at the menu level.
  //
  virtual void draw_dirty()   {}
  virtual void layout()       {}
  virtual void draw_dynamic() {}

  void set_function(select_function* sf, void* data) { this->sf = sf; this->data = data; }
  
  menu_item(color bgcolor=BLACK);
  template <typename T> void set_name(T* name, int language=0);
  ~menu_item();
};


template <typename T> void menu_item::set_name(T* name, int language)
{
  this->name.set_text(name, language);
}
  
#endif
