
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef MULTIWINDOW_MULTIPANE_HH
#define MULTIWINDOW_MULTIPANE_HH

#include "multiwindow.hh"

class multiwindow_multipane : public multiwindow
{
public:

  int num_panes;
  
  int*            num_subwindows_each_pane;
  List<window>**  subwindows_each_pane;
  layout_plan**   layout_calculator_each_pane;

  int             current_pane;

  void            add                    (window* win, bool stealthy=false)  { multiwindow::add(win, stealthy); }
  void            add                    (window* win, int pane);

  void            set_current_pane       (int pane, bool stealthy=false);
  void            next_pane              ();
  void            previous_pane          ();
  virtual void    pane_change            () {}  // Called when the pane changes so derived classes can take actions

                  multiwindow_multipane  (color bg, int num_panes);
  virtual        ~multiwindow_multipane  ();
};


#endif
