
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef NUMBER_BOX_HH
#define NUMBER_BOX_HH

#include "window.hh"
#include "global_beep.hh"
#include "draw_text.hh"
#include "event_types.hh"
#include "send_events.hh"
#include "axis_scale.hh"
#include "multilingua.hh"
#include "unalingua.hh"

struct number_box_unit
{
  multilingua name;
  double      scale;  // To convert a number N to these units, do scale*N + offset
  double      offset;
};

class number_box : public window, public sending_base_class<double, int>
{
public:

  color            BG_COLOR;
  color            FG_COLOR;
  color            NUM_COLOR;
  color            TEXT_COLOR;
  color            GROUPCOLOR;
  color            TITLECOLOR;
  
  int              top_margin;
  int              bottom_margin;
  int              left_margin;
  int              right_margin;

  int              between_x_margin;
  int              number_width;
  int              title_bottom_margin;
  int              between_y_margin;

  int              font_height;
  int              circle_width;
  int              highlight_count;

  int              number_x_margin;
  int              number_y_margin;
  
  multilingua      name;

  double*          value;

  const number_box_unit*  unit_list;
  int                     num_units;
  int                     num_units_to_display;

  bool                    scalar;
  bool                    integer_only;
  
  int              text_max_width;

  double           min_value;
  double           max_value;

  multilingua      min_text;
  multilingua      max_text;

  virtual void     layout();
  virtual void     draw_dirty();
  virtual void     draw_dynamic();

  virtual bool     handle_event(my_event& me);


  bool             get_number(const char* text, int num_selected);

  bool             number_ok(double value);

  template<typename T> void set_name(const T* name, int language);

  // For scalars, set unit_list to zero.  Then num_units and num_units_to_display are ignored.
                   number_box(multilingua&            name,
			      double&                 value,
			      double                  min_value,
			      double                  max_value,
			      multilingua&            min_text,
			      multilingua&            max_text,
			      bool                    integer_only,
			      const number_box_unit*  unit_list,
			      int                     num_units,
			      int                     num_units_to_display,
			      color                   textcolor,
			      color                   fg,
			      color                   bg=BLACK);
  
                   ~number_box();
};


#endif
