
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef SELECT_ONE_HH
#define SELECT_ONE_HH

#include "multiselect.hh"

class select_one : public multiselect
{
public:

  virtual void      select_no_event(int num);
  virtual void      select(int num);
  virtual void      deselect(int num);

  void add(multilingua& item_name, bool start_selected=false, bool disabled=false);

  virtual void draw_dynamic();

  int get_item_number_selected();
  
  select_one(multilingua& title, color bg=BLACK);
  ~select_one();
};


#endif
