
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef SVG_WINDOW_HH
#define SVG_WINDOW_HH

#include "panel.hh"
#include "subpanel.hh"
#include "color.hh"
#include "point.hh"

#include "window.hh"
#include "List.hh"
#include "layout.hh"

class svg_window : public window
{
public:
  uint8_t* svg_data;
  int      svg_data_length;
  
  virtual void layout ();

  svg_window(uint8_t* svg_data, int svg_data_length, color bg=BLACK);
  virtual ~svg_window();
};



inline svg_window::svg_window(uint8_t* svg_data, int svg_data_length, color bg) : window(bg)
{
  this->svg_data         = svg_data;
  this->svg_data_length  = svg_data_length;
}


inline svg_window::~svg_window()
{
}


inline void svg_window::layout()
{
  clear(bgcolor);
  draw_svg_from_data(svg_data, svg_data_length);
}



#endif
