
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef UNALINGUA_HH
#define UNALINGUA_HH

char32_t* new_UTF32(const char*     text);
char32_t* new_UTF32(const wchar_t*  text);
char32_t* new_UTF32(const char16_t* text);
char32_t* new_UTF32(const char32_t* text);

#include "multilingua.hh"

char* new_UTF8(const char32_t* t);


class unalingua
{
public:
  
  void set_text(const multilingua& text) { set_text((const char32_t*)text); }
  void set_text(const unalingua& text)   { set_text((const char32_t*)text); }
  template <typename T> void set_text(const T* text);

  void append_text(const multilingua& text) { append_text((const char32_t*)text); }
  void append_text(const unalingua& text)   { append_text((const char32_t*)text); }
  template <typename T> void append_text(const T* text);

  const char32_t* get_text();

  void operator=(const multilingua& text) { set_text((const char32_t*)text); }
  void operator=(const unalingua& text)   { set_text((const char32_t*)text); }
  template <typename T> void operator=(const T* text)           { set_text(text); }

  operator const char32_t*() const;

  unalingua();
  unalingua(const multilingua& text);
  unalingua(const unalingua& text);
  template <typename T> unalingua(const T* text);
  ~unalingua();

private:
  char32_t* text;
};


template <typename T> unalingua::unalingua(const T* text)
{
  this->text = 0;
  set_text(text);
}


template <typename T> void unalingua::set_text(const T* text)
{
  if(text==0)
    {
      set_text("");
    }
  else
    {
      this->text = new_UTF32(text);
    }
}


template <typename T> void unalingua::append_text(const T* text)
{
  if(!this->text)
    {
      set_text(text);
      return;
    }
  
  int old_length = 0;
  for(;;old_length++)
    {
      if(!this->text[old_length])
	break;
    }

  char32_t* added_text = new_UTF32(text);
  
  int length = 0;
  for(;;length++)
    {
      if(!added_text[length])
	break;
    }

  char32_t* new_text = new char32_t[old_length + length + 1];

  int i;
  for(i=0; i<old_length; i++)
    new_text[i] = this->text[i];

  for(int j=0; j<length; j++)
    new_text[i+j] = added_text[j];

  new_text[length+old_length] = 0;

  delete [] this->text;
  delete [] added_text;

  this->text = new_text;
}


#endif
